/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.voice;

import com.arrl.radiocraft.api.blockentities.radio.IVoiceTransmitter;
import com.arrl.radiocraft.common.radio.VoiceTransmitters;
import com.arrl.radiocraft.common.radio.voice.EncodingManager;
import com.arrl.radiocraft.common.radio.voice.handheld.PlayerRadioManager;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.PlayerDisconnectedEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.List;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@ForgeVoicechatPlugin
public class RadiocraftVoicePlugin
implements VoicechatPlugin {
    public static VoicechatServerApi API = null;
    public static EncodingManager encodingManager = new EncodingManager();

    public String getPluginId() {
        return "radiocraft";
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophonePacket, 0);
        registration.registerEvent(PlayerDisconnectedEvent.class, this::onPlayerDisconnected, 0);
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStart, 0);
    }

    public void onServerStart(VoicechatServerStartedEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMicrophonePacket(MicrophonePacketEvent event) {
        VoicechatConnection connection;
        if (API == null) {
            API = event.getVoicechat();
        }
        if ((connection = event.getSenderConnection()) == null) {
            return;
        }
        ServerPlayer sender = connection.getPlayer();
        Object object = sender.getPlayer();
        if (object instanceof net.minecraft.server.level.ServerPlayer) {
            net.minecraft.server.level.ServerPlayer player = (net.minecraft.server.level.ServerPlayer)object;
            EncodingManager.EncodingData encodingData = encodingManager.getOrCreate(sender.getUuid());
            byte[] encodedAudio = ((MicrophonePacket)event.getPacket()).getOpusEncodedData();
            short[] decodedAudio = encodingData.getDecoder().decode(encodedAudio);
            if (encodedAudio.length == 0) {
                encodingData.reset();
            } else {
                PlayerRadioManager.get(sender.getUuid()).ifPresent(playerRadio -> playerRadio.acceptVoicePacket(sender.getServerLevel(), decodedAudio, sender.getUuid()));
                double sqrRange = API.getBroadcastRange();
                sqrRange *= sqrRange;
                List<IVoiceTransmitter> listeningMics = VoiceTransmitters.LISTENERS.get((Level)sender.getServerLevel().getServerLevel());
                if (listeningMics != null) {
                    List<IVoiceTransmitter> listeningMicsCopy;
                    List<IVoiceTransmitter> list = listeningMics;
                    synchronized (list) {
                        listeningMicsCopy = List.copyOf(listeningMics);
                    }
                    for (IVoiceTransmitter listener : listeningMicsCopy) {
                        Vec3 pos = listener.getPos();
                        Position playerPos = sender.getPosition();
                        if (pos.distanceToSqr(new Vec3(playerPos.getX(), playerPos.getY(), playerPos.getZ())) > sqrRange || !listener.canTransmitVoice()) continue;
                        listener.acceptVoicePacket(sender.getServerLevel(), decodedAudio, sender.getUuid());
                    }
                }
            }
        }
    }

    public void onPlayerDisconnected(PlayerDisconnectedEvent event) {
        encodingManager.close(event.getPlayerUuid());
    }
}

