/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.voice.handheld;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.radio.IVoiceReceiver;
import com.arrl.radiocraft.common.radio.antenna.AntennaVoicePacket;
import com.arrl.radiocraft.common.radio.voice.RadiocraftVoicePlugin;
import de.maxhenkel.voicechat.api.audiochannel.EntityAudioChannel;
import java.util.UUID;
import net.minecraft.world.entity.Entity;

public class HandheldVoiceReceiver
implements IVoiceReceiver {
    private EntityAudioChannel receiveChannel = null;
    private final Entity entity;
    private boolean isReceiving;

    public HandheldVoiceReceiver(Entity entity) {
        this(entity, false);
    }

    public HandheldVoiceReceiver(Entity entity, boolean isReceiving) {
        this.isReceiving = isReceiving;
        this.entity = entity;
    }

    public void openChannel() {
        if (RadiocraftVoicePlugin.API == null) {
            Radiocraft.LOGGER.error("Radiocraft VoiceChatServerApi is null.");
        }
        this.receiveChannel = RadiocraftVoicePlugin.API.createEntityAudioChannel(UUID.randomUUID(), RadiocraftVoicePlugin.API.fromEntity((Object)this.entity));
    }

    @Override
    public void receive(AntennaVoicePacket antennaPacket) {
        if (this.isReceiving) {
            if (this.receiveChannel == null) {
                this.openChannel();
            }
            short[] rawAudio = antennaPacket.getRawAudio();
            for (int i = 0; i < rawAudio.length; ++i) {
                rawAudio[i] = (short)Math.round((double)rawAudio[i] * antennaPacket.getStrength());
            }
            byte[] opusAudio = RadiocraftVoicePlugin.encodingManager.getOrCreate(antennaPacket.getSourcePlayer()).getEncoder().encode(rawAudio);
            this.receiveChannel.send(opusAudio);
        }
    }

    @Override
    public boolean isReceiving() {
        return this.isReceiving;
    }

    @Override
    public void setReceiving(boolean value) {
        this.isReceiving = value;
    }
}

