/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.voice.handheld;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.antenna.IAntenna;
import com.arrl.radiocraft.api.antenna.IAntennaType;
import com.arrl.radiocraft.api.blockentities.radio.IVoiceTransmitter;
import com.arrl.radiocraft.api.capabilities.IVHFHandheldCapability;
import com.arrl.radiocraft.common.capabilities.RadiocraftCapabilities;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import com.arrl.radiocraft.common.radio.Band;
import com.arrl.radiocraft.common.radio.BandUtils;
import com.arrl.radiocraft.common.radio.IVoiceReceiver;
import com.arrl.radiocraft.common.radio.antenna.AntennaCWPacket;
import com.arrl.radiocraft.common.radio.antenna.AntennaData;
import com.arrl.radiocraft.common.radio.antenna.AntennaNetwork;
import com.arrl.radiocraft.common.radio.antenna.AntennaVoicePacket;
import com.arrl.radiocraft.common.radio.antenna.networks.AntennaNetworkManager;
import com.arrl.radiocraft.common.radio.antenna.types.RubberDuckyAntennaType;
import com.arrl.radiocraft.common.radio.antenna.types.data.RubberDuckyAntennaData;
import com.arrl.radiocraft.common.radio.morse.CWBuffer;
import com.arrl.radiocraft.common.radio.voice.RadiocraftVoicePlugin;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.audiochannel.EntityAudioChannel;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerRadio
implements IVoiceTransmitter,
IVoiceReceiver,
IAntenna {
    private EntityAudioChannel receiveChannel = null;
    private WeakReference<Player> playerRef = null;
    private volatile AntennaNetwork network = null;
    private volatile List<SynchronousRadioState> radios = Collections.emptyList();
    private final AtomicReference<IAntenna.AntennaPos> antennaPos = new AtomicReference();
    private volatile Vec3 voicePosition;
    private volatile Level voiceLevel;
    private boolean isUseHeld;

    public void setUseHeld(boolean useHeld) {
        this.isUseHeld = useHeld;
    }

    public PlayerRadio(Player player) {
        this.setPlayer(player);
    }

    @Override
    public Player getPlayer() {
        return this.playerRef == null ? null : (Player)this.playerRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayer(Player player) {
        PlayerRadio playerRadio = this;
        synchronized (playerRadio) {
            this.playerRef = new WeakReference<Player>(player);
            this.tick();
        }
        if (player != null) {
            this.setNetwork(AntennaNetworkManager.getNetwork(AntennaNetworkManager.VHF_ID));
        } else if (this.network != null) {
            this.network.removeAntenna(this);
            this.network = null;
        }
    }

    protected List<SynchronousRadioState> genHandheldStates(Player player) {
        IVHFHandheldCapability cap;
        Inventory playerInventory = player.getInventory();
        LinkedList<SynchronousRadioState> out = new LinkedList<SynchronousRadioState>();
        ItemStack offhand = player.getOffhandItem();
        if (offhand.getItem() == RadiocraftItems.VHF_HANDHELD.get() && (cap = (IVHFHandheldCapability)offhand.getCapability(RadiocraftCapabilities.VHF_HANDHELDS)) != null) {
            out.add(new SynchronousRadioState(offhand, cap, HandheldLocation.HELD));
        }
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            IVHFHandheldCapability cap2;
            ItemStack itemStack = player.getInventory().getItem(i);
            if (itemStack.getItem() != RadiocraftItems.VHF_HANDHELD.get() || (cap2 = (IVHFHandheldCapability)itemStack.getCapability(RadiocraftCapabilities.VHF_HANDHELDS)) == null) continue;
            if (i == playerInventory.selected) {
                out.addFirst(new SynchronousRadioState(itemStack, cap2.isPowered(), cap2.isPowered() && (cap2.isPTTDown() || this.isUseHeld), cap2.getFrequencyHertz(), HandheldLocation.HELD, cap2.getGain(), cap2.getMicGain()));
                continue;
            }
            out.addLast(new SynchronousRadioState(itemStack, cap2, Inventory.isHotbarSlot((int)i) ? HandheldLocation.HOT_BAR : HandheldLocation.BACKPACK));
        }
        return out;
    }

    @Override
    public Vec3 getPos() {
        return this.voicePosition;
    }

    @Override
    public IAntenna.AntennaPos getAntennaPos() {
        return this.antennaPos.get();
    }

    @Override
    public IAntennaType<? extends AntennaData> getType() {
        return new RubberDuckyAntennaType();
    }

    @Override
    public AntennaData getData() {
        return new RubberDuckyAntennaData(0.155);
    }

    @Override
    public void transmitCWPacket(net.minecraft.server.level.ServerLevel level, Collection<CWBuffer> buffers, Band band, float frequencyHertz) {
    }

    @Override
    public void receiveCWPacket(AntennaCWPacket packet) {
    }

    @Override
    public synchronized boolean isReceiving() {
        for (SynchronousRadioState state : this.radios) {
            if (!state.canReceive) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setReceiving(boolean value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitAudioPacket(ServerLevel level, short[] rawAudio, Band band, float frequencyHertz, UUID sourcePlayer) {
        AntennaNetwork network;
        PlayerRadio playerRadio = this;
        synchronized (playerRadio) {
            network = this.network;
        }
        if (network != null) {
            HashSet<IAntenna> antennas;
            IAntenna.AntennaPos thisPos = this.getAntennaPos();
            if (thisPos == null || thisPos.level() == null) {
                return;
            }
            if (!thisPos.level().equals(level.getServerLevel())) {
                return;
            }
            Set<IAntenna> masterSet = network.allAntennas();
            Set<IAntenna> set = masterSet;
            synchronized (set) {
                antennas = new HashSet<IAntenna>(masterSet);
            }
            for (IAntenna antenna : antennas) {
                if (antenna == this) continue;
                AntennaVoicePacket packet = new AntennaVoicePacket(level, (short[])rawAudio.clone(), band, frequencyHertz, 1.0, this, sourcePlayer);
                IAntenna.AntennaPos pos = antenna.getAntennaPos();
                if (pos == null) continue;
                double distance = Math.sqrt(thisPos.position().distSqr((Vec3i)pos.position()));
                packet.setStrength(BandUtils.getBaseStrength(packet.getBand(), distance, 1.0, 0.0, packet.getLevel().isDay()));
                antenna.receiveAudioPacket(packet);
            }
        }
    }

    @Override
    public synchronized boolean canTransmitVoice() {
        for (SynchronousRadioState state : this.radios) {
            if (!state.canTransmit) continue;
            return true;
        }
        return false;
    }

    public boolean openChannel() {
        if (RadiocraftVoicePlugin.API == null) {
            Radiocraft.LOGGER.error("VoiceChatServerApi is null, cannot open channel.");
        }
        this.receiveChannel = RadiocraftVoicePlugin.API.createEntityAudioChannel(this.getPlayer().getUUID(), RadiocraftVoicePlugin.API.fromEntity((Object)this.getPlayer()));
        if (this.receiveChannel == null) {
            return false;
        }
        this.receiveChannel.setDistance(16.0f);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptVoicePacket(ServerLevel level, short[] rawAudio, UUID sourcePlayer) {
        LinkedList<SynchronousRadioState> currentlyTransmitting = new LinkedList<SynchronousRadioState>();
        PlayerRadio playerRadio = this;
        synchronized (playerRadio) {
            for (SynchronousRadioState radio : this.radios) {
                if (!radio.canTransmit) continue;
                currentlyTransmitting.add(radio);
            }
        }
        for (SynchronousRadioState radio : currentlyTransmitting) {
            short[] audio = (short[])rawAudio.clone();
            for (int i = 0; i < audio.length; ++i) {
                audio[i] = (short)Math.round((float)audio[i] * radio.micGain);
            }
            this.transmitAudioPacket(level, audio, Band.getBand("2m"), radio.frequency, sourcePlayer);
        }
    }

    @Override
    public void receiveAudioPacket(AntennaVoicePacket packet) {
        if (this.isReceiving()) {
            this.receive(packet);
        }
    }

    @Override
    public synchronized void receive(AntennaVoicePacket antennaPacket) {
        if (this.isReceiving()) {
            Player player = this.getPlayer();
            if (this.receiveChannel == null && !this.openChannel()) {
                return;
            }
            if (this.receiveChannel.getEntity().getEntity() != player) {
                this.receiveChannel.flush();
                this.receiveChannel.updateEntity(RadiocraftVoicePlugin.API.fromEntity((Object)player));
            }
            float packetFrequency = antennaPacket.getFrequency();
            double packetStrength = antennaPacket.getStrength();
            boolean isHeld = false;
            boolean shouldRecieve = false;
            float gain = 1.0f;
            for (SynchronousRadioState state : this.radios) {
                boolean inReasonableRange = BandUtils.areFrequenciesEqualWithTolerance(state.frequency, packetFrequency, 1000.0f);
                if (state.canReceive && inReasonableRange) {
                    shouldRecieve = true;
                    if (state.itemLocation == HandheldLocation.HELD) {
                        isHeld = true;
                    }
                }
                gain = state.gain;
            }
            if (!shouldRecieve) {
                return;
            }
            long runningTotal = 0L;
            short[] rawAudio = antennaPacket.getRawAudio();
            for (int i = 0; i < rawAudio.length; ++i) {
                short sample = (short)Math.round((double)rawAudio[i] * packetStrength * (double)(isHeld ? 1.0f : 0.5f) * (double)gain);
                runningTotal = sample * sample;
                rawAudio[i] = sample;
            }
            for (SynchronousRadioState state : this.radios) {
                boolean inReasonableRange = BandUtils.areFrequenciesEqualWithTolerance(state.frequency, packetFrequency, 1000.0f);
                if (!state.canReceive || !inReasonableRange) continue;
                state.runningSampleCount += (long)rawAudio.length;
                state.runningSampleSum += runningTotal;
            }
            byte[] opusAudio = RadiocraftVoicePlugin.encodingManager.getOrCreate(antennaPacket.getSourcePlayer()).getEncoder().encode(rawAudio);
            this.receiveChannel.send(opusAudio);
        }
    }

    public void setNetwork(AntennaNetwork network) {
        if (this.network != null) {
            this.network.removeAntenna(this);
        }
        network.addAntenna(this);
        this.network = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<SynchronousRadioState> lastTickRadios;
        Player player = this.getPlayer();
        List radios = player == null ? Collections.emptyList() : this.genHandheldStates(player);
        PlayerRadio playerRadio = this;
        synchronized (playerRadio) {
            lastTickRadios = this.radios;
            this.radios = radios;
            if (radios.isEmpty()) {
                this.voicePosition = null;
                this.voiceLevel = null;
                this.antennaPos.set(null);
            } else {
                this.voicePosition = player.getEyePosition();
                this.voiceLevel = player.level();
                this.antennaPos.set(new IAntenna.AntennaPos(player.blockPosition(), player.level()));
            }
        }
        for (SynchronousRadioState state : lastTickRadios) {
            IVHFHandheldCapability cap;
            if (state.item == null || (cap = (IVHFHandheldCapability)state.item.getCapability(RadiocraftCapabilities.VHF_HANDHELDS)) == null) continue;
            cap.setReceiveStrength(state.runningSampleCount == 0L ? 0.0f : (float)Math.sqrt((double)state.runningSampleSum / (double)state.runningSampleCount));
        }
    }

    protected static class SynchronousRadioState {
        final ItemStack item;
        final HandheldLocation itemLocation;
        final boolean canReceive;
        final boolean canTransmit;
        final float frequency;
        final float gain;
        final float micGain;
        volatile long runningSampleSum = 0L;
        volatile long runningSampleCount = 0L;

        public SynchronousRadioState(ItemStack item, boolean canReceive, boolean canTransmit, float frequency, HandheldLocation itemLocation, float gain, float micGain) {
            this.item = item;
            this.canReceive = canReceive;
            this.canTransmit = canTransmit;
            this.frequency = frequency;
            this.itemLocation = itemLocation;
            this.gain = gain;
            this.micGain = micGain;
        }

        public SynchronousRadioState(ItemStack item, IVHFHandheldCapability cap, HandheldLocation itemLocation) {
            this(item, cap.isPowered(), cap.isPowered() && cap.isPTTDown(), cap.getFrequencyHertz(), itemLocation, cap.getGain(), cap.getMicGain());
        }
    }

    protected static enum HandheldLocation {
        HELD,
        HOT_BAR,
        BACKPACK;

    }
}

