/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.voice.handheld;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.radio.voice.handheld.PlayerRadio;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="radiocraft")
public class PlayerRadioManager {
    private static final Map<UUID, PlayerRadio> playerRadios = new ConcurrentHashMap<UUID, PlayerRadio>();

    public static Optional<PlayerRadio> get(UUID uuid) {
        return Optional.ofNullable(playerRadios.get(uuid));
    }

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        playerRadios.put(player.getUUID(), new PlayerRadio(player));
        Radiocraft.LOGGER.debug("Player radio added for {} uuid {}", (Object)player.getName(), (Object)player.getUUID());
    }

    @SubscribeEvent
    public static void onPlayerLeft(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID uuid = event.getEntity().getUUID();
        PlayerRadioManager.get(uuid).ifPresentOrElse(u -> u.setPlayer(null), () -> Radiocraft.LOGGER.error("Player radio was null on leave, onPlayerJoined not called? Player: {} uuid {}", (Object)event.getEntity().getName(), (Object)event.getEntity().getUUID()));
        Radiocraft.LOGGER.debug("Player radio removed for {} uuid {}", (Object)event.getEntity().getName(), (Object)event.getEntity().getUUID());
        playerRadios.remove(uuid);
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            PlayerRadioManager.get(event.getOriginal().getUUID()).ifPresentOrElse(r -> r.setPlayer(event.getEntity()), () -> {
                playerRadios.put(event.getEntity().getUUID(), new PlayerRadio(event.getEntity()));
                Radiocraft.LOGGER.error("Player radio was null on death, onPlayerJoined not called? Player: {}", (Object)event.getEntity().getName());
            });
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        for (PlayerRadio playerRadio : playerRadios.values()) {
            playerRadio.tick();
        }
    }
}

