/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.sounds;

import com.arrl.radiocraft.client.RadiocraftClientValues;
import com.arrl.radiocraft.common.blockentities.radio.RadioBlockEntity;
import com.arrl.radiocraft.common.init.RadiocraftSoundEvents;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;

public class RadioStaticSoundInstance
extends AbstractTickableSoundInstance {
    private final RadioBlockEntity radio;

    public RadioStaticSoundInstance(RadioBlockEntity radio) {
        super(RadiocraftSoundEvents.STATIC.get(), SoundSource.VOICE, SoundInstance.createUnseededRandom());
        this.radio = radio;
        this.looping = true;
        this.delay = 0;
        this.x = (double)radio.getBlockPos().getX() + 0.5;
        this.y = (double)radio.getBlockPos().getY() + 0.5;
        this.z = (double)radio.getBlockPos().getZ() + 0.5;
        this.volume = 1.0f;
    }

    public void tick() {
        if (this.radio.isRemoved()) {
            this.stop();
        } else {
            this.volume = this.radio.wasPowered() && this.radio.shouldPlayStatic() ? (float)((double)RadiocraftClientValues.NOISE_VOLUME * this.radio.getStaticVolume()) : 0.0f;
        }
    }

    public boolean canStartSilent() {
        return true;
    }
}

