/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.compat;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.entities.AntennaWire;
import com.arrl.radiocraft.common.entities.IAntennaWire;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum AntennaWireProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag data = blockAccessor.getServerData();
        int wireCount = data.getInt("wires");
        if (wireCount != 0) {
            iTooltip.add((Component)Component.literal((String)("Attached Wires: " + wireCount)));
            for (int i = 0; i < wireCount; ++i) {
                double length = data.getDouble("wire_" + i);
                iTooltip.add((Component)Component.literal((String)(String.format("%.2f", length) + "m")));
            }
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        Level level = blockAccessor.getLevel();
        BlockPos pos = blockAccessor.getPosition();
        List<IAntennaWire> wires = AntennaWire.getWires(level, pos);
        data.putInt("wires", wires.size());
        for (int i = 0; i < wires.size(); ++i) {
            data.putDouble("wire_" + i, wires.get(i).getLength());
        }
    }

    public ResourceLocation getUid() {
        return Radiocraft.id("antenna_wire");
    }
}

