/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.datagen;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.capabilities.LicenseClass;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.init.RadiocraftEntityTypes;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.apache.commons.lang3.text.WordUtils;

public class RadiocraftLanguageProvider
extends LanguageProvider {
    private final String locale;
    private static final Map<String, Consumer<LanguageProvider>> TRANSLATION_PROVIDERS = new HashMap<String, Consumer<LanguageProvider>>();

    public RadiocraftLanguageProvider(PackOutput output, String locale) {
        super(output, "radiocraft", locale);
        this.locale = locale;
    }

    protected void addTranslations() {
        TRANSLATION_PROVIDERS.get(this.locale).accept(this);
    }

    static {
        TRANSLATION_PROVIDERS.put("en_us", provider -> {
            provider.add(Radiocraft.translationKey("tabs", "main_tab"), "RadioCraft");
            provider.addItem(RadiocraftItems.RADIO_CRYSTAL, "Radio Crystal");
            provider.addItem(RadiocraftItems.RADIO_SPEAKER, "Radio Speaker");
            provider.addItem(RadiocraftItems.HAND_MICROPHONE, "Hand Microphone");
            provider.addItem(RadiocraftItems.HF_CIRCUIT_BOARD, "HF Circuit Board");
            provider.addItem(RadiocraftItems.SMALL_BATTERY, "Small Alkaline Battery");
            provider.addItem(RadiocraftItems.FERRITE_CORE, "Ferrite Core");
            provider.addItem(RadiocraftItems.COAXIAL_CORE, "Coaxial Core");
            provider.addItem(RadiocraftItems.ANTENNA_ANALYZER, "Antenna Analyzer");
            provider.addItem(RadiocraftItems.ANTENNA_WIRE, "Antenna Wire");
            provider.addItem(RadiocraftItems.VHF_HANDHELD, "VHF Handheld Radio");
            provider.addBlock(RadiocraftBlocks.WIRE, "Wire");
            provider.addBlock(RadiocraftBlocks.WATERPROOF_WIRE, "Waterproof Wire");
            provider.addBlock(RadiocraftBlocks.SOLAR_PANEL, "Solar Panel");
            provider.addBlock(RadiocraftBlocks.SOLAR_WEATHER_STATION, "Solar Weather Station");
            provider.addBlock(RadiocraftBlocks.LARGE_BATTERY, "Large Battery");
            provider.addBlock(RadiocraftBlocks.VHF_BASE_STATION, "VHF Base Station");
            provider.addBlock(RadiocraftBlocks.VHF_RECEIVER, "VHF Receiver");
            provider.addBlock(RadiocraftBlocks.VHF_REPEATER, "VHF Repeater");
            provider.addBlock(RadiocraftBlocks.HF_RADIO_10M, "HF Radio (10m)");
            provider.addBlock(RadiocraftBlocks.HF_RADIO_20M, "HF Radio (20m)");
            provider.addBlock(RadiocraftBlocks.HF_RADIO_40M, "HF Radio (40m)");
            provider.addBlock(RadiocraftBlocks.HF_RADIO_80M, "HF Radio (80m)");
            provider.addBlock(RadiocraftBlocks.HF_RECEIVER, "HF Receiver");
            provider.addBlock(RadiocraftBlocks.ALL_BAND_RADIO, "All Band Radio");
            provider.addBlock(RadiocraftBlocks.QRP_RADIO_20M, "QRP Radio (20m)");
            provider.addBlock(RadiocraftBlocks.QRP_RADIO_40M, "QRP Radio (40m)");
            provider.addBlock(RadiocraftBlocks.ANTENNA_POLE, "Antenna Pole");
            provider.addBlock(RadiocraftBlocks.DUPLEXER, "Duplexer");
            provider.addBlock(RadiocraftBlocks.ANTENNA_TUNER, "Antenna Tuner");
            provider.addBlock(RadiocraftBlocks.ANTENNA_CONNECTOR, "Antenna Connector");
            provider.addBlock(RadiocraftBlocks.BALUN_ONE_TO_ONE, "Balun (1:1)");
            provider.addBlock(RadiocraftBlocks.BALUN_TWO_TO_ONE, "Balun (2:1)");
            provider.addBlock(RadiocraftBlocks.COAX_WIRE, "Coaxial Wire");
            provider.addBlock(RadiocraftBlocks.DIGITAL_INTERFACE, "Digital Interface (TNC)");
            provider.addBlock(RadiocraftBlocks.CHARGE_CONTROLLER, "Charge Controller");
            provider.addBlock(RadiocraftBlocks.MICROPHONE, "Microphone");
            provider.addBlock(RadiocraftBlocks.YAGI_ANTENNA, "Yagi Antenna");
            provider.addBlock(RadiocraftBlocks.J_POLE_ANTENNA, "J-Pole Antenna");
            provider.addBlock(RadiocraftBlocks.SLIM_JIM_ANTENNA, "Slim Jim Antenna");
            provider.addEntityType(RadiocraftEntityTypes.ANTENNA_WIRE, "Antenna Wire");
            provider.add(Radiocraft.translationKey("commands", "callsign.list.empty"), "No callsigns found");
            provider.add(Radiocraft.translationKey("commands", "callsign.get.success"), "%s's callsign is %s of license class %s.");
            provider.add(Radiocraft.translationKey("commands", "callsign.get.failure"), "%s does not have a callsign.");
            provider.add(Radiocraft.translationKey("commands", "callsign.get.failure.multiple"), "Cannot get the callsign of multiple targets at once.");
            provider.add(Radiocraft.translationKey("commands", "callsign.get.failure.permission"), "You must have permission to change callsigns to use this command.");
            provider.add(Radiocraft.translationKey("commands", "callsign.reset.success"), "%s's callsign has been reset.");
            provider.add(Radiocraft.translationKey("commands", "callsign.reset.failure.multiple"), "Cannot reset the callsign of multiple targets at once.");
            provider.add(Radiocraft.translationKey("commands", "callsign.set.success"), "%s's callsign has been set to %s and license class %s.");
            provider.add(Radiocraft.translationKey("commands", "callsign.set.failure.multiple"), "Cannot reset the callsign of multiple targets at once.");
            provider.add(Radiocraft.translationKey("commands", "solarweather.success"), "Event: %s\nProgress: %s\nDuration: %s\nNoise Floor: %s");
            provider.add(Radiocraft.translationKey("screen", "chargecontroller.power"), "%s FE/s");
            provider.add(Radiocraft.translationKey("screen", "radio.tx"), "Transmitting");
            provider.add(Radiocraft.translationKey("screen", "radio.rx"), "Receiving");
            provider.add(Radiocraft.translationKey("message", "antenna_analyzer.network_found"), "Antenna network at %s has %s antennas");
            provider.add(Radiocraft.translationKey("message", "antenna_analyzer.handheld_with_stats"), "You are holding a handheld radio, the antenna is %s m long and it has an SWR of %s");
            provider.add(Radiocraft.translationKey("message", "antenna_analyzer.no_handheld"), "You are not holding a handheld radio");
            provider.add(Radiocraft.translationKey("message", "antenna_analyzer.unknown_handheld_antenna"), "You are holding a handheld radio, but it's using an antenna we know nothing about.");
            provider.add(Radiocraft.translationKey("message", "antenna_analyzer.no_networks_at"), "No antenna networks found at %s.");
            provider.add(Radiocraft.translationKey("message", "antenna_analyzer.development_summary"), "There are %s networks in the world: %s");
            provider.add(Radiocraft.translationKey("tooltip", "antenna_analyzer"), "Used for analyzing antenna networks and handheld radio antennas");
            provider.add(Radiocraft.translationKey("tooltip", "not_implemented"), "\u00a77Not Implemented (Decorative Only)\u00a7r");
            provider.add(Radiocraft.translationKey("tooltip", "not_implemented_crafting_only"), "\u00a77Not Implemented (Crafting Ingredient Only)\u00a7r");
            provider.add("config.jade.plugin_radiocraft.radiocraft", "RadioCraft");
            provider.add("config.jade.plugin_radiocraft.antenna_wire", "Antenna Wire");
            Arrays.stream(LicenseClass.values()).forEach(licenseClass -> {
                String friendlyClassName = WordUtils.capitalizeFully((String)licenseClass.name().replace("_", " "));
                provider.add(Radiocraft.translationKey("license_class", licenseClass.name()), friendlyClassName);
            });
        });
    }
}

