/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.datagen;

import com.arrl.radiocraft.common.init.RadiocraftItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class RadiocraftRecipesProvider
extends RecipeProvider {
    public RadiocraftRecipesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        this.buildWireRecipe(recipeOutput);
        this.buildWaterproofWireRecipe(recipeOutput);
        this.buildAntennaPoleRecipe(recipeOutput);
        this.buildAntennaWireRecipe(recipeOutput);
        this.buildFerriteCore(recipeOutput);
        this.buildLargeBatteryRecipe(recipeOutput);
        this.buildCoaxialCoreRecipe(recipeOutput);
        this.buildMicrophoneRecipe(recipeOutput);
        this.buildSolarPanelRecipe(recipeOutput);
        this.buildRadioCrystalRecipe(recipeOutput);
        this.buildRadioSpeakerRecipe(recipeOutput);
        this.buildCoaxWireRecipe(recipeOutput);
        this.buildDuplexerRecipe(recipeOutput);
        this.buildSmallBatteryRecipe(recipeOutput);
        this.buildDigitalInterfaceRecipe(recipeOutput);
        this.buildHandMicrophoneRecipe(recipeOutput);
        this.buildAntennaToolsRecipe(recipeOutput);
        this.buildAntennaAnalyzerRecipe(recipeOutput);
        this.buildHfCircuitBoardRecipe(recipeOutput);
        this.buildHfReceiverRecipe(recipeOutput);
        this.buildVhfReceiverRecipe(recipeOutput);
        this.buildVhfBaseStationRecipe(recipeOutput);
        this.buildSolarWeatherStationRecipe(recipeOutput);
        this.buildHfRadio10mRecipe(recipeOutput);
        this.buildHfRadio20mRecipe(recipeOutput);
        this.buildHfRadio40mRecipe(recipeOutput);
        this.buildHfRadio80mRecipe(recipeOutput);
        this.buildVhfRepeaterRecipe(recipeOutput);
        this.buildVhfHandheldRecipe(recipeOutput);
        this.buildAllBandRadioReceiverRecipe(recipeOutput);
        this.buildAllBandRadioBaseStationRecipe(recipeOutput);
        this.buildAllBandRadioHandheldRecipe(recipeOutput);
        this.buildAllBandRadioRepeaterRecipe(recipeOutput);
    }

    private void buildWireRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.WIRE.get()), (int)9).pattern("#  ").pattern(" # ").pattern("  #").define(Character.valueOf('#'), (ItemLike)Items.COPPER_INGOT).unlockedBy("has_copper_ingot", RadiocraftRecipesProvider.has((ItemLike)Items.COPPER_INGOT)).save(recipeOutput);
    }

    private void buildWaterproofWireRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.WATERPROOF_WIRE.get()), (int)3).pattern("KKK").pattern("###").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('K'), (ItemLike)Items.DRIED_KELP).unlockedBy("has_wire", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.WIRE.get()))).save(recipeOutput);
    }

    private void buildAntennaPoleRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.ANTENNA_POLE.get()), (int)1).pattern(" # ").pattern(" # ").pattern(" W ").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('W'), (ItemLike)RadiocraftItems.WIRE.get()).unlockedBy("has_wire", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.WIRE.get()))).save(recipeOutput);
    }

    private void buildAntennaWireRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.ANTENNA_WIRE.get()), (int)1).pattern("K# ").pattern("K# ").pattern("K# ").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('K'), (ItemLike)Items.DRIED_KELP).unlockedBy("has_wire", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.WIRE.get()))).save(recipeOutput);
    }

    private void buildFerriteCore(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.FERRITE_CORE.get()), (int)1).pattern("BBB").pattern("B#B").pattern("BBB").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), (ItemLike)Items.CHARCOAL).unlockedBy("has_iron_ingot", RadiocraftRecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
    }

    private void buildLargeBatteryRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.LARGE_BATTERY.get()), (int)1).pattern("LSL").pattern("LSL").pattern("LSL").define(Character.valueOf('L'), Tags.Items.STRIPPED_LOGS).define(Character.valueOf('S'), (ItemLike)RadiocraftItems.SMALL_BATTERY.get()).unlockedBy("has_small_battery", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.SMALL_BATTERY.get()))).save(recipeOutput);
    }

    private void buildCoaxialCoreRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.COAXIAL_CORE.get()), (int)3).pattern("KKK").pattern("CCC").pattern("KKK").define(Character.valueOf('K'), (ItemLike)Items.DRIED_KELP).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).unlockedBy("has_copper_ingot", RadiocraftRecipesProvider.has((ItemLike)Items.COPPER_INGOT)).save(recipeOutput);
    }

    private void buildMicrophoneRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.MICROPHONE.get()), (int)1).pattern(" M ").pattern(" D ").pattern(" C ").define(Character.valueOf('C'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('D'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('M'), (ItemLike)RadiocraftItems.HAND_MICROPHONE.get()).unlockedBy("has_wire", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.WIRE.get()))).save(recipeOutput);
    }

    private void buildSolarPanelRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.SOLAR_PANEL.get()), (int)1).pattern("GGG").pattern("WDW").pattern("   ").define(Character.valueOf('W'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('D'), (ItemLike)Items.DAYLIGHT_DETECTOR).unlockedBy("has_wire", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.WIRE.get()))).save(recipeOutput);
    }

    private void buildRadioCrystalRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()), (int)1).pattern(" # ").pattern("IAI").pattern(" # ").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).unlockedBy("has_iron_ingot", RadiocraftRecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
    }

    private void buildRadioSpeakerRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.RADIO_SPEAKER.get()), (int)1).pattern("   ").pattern("PAP").pattern("P#P").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('A'), (ItemLike)Items.NOTE_BLOCK).unlockedBy("has_note_block", RadiocraftRecipesProvider.has((ItemLike)Items.NOTE_BLOCK)).save(recipeOutput);
    }

    private void buildCoaxWireRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.COAX_WIRE.get()), (int)3).pattern("KKK").pattern("###").pattern("CCC").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('K'), (ItemLike)Items.DRIED_KELP).define(Character.valueOf('C'), (ItemLike)RadiocraftItems.COAXIAL_CORE.get()).unlockedBy("has_coaxial_core", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.COAXIAL_CORE.get()))).save(recipeOutput);
    }

    private void buildDuplexerRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.DUPLEXER.get()), (int)1).pattern("#L#").pattern("#B#").pattern("#C#").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('L'), (ItemLike)Items.LIGHTNING_ROD).define(Character.valueOf('B'), (ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()).unlockedBy("has_hf_circuit_board", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()))).save(recipeOutput);
    }

    private void buildSmallBatteryRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.SMALL_BATTERY.get()), (int)1).pattern("IGI").pattern("GCG").pattern("#G#").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('C'), (ItemLike)Items.COAL).unlockedBy("has_wire", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.WIRE.get()))).save(recipeOutput);
    }

    private void buildDigitalInterfaceRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.DIGITAL_INTERFACE.get()), (int)1).pattern("   ").pattern("#MS").pattern("##D").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('S'), (ItemLike)RadiocraftItems.RADIO_SPEAKER.get()).define(Character.valueOf('M'), (ItemLike)RadiocraftItems.MICROPHONE.get()).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).unlockedBy("has_radio_speaker", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.RADIO_SPEAKER.get()))).save(recipeOutput);
    }

    private void buildHandMicrophoneRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.HAND_MICROPHONE.get()), (int)1).pattern(" B ").pattern("WCW").pattern("   ").define(Character.valueOf('W'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('C'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('B'), ItemTags.BUTTONS).unlockedBy("has_wire", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.WIRE.get()))).save(recipeOutput);
    }

    private void buildAntennaToolsRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.ANTENNA_TUNER.get()), (int)1).pattern("###").pattern("#L#").pattern("BEC").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('L'), (ItemLike)Items.LIGHTNING_ROD).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('B'), (ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()).define(Character.valueOf('E'), (ItemLike)Items.EMERALD).unlockedBy("has_emerald", RadiocraftRecipesProvider.has((ItemLike)Items.EMERALD)).save(recipeOutput);
    }

    private void buildAntennaAnalyzerRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.ANTENNA_ANALYZER.get()), (int)1).pattern("CGC").pattern("#H#").pattern("IBI").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('H'), (ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), (ItemLike)RadiocraftItems.SMALL_BATTERY.get()).unlockedBy("has_hf_circuit_board", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()))).save(recipeOutput);
    }

    private void buildHfCircuitBoardRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()), (int)1).pattern("SSS").pattern("#RN").pattern("III").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('S'), (ItemLike)Items.SAND).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('N'), (ItemLike)Items.QUARTZ).unlockedBy("has_redstone_torch", RadiocraftRecipesProvider.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
    }

    private void buildHfReceiverRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.HF_RECEIVER.get()), (int)1).pattern("III").pattern("C#S").pattern("L#I").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('S'), (ItemLike)RadiocraftItems.RADIO_SPEAKER.get()).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('L'), (ItemLike)Items.LIGHTNING_ROD).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_radio_speaker", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.RADIO_SPEAKER.get()))).save(recipeOutput);
    }

    private void buildVhfReceiverRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.VHF_RECEIVER.get()), (int)1).pattern("IIW").pattern("G#S").pattern("I#W").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('S'), (ItemLike)RadiocraftItems.RADIO_SPEAKER.get()).unlockedBy("has_radio_speaker", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.RADIO_SPEAKER.get()))).save(recipeOutput);
    }

    private void buildVhfBaseStationRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.VHF_BASE_STATION.get()), (int)1).pattern("III").pattern("HRS").pattern("#WW").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('R'), (ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()).define(Character.valueOf('H'), (ItemLike)RadiocraftItems.HAND_MICROPHONE.get()).define(Character.valueOf('S'), (ItemLike)RadiocraftItems.RADIO_SPEAKER.get()).define(Character.valueOf('W'), ItemTags.PLANKS).unlockedBy("has_radio_crystal", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()))).save(recipeOutput);
    }

    private void buildSolarWeatherStationRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.SOLAR_WEATHER_STATION.get()), (int)1).pattern("ATT").pattern("AR#").pattern("L#I").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('R'), (ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()).define(Character.valueOf('A'), (ItemLike)RadiocraftItems.ANTENNA_POLE.get()).define(Character.valueOf('L'), (ItemLike)Items.LIGHTNING_ROD).define(Character.valueOf('T'), (ItemLike)Items.TINTED_GLASS).unlockedBy("has_antenna_pole", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.ANTENNA_POLE.get()))).save(recipeOutput);
    }

    private void buildHfRadio10mRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.HF_RADIO_10M.get()), (int)1).pattern("GGG").pattern("HRS").pattern("#WW").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('R'), (ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()).define(Character.valueOf('H'), (ItemLike)RadiocraftItems.HAND_MICROPHONE.get()).define(Character.valueOf('S'), (ItemLike)RadiocraftItems.RADIO_SPEAKER.get()).define(Character.valueOf('W'), ItemTags.PLANKS).unlockedBy("has_radio_crystal", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()))).save(recipeOutput);
    }

    private void buildHfRadio20mRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.HF_RADIO_20M.get()), (int)1).pattern("BCC").pattern("#RT").pattern("IBI").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('R'), (ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()).define(Character.valueOf('T'), (ItemLike)Items.TINTED_GLASS).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), (ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()).unlockedBy("has_hf_circuit_board", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()))).save(recipeOutput);
    }

    private void buildHfRadio40mRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.HF_RADIO_40M.get()), (int)1).pattern("CBC").pattern("#RT").pattern("IBI").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('R'), (ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()).define(Character.valueOf('T'), (ItemLike)Items.TINTED_GLASS).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), (ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).unlockedBy("has_hf_circuit_board", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()))).save(recipeOutput);
    }

    private void buildHfRadio80mRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.HF_RADIO_80M.get()), (int)1).pattern("CCB").pattern("#RT").pattern("IBI").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('R'), (ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()).define(Character.valueOf('T'), (ItemLike)Items.TINTED_GLASS).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), (ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()).unlockedBy("has_hf_circuit_board", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_CIRCUIT_BOARD.get()))).save(recipeOutput);
    }

    private void buildVhfRepeaterRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.VHF_REPEATER.get()), (int)1).pattern("ITI").pattern("CBR").pattern("I#I").define(Character.valueOf('#'), (ItemLike)RadiocraftItems.WIRE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('R'), (ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()).define(Character.valueOf('B'), (ItemLike)RadiocraftItems.VHF_BASE_STATION.get()).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('T'), (ItemLike)Items.IRON_TRAPDOOR).unlockedBy("has_vhf_base_station", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.VHF_BASE_STATION.get()))).save(recipeOutput);
    }

    private void buildVhfHandheldRecipe(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.VHF_HANDHELD.get()), (int)1).pattern("L  ").pattern("MRS").pattern("BBB").define(Character.valueOf('R'), (ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()).define(Character.valueOf('S'), (ItemLike)RadiocraftItems.RADIO_SPEAKER.get()).define(Character.valueOf('L'), (ItemLike)Items.LIGHTNING_ROD).define(Character.valueOf('M'), (ItemLike)RadiocraftItems.HAND_MICROPHONE.get()).define(Character.valueOf('B'), ItemTags.BUTTONS).unlockedBy("has_radio_crystal", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.RADIO_CRYSTAL.get()))).save(recipeOutput);
    }

    private void buildAllBandRadioReceiverRecipe(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.ALL_BAND_RADIO.get()), (int)1).requires((ItemLike)RadiocraftItems.HF_RADIO_10M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_20M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_40M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_80M.get()).requires((ItemLike)RadiocraftItems.VHF_RECEIVER.get()).unlockedBy("has_hf_radio_10m", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_RADIO_10M.get()))).save(recipeOutput, "radiocraft:all_band_radio_from_receiver");
    }

    private void buildAllBandRadioBaseStationRecipe(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.ALL_BAND_RADIO.get()), (int)1).requires((ItemLike)RadiocraftItems.HF_RADIO_10M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_20M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_40M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_80M.get()).requires((ItemLike)RadiocraftItems.VHF_BASE_STATION.get()).unlockedBy("has_hf_radio_10m", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_RADIO_10M.get()))).save(recipeOutput, "radiocraft:all_band_radio_from_base_station");
    }

    private void buildAllBandRadioHandheldRecipe(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.ALL_BAND_RADIO.get()), (int)1).requires((ItemLike)RadiocraftItems.HF_RADIO_10M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_20M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_40M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_80M.get()).requires((ItemLike)RadiocraftItems.VHF_HANDHELD.get()).unlockedBy("has_hf_radio_10m", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_RADIO_10M.get()))).save(recipeOutput, "radiocraft:all_band_radio_from_handheld");
    }

    private void buildAllBandRadioRepeaterRecipe(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RadiocraftItems.ALL_BAND_RADIO.get()), (int)1).requires((ItemLike)RadiocraftItems.HF_RADIO_10M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_20M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_40M.get()).requires((ItemLike)RadiocraftItems.HF_RADIO_80M.get()).requires((ItemLike)RadiocraftItems.VHF_REPEATER.get()).unlockedBy("has_hf_radio_10m", RadiocraftRecipesProvider.has((ItemLike)((ItemLike)RadiocraftItems.HF_RADIO_10M.get()))).save(recipeOutput, "radiocraft:all_band_radio_from_repeater");
    }
}

