/*
 * Decompiled with CFR 0.152.
 */
package com.farm.events;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="stable_farm", bus=EventBusSubscriber.Bus.GAME)
public class EventHandler {
    @SubscribeEvent
    public static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (event.getEntity() instanceof Mob || event.getEntity() instanceof Player) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        CropBlock cropBlock;
        BlockState clickedBlockState;
        Block block;
        Player player = event.getEntity();
        Level level = player.level();
        ItemStack heldItem = player.getMainHandItem();
        BlockPos pos = event.getPos();
        if (heldItem.getItem() instanceof HoeItem && (block = (clickedBlockState = level.getBlockState(event.getPos())).getBlock()) instanceof CropBlock && (cropBlock = (CropBlock)block).isMaxAge(clickedBlockState)) {
            level.destroyBlock(event.getPos(), true, (Entity)player);
            level.setBlock(event.getPos(), cropBlock.defaultBlockState(), 3);
            ExperienceOrb experienceOrb = new ExperienceOrb(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1);
            level.addFreshEntity((Entity)experienceOrb);
            heldItem.hurtAndBreak(1, (LivingEntity)player, heldItem.getEquipmentSlot());
            player.swing(player.getUsedItemHand());
            event.setCanceled(true);
        }
    }
}

