/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import de.keksuccino.justzoom.JustZoom;
import de.keksuccino.justzoom.ZoomHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    @Shadow
    private float fovModifier;
    @Shadow
    private float oldFovModifier;

    @Inject(method={"getFov"}, at={@At(value="RETURN")}, cancellable=true)
    private void return_getFov_JustZoom(Camera c, float partial, boolean useFOVSetting, CallbackInfoReturnable<Float> info) {
        if (ZoomHandler.isZooming()) {
            float normalFov = ((Float)info.getReturnValue()).floatValue();
            if (normalFov > 170.0f) {
                normalFov = 170.0f;
            }
            if (normalFov < 1.0f) {
                normalFov = 1.0f;
            }
            float modifiedFov = normalFov;
            ZoomHandler.cachedNormalFov = normalFov;
            if ((modifiedFov *= ZoomHandler.getFovModifier()) > 170.0f) {
                modifiedFov = 170.0f;
            }
            if (modifiedFov < 1.0f) {
                modifiedFov = 1.0f;
            }
            ZoomHandler.cachedModifiedFov = modifiedFov;
            if (!ZoomHandler.shouldZoomInOutSmooth()) {
                info.setReturnValue((Object)Float.valueOf(modifiedFov));
            } else {
                info.setReturnValue((Object)Float.valueOf(normalFov));
            }
        } else if (JustZoom.getOptions().resetZoomFactorOnStopZooming.getValue().booleanValue()) {
            ZoomHandler.zoomModifier = JustZoom.getOptions().baseZoomFactor.getValue().floatValue();
        }
    }

    @Inject(method={"tickFov"}, at={@At(value="HEAD")}, cancellable=true)
    private void head_tickFov_JustZoom(CallbackInfo info) {
        if (ZoomHandler.isZooming()) {
            info.cancel();
            float f = 1.0f;
            Entity entity = Minecraft.getInstance().getCameraEntity();
            if (entity instanceof AbstractClientPlayer) {
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                Options options = Minecraft.getInstance().options;
                boolean firstPerson = options.getCameraType().isFirstPerson();
                float fovEffectScale = ((Double)options.fovEffectScale().get()).floatValue();
                f = player.getFieldOfViewModifier(firstPerson, fovEffectScale);
            }
            this.oldFovModifier = this.fovModifier;
            this.fovModifier += (f - this.fovModifier) * 0.5f;
        }
    }

    @WrapWithCondition(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderItemInHand(FZLorg/joml/Matrix4f;)V")})
    private boolean wrap_renderItemInHand_JustZoom(GameRenderer instance, float matrix4fstack, boolean b, Matrix4f p_109123_) {
        return !ZoomHandler.shouldHideArmsWhenZooming();
    }
}

