/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.imaginebook.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.jumperonjava.imaginebook.ImageSerializer;
import io.github.jumperonjava.imaginebook.Imaginebook;
import io.github.jumperonjava.imaginebook.image.Image;
import io.github.jumperonjava.imaginebook.image.ImageData;
import io.github.jumperonjava.imaginebook.mixin.accessor.LineAccessor;
import io.github.jumperonjava.imaginebook.mixin.accessor.PageContentAccessor;
import io.github.jumperonjava.imaginebook.mixin.accessor.ScreenAccessor;
import io.github.jumperonjava.imaginebook.util.DeletedImageData;
import io.github.jumperonjava.imaginebook.util.VersionFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BookEditScreen.class})
public abstract class NewBookEditScreenMixin
extends Screen {
    @Shadow
    private int currentPage;
    @Shadow
    @Final
    private List<String> pages;
    @Shadow
    private PageButton forwardButton;
    @Shadow
    private PageButton backButton;
    @Shadow
    private Component pageMsg;
    @Shadow
    private boolean isModified;
    @Shadow
    private boolean isSigning;
    @Shadow
    private Button signButton;
    @Shadow
    private Button doneButton;
    @Shadow
    @Final
    private TextFieldHelper pageEdit;
    private EditBox urlField;
    private EditBox xPosField;
    private EditBox widthField;
    private EditBox yPosField;
    private EditBox heightField;
    private EditBox spinField;
    private Button xPosButton;
    private Button yPosButton;
    private Button widthButton;
    private Button heightButton;
    private Button spinButton;
    private Button removeButton;
    private Button addButton;
    private Component error;
    List<List<ImageData>> display_pages = new ArrayList<List<ImageData>>();
    int currentEdited = -1;
    public int draggedByMouse = -1;
    public double bufferX;
    public double bufferY;

    @Shadow
    protected abstract BookEditScreen.DisplayCache getDisplayCache();

    @Shadow
    protected abstract void renderHighlight(GuiGraphics var1, Rect2i[] var2);

    @Shadow
    protected abstract void renderCursor(GuiGraphics var1, BookEditScreen.Pos2i var2, boolean var3);

    @Shadow
    protected abstract void clearDisplayCache();

    protected NewBookEditScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/component/WritableBookContent;)V"}, at={@At(value="TAIL")})
    void construct(Player player, ItemStack stack, InteractionHand hand, WritableBookContent writableBookContent, CallbackInfo ci) {
        for (int i = 0; i < 250; ++i) {
            this.display_pages.add(new ArrayList());
        }
        this.updateDisplayImages();
    }

    void updateDisplayImages() {
        for (int i = 0; i < this.pages.size(); ++i) {
            String page = this.pages.get(i);
            this.display_pages.set(i, ImageSerializer.parseSafeModeImages(page));
        }
        this.currentEdited = Math.min(this.currentEdited, this.display_pages.get(this.currentPage).size() - 1);
    }

    private String getCurrentPageContent() {
        if (this.currentPage >= this.pages.size()) {
            return "";
        }
        return this.pages.get(this.currentPage);
    }

    private void setCurrentPageContent(String content) {
        this.pages.set(this.currentPage, content);
        this.isModified = true;
        int start = this.pageEdit.getCursorPos();
        int end = this.pageEdit.getSelectionPos();
        start = Mth.clamp((int)start, (int)0, (int)(this.pages.size() - 1));
        end = Mth.clamp((int)end, (int)0, (int)(this.pages.size() - 1));
        this.pageEdit.setSelectionRange(start, end);
        this.clearDisplayCache();
    }

    @Inject(method={"clearDisplayCacheAfterPageChange()V"}, at={@At(value="HEAD")})
    void onChangePage(CallbackInfo ci) {
        this.currentEdited = -1;
    }

    @WrapOperation(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookEditScreen;setFocused(Lnet/minecraft/client/gui/components/events/GuiEventListener;)V")})
    void ignoreSetFocused(BookEditScreen instance, GuiEventListener element, Operation<Void> original) {
    }

    @Inject(method={"updateButtonVisibility()V"}, at={@At(value="HEAD")}, cancellable=true)
    void updateButtons(CallbackInfo ci) {
        if (Imaginebook.cancelledFinalize) {
            this.isSigning = false;
        }
    }

    @Inject(method={"clearDisplayCache()V"}, at={@At(value="HEAD")})
    void updateSafeModeImages(CallbackInfo ci) {
        this.updateDisplayImages();
    }

    private void setCurrentEdited(int imageId) {
        this.currentEdited = imageId;
        if (this.currentEdited == -1) {
            this.setFocused(null);
        } else {
            this.updateFields();
        }
    }

    @Nullable
    ImageData getCurrentPageImage(int id) {
        if (id == -1) {
            return null;
        }
        if (this.display_pages.get(this.currentPage).isEmpty()) {
            return null;
        }
        return this.display_pages.get(this.currentPage).get(id);
    }

    void addCurrentPageImage(ImageData image) {
        this.setCurrentPageContent(this.getCurrentPageContent() + image.bookString());
        this.updateDisplayImages();
    }

    protected void changeFocus(ComponentPath path) {
        ((ScreenAccessor)((Object)this)).invokeBlur();
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    void init(CallbackInfo ci) {
        int i;
        int elementHeight = 20;
        int gap = 4;
        int heightOffset = this.height - 50;
        int columnSize = 100 - gap;
        int smallFieldWidth = columnSize - 24;
        int[] row = new int[10];
        int[] column = new int[10];
        int[] fieldColumn = new int[10];
        for (i = 0; i < 10; ++i) {
            row[i] = i * (elementHeight + gap) + gap;
        }
        for (i = 0; i < 10; ++i) {
            column[i] = i * (columnSize + gap) + gap;
        }
        for (i = 0; i < 10; ++i) {
            fieldColumn[i] = column[i] + 24;
        }
        int urlFieldX = column[0];
        int urlFieldY = row[0];
        int urlFieldWidth = columnSize * 2 + gap;
        int addButtonX = column[0];
        int addButtonY = row[1];
        int addButtonWidth = columnSize;
        int removeButtonX = column[1];
        int removeButtonY = row[1];
        int removeButtonWidth = columnSize;
        int xPosButtonX = column[2];
        int xPosButtonY = row[0];
        int xPosFieldX = fieldColumn[2];
        int xPosFieldY = row[0];
        int yPosButtonX = column[2];
        int yPosButtonY = row[1];
        int yPosFieldX = fieldColumn[2];
        int yPosFieldY = row[1];
        int widthButtonX = column[3];
        int widthButtonY = row[0];
        int widthFieldX = fieldColumn[3];
        int widthFieldY = row[0];
        int heightButtonX = column[3];
        int heightButtonY = row[1];
        int heightFieldX = fieldColumn[3];
        int heightFieldY = row[1];
        int spinButtonX = column[4];
        int spinButtonY = row[1];
        int spinFieldX = fieldColumn[4];
        int spinFieldY = row[1];
        urlFieldY += heightOffset;
        addButtonY += heightOffset;
        removeButtonY += heightOffset;
        xPosButtonY += heightOffset;
        xPosFieldY += heightOffset;
        yPosButtonY += heightOffset;
        yPosFieldY += heightOffset;
        widthButtonY += heightOffset;
        widthFieldY += heightOffset;
        heightButtonY += heightOffset;
        heightFieldY += heightOffset;
        spinButtonY += heightOffset;
        spinFieldY += heightOffset;
        this.urlField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, urlFieldX, urlFieldY, urlFieldWidth, elementHeight, (Component)Component.translatable((String)"imaginebook.gui.urlhere")));
        this.urlField.setMaxLength(256);
        this.urlField.setResponder(url -> {
            ImageData getCurrentEdited = this.getCurrentEdited();
            if (getCurrentEdited == null) {
                return;
            }
            if (url.equals(getCurrentEdited.getUrl())) {
                return;
            }
            if (url.length() > 255) {
                this.urlField.setValue(I18n.get((String)"imaginebook.error.too_long", (Object[])new Object[0]));
                return;
            }
            this.mutateImage(this.currentEdited, imageData -> {
                imageData.heightFraction = 1.0f;
                imageData.widthFraction = 1.0f;
                imageData.setUrl(Imaginebook.fixImgurLink(url));
                return imageData;
            });
        });
        this.addButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"imaginebook.gui.add"), b -> {
            ImageData newImage = new ImageData("", 0, 0, 1.0f, 1.0f);
            this.addCurrentPageImage(newImage);
            this.setCurrentEdited(this.display_pages.get(this.currentPage).size() - 1);
        }).pos(addButtonX, addButtonY).size(addButtonWidth, elementHeight).build());
        this.removeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"imaginebook.gui.remove"), b -> this.mutateImage(this.currentEdited, imageData -> {
            this.setCurrentEdited(-1);
            return new DeletedImageData();
        })).pos(removeButtonX, removeButtonY).size(removeButtonWidth, elementHeight).build());
        this.xPosButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u21c4"), b -> {}).pos(xPosButtonX, xPosButtonY).size(20, elementHeight).build());
        this.xPosField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, xPosFieldX, xPosFieldY, smallFieldWidth, elementHeight, (Component)Component.empty()));
        this.xPosField.setResponder(this.createSetter(x -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.x = x.floatValue();
            return imageData;
        }), this.xPosField));
        this.yPosButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u21c5"), b -> {}).pos(yPosButtonX, yPosButtonY).size(20, elementHeight).build());
        this.yPosField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, yPosFieldX, yPosFieldY, smallFieldWidth, elementHeight, (Component)Component.empty()));
        this.yPosField.setResponder(this.createSetter(y -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.y = y.floatValue();
            return imageData;
        }), this.yPosField));
        this.widthButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u21d4"), b -> {}).pos(widthButtonX, widthButtonY).size(20, elementHeight).build());
        this.widthField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, widthFieldX, widthFieldY, smallFieldWidth, elementHeight, (Component)Component.empty()));
        this.widthField.setResponder(this.createSetter(w -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.widthFraction = (float)Math.round(w.floatValue()) / 100.0f;
            return imageData;
        }), this.widthField));
        this.heightButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u21d5"), b -> {}).pos(heightButtonX, heightButtonY).size(20, elementHeight).build());
        this.heightField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, heightFieldX, heightFieldY, smallFieldWidth, elementHeight, (Component)Component.empty()));
        this.heightField.setResponder(this.createSetter(h -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.heightFraction = (float)Math.round(h.floatValue()) / 100.0f;
            return imageData;
        }), this.heightField));
        this.spinButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u21bb"), b -> {}).pos(spinButtonX, spinButtonY).size(20, elementHeight).build());
        this.spinField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, spinFieldX, spinFieldY, smallFieldWidth, elementHeight, (Component)Component.empty()));
        this.spinField.setResponder(this.createSetter(h -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.rotation = 0.0f;
            imageData.rotate(h.floatValue());
            return imageData;
        }), this.spinField));
        this.removeButton.visible = false;
        this.urlField.setVisible(false);
        this.xPosField.setVisible(false);
        this.xPosButton.visible = false;
        this.yPosField.setVisible(false);
        this.yPosButton.visible = false;
        this.widthField.setVisible(false);
        this.widthButton.visible = false;
        this.heightField.setVisible(false);
        this.heightButton.visible = false;
        this.spinField.setVisible(false);
        this.spinButton.visible = false;
        this.updateFields();
    }

    private ImageData getCurrentEdited() {
        return this.getCurrentPageImage(this.currentEdited);
    }

    private void updateFields() {
        ArrayList pageErrors = new ArrayList();
        if (pageErrors.size() > 0) {
            this.isSigning = false;
            Imaginebook.cancelledFinalize = true;
            this.error = Component.translatable((String)"imaginebook.error.too_long_encoded", (Object[])new Object[]{String.join((CharSequence)", ", (CharSequence[])pageErrors.stream().map(s -> String.valueOf(s + 1)).toArray(String[]::new))});
        } else {
            Imaginebook.cancelledFinalize = false;
            this.error = Component.empty();
        }
        if (this.currentEdited == -1) {
            return;
        }
        ImageData currentPageImage = this.getCurrentEdited();
        if (currentPageImage != null) {
            this.urlField.setValue(currentPageImage.getUrl());
            String xpos = String.valueOf((int)currentPageImage.x());
            this.xPosField.setValue(xpos);
            String ypos = String.valueOf((int)currentPageImage.y());
            this.yPosField.setValue(ypos);
            String width = String.valueOf(currentPageImage.widthFraction() * 100.0f);
            this.widthField.setValue(width);
            String height = String.valueOf(currentPageImage.heightFraction() * 100.0f);
            this.heightField.setValue(height);
            this.spinField.setValue("" + currentPageImage.rotation);
        }
    }

    Consumer<String> createSetter(Consumer<Float> setter, EditBox fieldWidget) {
        return value -> {
            try {
                float number = Float.parseFloat(value);
                if (String.valueOf(Math.round(number)).equals("0")) {
                    setter.accept(Float.valueOf(0.0f));
                } else if (!fieldWidget.getValue().equals(String.valueOf(Math.round(number)))) {
                    fieldWidget.setValue(String.valueOf(Math.round(number)));
                } else {
                    setter.accept(Float.valueOf(number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        };
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="HEAD")}, cancellable=true)
    void mouseClicked(double mouseX, double mouseY, int mouseButton, CallbackInfoReturnable<Boolean> cir) {
        Button[] buttons;
        List<ImageData> images = this.display_pages.get(this.currentPage);
        if (this.isSigning) {
            return;
        }
        for (Button button : buttons = new Button[]{this.forwardButton, this.backButton, this.signButton, this.doneButton}) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            button.onPress();
            cir.setReturnValue((Object)true);
            return;
        }
        int i = 0;
        for (ImageData image : images) {
            if (this.isMouseOver(image, mouseX, mouseY)) {
                this.setCurrentEdited(i);
                this.draggedByMouse = i;
                cir.setReturnValue((Object)true);
                return;
            }
            ++i;
        }
        if (this.isMouseOver(new ImageData("", 0, 0, 192.0f, 192.0f), mouseX, mouseY)) {
            this.setFocused(null);
        }
    }

    @Inject(method={"mouseDragged(DDIDD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        if (button != 0) {
            return;
        }
        if (this.draggedByMouse != -1) {
            this.bufferX += deltaX;
            this.bufferY += deltaY;
            this.mutateImage(this.draggedByMouse, imageData -> {
                imageData.x += (float)((int)this.bufferX);
                imageData.y += (float)((int)this.bufferY);
                return imageData;
            });
            this.bufferX -= (double)((int)this.bufferX);
            this.bufferY -= (double)((int)this.bufferY);
            cir.setReturnValue((Object)true);
            this.updateFields();
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.draggedByMouse != -1) {
            this.updateFields();
            this.draggedByMouse = -1;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    void mutateImage(int id, Function<ImageData, ImageData> function) {
        if (id == -1) {
            return;
        }
        this.getCurrentPageImage(id);
        ImageData original = new ImageData(this.getCurrentPageImage(id));
        ImageData modifiedImage = function.apply(original);
        Pattern pattern = Pattern.compile("\\[.*?\\]");
        Matcher matcher = pattern.matcher(this.getCurrentPageContent());
        ArrayList images = new ArrayList();
        int index = 0;
        String newPage = this.getCurrentPageContent();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (index == id) {
                StringBuffer buf = new StringBuffer(newPage).delete(start, end).insert(start, modifiedImage.bookString());
                newPage = buf.toString();
                break;
            }
            ++index;
        }
        this.setCurrentPageContent(newPage);
        this.updateDisplayImages();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.isSigning) {
            verticalAmount = Math.signum(verticalAmount);
            if (NewBookEditScreenMixin.hasControlDown()) {
                verticalAmount *= 5.0;
            }
            if (NewBookEditScreenMixin.hasShiftDown()) {
                verticalAmount *= 5.0;
            }
            if (NewBookEditScreenMixin.hasAltDown()) {
                verticalAmount *= 5.0;
            }
            boolean pressed = false;
            if (this.getCurrentEdited() != null) {
                double finalVerticalAmount = verticalAmount;
                Image.ImageSize currentNativeImage = this.getCurrentEdited().getImage().getSize();
                if (this.xPosButton.isMouseOver(mouseX, mouseY) || this.xPosField.isMouseOver(mouseX, mouseY)) {
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.x += (float)finalVerticalAmount;
                        return imageData;
                    });
                    pressed = true;
                }
                if (this.yPosButton.isMouseOver(mouseX, mouseY) || this.yPosField.isMouseOver(mouseX, mouseY)) {
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.y += (float)finalVerticalAmount;
                        return imageData;
                    });
                    pressed = true;
                }
                if (this.widthButton.isMouseOver(mouseX, mouseY) || this.widthField.isMouseOver(mouseX, mouseY)) {
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.widthFraction += (float)(finalVerticalAmount / (double)currentNativeImage.getWidth());
                        return imageData;
                    });
                    pressed = true;
                }
                if (this.heightButton.isMouseOver(mouseX, mouseY) || this.heightField.isMouseOver(mouseX, mouseY)) {
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.heightFraction += (float)(finalVerticalAmount / (double)currentNativeImage.getHeight());
                        return imageData;
                    });
                    pressed = true;
                }
                if (this.spinButton.isMouseOver(mouseX, mouseY) || this.spinField.isMouseOver(mouseX, mouseY)) {
                    if (verticalAmount == 25.0) {
                        verticalAmount = 15.0;
                    }
                    if (verticalAmount == 125.0) {
                        verticalAmount = 90.0;
                    }
                    if (verticalAmount == -25.0) {
                        verticalAmount = -15.0;
                    }
                    if (verticalAmount == -125.0) {
                        verticalAmount = -90.0;
                    }
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.rotate((float)finalVerticalAmount);
                        return imageData;
                    });
                    pressed = true;
                }
            }
            if (!pressed) {
                int targetImage1 = -1;
                int i = 0;
                for (ImageData image : this.display_pages.get(this.currentPage)) {
                    if (this.isMouseOver(image, mouseX, mouseY) && targetImage1 == -1) {
                        targetImage1 = i;
                        break;
                    }
                    ++i;
                }
                if (this.draggedByMouse != -1) {
                    targetImage1 = this.draggedByMouse;
                }
                double finalVerticalAmount = verticalAmount;
                this.mutateImage(targetImage1, targetImage -> {
                    double localVerticalAmount = finalVerticalAmount;
                    if (targetImage != null) {
                        if (NewBookEditScreenMixin.hasShiftDown() || NewBookEditScreenMixin.hasAltDown()) {
                            localVerticalAmount /= 5.0;
                        }
                        double pow = Math.pow(1.0 + Math.abs(localVerticalAmount * 0.01), Math.signum(localVerticalAmount));
                        float min = Math.min(targetImage.renderWidth(), targetImage.renderHeight());
                        if (Math.abs((double)min - (double)min * pow) < 1.0) {
                            pow = ((double)min + localVerticalAmount) / (double)min;
                        }
                        if (!NewBookEditScreenMixin.hasAltDown()) {
                            targetImage.widthFraction = (float)((double)targetImage.widthFraction * pow);
                        }
                        if (!NewBookEditScreenMixin.hasShiftDown()) {
                            targetImage.heightFraction = (float)((double)targetImage.heightFraction * pow);
                        }
                    }
                    return targetImage;
                });
            }
            this.updateFields();
            if (pressed) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.updateFields();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    void render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        boolean editing;
        this.currentPage = Mth.clamp((int)this.currentPage, (int)-1, (int)(this.display_pages.size() - 1));
        this.doneButton.active = ((PageContentAccessor)this.getDisplayCache()).getLines().length <= 14;
        boolean bl = this.signButton.active = ((PageContentAccessor)this.getDisplayCache()).getLines().length <= 14;
        if (this.error != null) {
            context.drawCenteredString(this.minecraft.font, this.error, this.width / 2, this.height - 20, ARGB.color((int)255, (int)255, (int)100, (int)100));
        }
        boolean bl2 = editing = this.currentEdited != -1;
        if (this.isSigning) {
            editing = false;
        }
        this.addButton.visible = !this.isSigning;
        this.removeButton.visible = editing;
        this.urlField.setVisible(editing);
        this.xPosField.setVisible(editing);
        this.xPosButton.visible = editing;
        this.yPosField.setVisible(editing);
        this.yPosButton.visible = editing;
        this.widthField.setVisible(editing);
        this.widthButton.visible = editing;
        this.heightField.setVisible(editing);
        this.heightButton.visible = editing;
        this.spinField.setVisible(editing);
        this.spinButton.visible = editing;
        if (this.isSigning) {
            return;
        }
        int bookX = this.width / 2 - 96;
        int bookY = 2;
        ArrayList combined = new ArrayList();
        combined.addAll(this.display_pages.get(this.currentPage));
        for (Object imageData : VersionFunctions.reversed(combined)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            ((ImageData)imageData).renderImage(context, bookX, bookY);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
        }
        List<ImageData> images = this.display_pages.get(this.currentPage);
        if (images != null) {
            for (ImageData imageData : images) {
                if (!this.isMouseOver(imageData, mouseX, mouseY)) continue;
                context.fill((int)((float)bookX + imageData.x()), (int)((float)bookY + imageData.y()), (int)((float)bookX + imageData.x() + imageData.renderWidth()), (int)((float)bookY + imageData.y() + imageData.renderHeight()), 0xFFFFFFF);
                break;
            }
        }
        List.of(this.urlField, this.addButton, this.removeButton, this.widthButton, this.widthField, this.heightButton, this.heightField, this.xPosButton, this.xPosField, this.yPosButton, this.yPosField, this.forwardButton, this.backButton, this.signButton, this.doneButton, this.spinButton, this.spinField).forEach(e -> e.render(context, mouseX, mouseY, delta));
        int i = (this.width - 192) / 2;
        int j = 2;
        int n = this.font.width((FormattedText)this.pageMsg);
        context.drawString(this.font, this.pageMsg, i - n + 192 - 44, 18, 0x3F000000, false);
        for (BookEditScreen.LineInfo line : ((PageContentAccessor)this.getDisplayCache()).getLines()) {
            context.drawString(this.font, ((LineAccessor)line).getText(), ((LineAccessor)line).getX(), ((LineAccessor)line).getY(), 0x3F000000, false);
        }
        this.renderHighlight(context, ((PageContentAccessor)this.getDisplayCache()).getSelectionRectangles());
        this.renderCursor(context, ((PageContentAccessor)this.getDisplayCache()).getPosition(), ((PageContentAccessor)this.getDisplayCache()).isAtEnd());
        if (((PageContentAccessor)this.getDisplayCache()).getLines().length > 14) {
            context.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"imaginebook.error.too_much_lines"), this.width / 2, 222, ARGB.color((int)255, (int)255, (int)100, (int)100));
        }
    }

    public boolean isMouseOver(ImageData imageData, double mouseX, double mouseY) {
        return ImageData.isMouseOverImage(imageData, mouseX, mouseY, this.width / 2);
    }

    @Inject(method={"saveChanges(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    void finalizeBook(boolean sign, CallbackInfo ci) {
        if (!this.isModified) {
            this.isModified = true;
        }
        if (Imaginebook.cancelledFinalize) {
            ci.cancel();
            return;
        }
    }
}

