/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.imaginebook.image;

import io.github.jumperonjava.imaginebook.Imaginebook;
import io.github.jumperonjava.imaginebook.image.BookDrawable;
import io.github.jumperonjava.imaginebook.image.Image;
import io.github.jumperonjava.imaginebook.resolvers.AsyncImageDownloader;
import io.github.jumperonjava.imaginebook.util.VersionFunctions;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_332;

public class ImageData {
    private String url;
    public float x;
    public float y;
    public float widthFraction = 1.0f;
    public float heightFraction = 1.0f;
    public float rotation;

    public ImageData(String url, short x, short y, float widthFraction, float heightFraction) {
        this.setUrl(url);
        this.x = x;
        this.y = y;
        this.widthFraction = widthFraction;
        this.heightFraction = heightFraction;
    }

    public ImageData(ImageData image) {
        this.setUrl(image.getUrl());
        this.x = image.x;
        this.y = image.y;
        this.widthFraction = image.widthFraction;
        this.heightFraction = image.heightFraction;
        this.rotation = image.rotation;
    }

    public ImageData() {
    }

    public static boolean isMouseOverImage(ImageData imageData, double mouseX, double mouseY, int i) {
        int bookX = i - 96;
        int bookY = 2;
        BookDrawable image = imageData.getImage();
        double imageX1 = imageData.x() + (float)bookX;
        double imageY1 = imageData.y() + (float)bookY;
        double imageX2 = imageX1 + (double)imageData.renderWidth();
        double imageY2 = imageY1 + (double)imageData.renderHeight();
        double minX = Math.min(imageX1, imageX2);
        double maxX = Math.max(imageX1, imageX2);
        double minY = Math.min(imageY1, imageY2);
        double maxY = Math.max(imageY1, imageY2);
        return mouseX >= minX && mouseX < maxX && mouseY >= minY && mouseY < maxY;
    }

    public void renderImage(class_332 context, int bookX, int bookY) {
        BookDrawable image = this.getImage();
        Image.ImageSize size = image.getSize();
        float w = this.renderWidth();
        float h = this.renderHeight();
        VersionFunctions.pushMatrix(context);
        VersionFunctions.translate2D(context, (float)bookX + this.x(), (float)bookY + this.y());
        VersionFunctions.translate2D(context, w / 2.0f, h / 2.0f);
        VersionFunctions.rotateZ(context, this.rotation);
        VersionFunctions.translate2D(context, -w / 2.0f, -h / 2.0f);
        VersionFunctions.scale2D(context, this.widthFraction, this.heightFraction);
        image.render(context);
        VersionFunctions.popMatrix(context);
    }

    public BookDrawable getImage() {
        try {
            String[] split = this.getUrl().split(":", 2);
            return Imaginebook.getResolver(split[0]).resolve(split[1]);
        }
        catch (Exception e) {
            return AsyncImageDownloader.ERROR_IMAGE;
        }
    }

    public String url() {
        return this.getUrl();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float widthFraction() {
        return this.widthFraction;
    }

    public float heightFraction() {
        return this.heightFraction;
    }

    public float renderWidth() {
        return this.widthFraction * (float)this.getImage().getSize().getWidth();
    }

    public float renderHeight() {
        return this.heightFraction * (float)this.getImage().getSize().getHeight();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImageData that = (ImageData)obj;
        return Objects.equals(this.getUrl(), that.getUrl()) && this.x == that.x && this.y == that.y && this.widthFraction == that.widthFraction && this.heightFraction == that.heightFraction;
    }

    public int hashCode() {
        return Objects.hash(this.getUrl(), Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.widthFraction), Float.valueOf(this.heightFraction));
    }

    public String toString() {
        return "ImageDefinition[url=" + this.getUrl() + ", x=" + this.x + ", y=" + this.y + ", width=" + this.widthFraction + ", height=" + this.heightFraction + "]";
    }

    public String bookString() {
        return String.format(Locale.US, "[%s,%.2f,%.2f,%.2f,%.2f,%.2f]", this.getUrl(), Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.widthFraction * 100.0f), Float.valueOf(this.heightFraction * 100.0f), Float.valueOf(this.rotation)).replaceAll("\\.00(?!\\d)", "").replaceAll("(\\.\\d)0(?!\\d)", "$1");
    }

    public void rotate(float degrees) {
        this.rotation += degrees;
        this.rotation = Math.floorMod((int)this.rotation, 360);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url.replace(",", "");
    }
}

