/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.imaginebook;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.github.jumperonjava.imaginebook.resolvers.AsyncImageDownloader;
import io.github.jumperonjava.imaginebook.resolvers.Resolver;
import io.github.jumperonjava.imaginebook.resolvers.TextureResolver;
import io.github.jumperonjava.imaginebook.resolvers.UrlResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Imaginebook {
    public static final String MOD_ID = "imaginebook";
    public static Logger LOGGER = LoggerFactory.getLogger((String)"ImagineBook");
    public static final String TEST_BALLER = "https://i.kym-cdn.com/photos/images/original/002/461/188/20d.png";
    public static RenderPipeline GUI_TEXTURED_NOCULL;
    public static int LENGTH;
    public static boolean cancelledFinalize;
    private static Map<String, Resolver> resolvers;

    public static void init() {
        Imaginebook.createImagineBookFolder();
        GUI_TEXTURED_NOCULL = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation("pipeline/imaginebook_gui_textured_nocull").withCull(false).build());
    }

    public static String fixImgurLink(String link) {
        if (link.startsWith("https://imgur.com/")) {
            String imageId = link.substring("https://imgur.com/".length());
            return "https://i.imgur.com/" + imageId + ".png";
        }
        return link;
    }

    public static Path getCachePath() {
        return FabricLoader.getInstance().getGameDir().resolve(MOD_ID);
    }

    public static Path getConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("imaginebook.json");
    }

    public static void addResolver(String id, Resolver resolver) {
        resolvers.put(id, resolver);
    }

    public static Resolver getResolver(String type) {
        if (resolvers.containsKey(type)) {
            return resolvers.get(type);
        }
        return path -> AsyncImageDownloader.ERROR_IMAGE;
    }

    public static boolean resolverExists(String resolver) {
        return resolvers.containsKey(resolver);
    }

    public void cleanFiles() {
    }

    public static void createImagineBookFolder() {
        Path imagineBookPath = Imaginebook.getCachePath();
        try {
            if (!Files.exists(imagineBookPath, new LinkOption[0])) {
                Files.createDirectories(imagineBookPath, new FileAttribute[0]);
                LOGGER.info("imaginebook folder created at: " + imagineBookPath.toString());
            }
        }
        catch (IOException e) {
            LOGGER.info("Failed to create imaginebook folder: " + e.getMessage());
        }
    }

    static {
        LENGTH = 1023;
        cancelledFinalize = false;
        resolvers = new HashMap<String, TextureResolver>(Map.of("http", UrlResolver.INSTANCE, "https", UrlResolver.INSTANCE_S, "res", TextureResolver.INSTANCE));
    }
}

