/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.imaginebook.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.jumperonjava.imaginebook.ImageSerializer;
import io.github.jumperonjava.imaginebook.Imaginebook;
import io.github.jumperonjava.imaginebook.image.ImageData;
import io.github.jumperonjava.imaginebook.util.VersionFunctions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookViewScreen.class})
public class BookScreenMixin
extends Screen {
    @Shadow
    private int currentPage;
    @Shadow
    private PageButton forwardButton;
    @Shadow
    private PageButton backButton;
    List<List<ImageData>> imaginebook_pages = new ArrayList<List<ImageData>>();
    private Component error;
    private GuiEventListener closeButton;

    protected BookScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/gui/screens/inventory/BookViewScreen$BookAccess;Z)V"}, at={@At(value="TAIL")})
    void construct(BookViewScreen.BookAccess contents, boolean playPageTurnSound, CallbackInfo ci) {
        for (int i = 0; i < 255; ++i) {
            this.imaginebook_pages.add(new ArrayList());
        }
        this.parseImages(contents);
    }

    @Inject(method={"setBookAccess(Lnet/minecraft/client/gui/screens/inventory/BookViewScreen$BookAccess;)V"}, at={@At(value="TAIL")})
    void construct(BookViewScreen.BookAccess pageProvider, CallbackInfo ci) {
        this.parseImages(pageProvider);
    }

    void parseImages(BookViewScreen.BookAccess contents) {
        List pages = contents.pages();
        for (int i = 0; i < pages.size(); ++i) {
            String page = ((Component)pages.get(i)).getString();
            if (page.length() == Imaginebook.LENGTH) {
                String[] split = page.split("\n");
                String last = split[split.length - 1];
                try {
                    byte[] asbytes = Base64.getDecoder().decode(last);
                    List<ImageData> definitions = ImageSerializer.deserializeImageMetadata(asbytes);
                    this.imaginebook_pages.set(i, definitions);
                }
                catch (Exception e) {
                    this.error = Component.literal((String)e.getMessage());
                    e.printStackTrace();
                }
            }
            this.imaginebook_pages.get(i).addAll(ImageSerializer.parseSafeModeImages(page));
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    void render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        int bookX = this.width / 2 - 96;
        int bookY = 2;
        if (this.currentPage == -1) {
            return;
        }
        List<ImageData> images = this.imaginebook_pages.get(this.currentPage);
        if (images == null) {
            return;
        }
        for (ImageData image : VersionFunctions.reversed(images)) {
            image.renderImage(context, bookX, bookY);
        }
        this.backButton.render(context, mouseX, mouseY, delta);
        this.forwardButton.render(context, mouseX, mouseY, delta);
        if (this.closeButton != null) {
            ((Renderable)this.closeButton).render(context, mouseX, mouseY, delta);
        }
    }

    @WrapOperation(method={"createMenuControls()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookViewScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;")})
    GuiEventListener capture(BookViewScreen instance, GuiEventListener element, Operation<GuiEventListener> original) {
        this.closeButton = element;
        return (GuiEventListener)original.call(new Object[]{instance, element});
    }
}

