/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.imaginebook.image;

import io.github.jumperonjava.imaginebook.image.BookDrawable;
import io.github.jumperonjava.imaginebook.util.VersionFunctions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class Image
implements BookDrawable {
    private final ResourceLocation identifier;
    private final ImageSize size;

    @Override
    public ImageSize getSize() {
        return this.size;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public Image(ResourceLocation identifier, ImageSize size) {
        this.identifier = identifier;
        this.size = size;
    }

    public Image(ResourceLocation identifier) {
        this.identifier = identifier;
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(identifier, (AbstractTexture)MissingTextureAtlasSprite.getTexture());
        if (texture instanceof DynamicTexture) {
            DynamicTexture imageBackedTexture = (DynamicTexture)texture;
            this.size = new ImageSize(imageBackedTexture.getPixels().getWidth(), imageBackedTexture.getPixels().getHeight());
        } else {
            this.size = new ImageSize(64, 64);
        }
    }

    @Override
    public void render(GuiGraphics context) {
        VersionFunctions.drawTexture(context, this.getIdentifier(), 0, 0, 0.0f, 0.0f, this.getSize().getWidth(), this.getSize().getHeight(), this.getSize().getWidth(), this.getSize().getHeight());
    }

    public static class ImageSize {
        private final int width;
        private final int height;

        public ImageSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        private int min() {
            return Math.min(this.width, this.height);
        }

        public int getWidth() {
            return this.width * 100 / this.min();
        }

        public int getHeight() {
            return this.height * 100 / this.min();
        }
    }
}

