/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.imaginebook.resolvers;

import com.ibm.icu.impl.InvalidFormatException;
import io.github.jumperonjava.imaginebook.Imaginebook;
import io.github.jumperonjava.imaginebook.image.BookDrawable;
import io.github.jumperonjava.imaginebook.image.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.io.IOUtils;

public class AsyncImageDownloader {
    public static BookDrawable ERROR_IMAGE = new Image(class_2960.method_43902((String)"imaginebook", (String)"textures/not_loaded.png"), new Image.ImageSize(128, 128));
    public static BookDrawable SIZE_ERROR = new Image(class_2960.method_43902((String)"imaginebook", (String)"textures/size_error.png"), new Image.ImageSize(128, 128));
    public static BookDrawable DOWNLOADING_IMAGE = new Image(class_2960.method_43902((String)"imaginebook", (String)"textures/downloading.png"), new Image.ImageSize(128, 128));
    public static BookDrawable URI_INVALID_ERROR = new Image(class_2960.method_43902((String)"imaginebook", (String)"textures/url_invalid.png"), new Image.ImageSize(128, 128));
    public Map<String, BookDrawable> downloadedImages = new HashMap<String, BookDrawable>();
    public List<URI> inProgressImages = Collections.synchronizedList(new LinkedList());
    public List<URI> inProgressRetryImages = Collections.synchronizedList(new LinkedList());
    public List<URI> unregisteredImages = Collections.synchronizedList(new LinkedList());
    public List<URI> errorImages = Collections.synchronizedList(new LinkedList());
    public List<URI> overLimitImages = Collections.synchronizedList(new LinkedList());

    public AsyncImageDownloader() {
        new Thread(this::downloadThread).start();
    }

    public Path URIPath(URI URI2) {
        return Imaginebook.getCachePath().resolve("%s/%d.cache".formatted(URI2.getHost().toLowerCase(), URI2.getPath().hashCode()));
    }

    public class_2960 URIIdentifier(URI URI2) {
        return class_2960.method_43902((String)"imaginebook", (String)"%s/%d.cache".formatted(URI2.getHost().toLowerCase(), URI2.getPath().hashCode()));
    }

    public void downloadThread() {
        while (true) {
            URI downloadURI = null;
            if (!this.inProgressImages.isEmpty()) {
                downloadURI = this.inProgressImages.remove(0);
            }
            if (!this.inProgressRetryImages.isEmpty()) {
                downloadURI = this.inProgressRetryImages.remove(0);
            }
            if (downloadURI == null) continue;
            Path URIFile = this.URIPath(downloadURI);
            try {
                Files.createDirectories(URIFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                Imaginebook.LOGGER.error("Failed to create folder for file: " + String.valueOf(URIFile));
                continue;
            }
            try {
                InputStream URIIn = downloadURI.toURL().openStream();
                try {
                    OutputStream fileOut = Files.newOutputStream(URIFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    try {
                        int bytesRead;
                        Imaginebook.createImagineBookFolder();
                        byte[] buffer = new byte[8192];
                        long totalBytesRead = 0L;
                        long maxSize = 0x800000L;
                        ByteArrayOutputStream convertReader = new ByteArrayOutputStream();
                        while ((bytesRead = URIIn.read(buffer)) != -1) {
                            if ((totalBytesRead += (long)bytesRead) > maxSize) {
                                this.overLimitImages.add(downloadURI);
                                throw new InvalidFormatException("File size exceeds 1MB limit.");
                            }
                            convertReader.write(buffer, 0, bytesRead);
                        }
                        ByteArrayInputStream convertWriter = new ByteArrayInputStream(convertReader.toByteArray());
                        InputStream converted = AsyncImageDownloader.convertToPng(convertWriter);
                        IOUtils.copy((InputStream)converted, (OutputStream)fileOut);
                        this.unregisteredImages.add(downloadURI);
                        continue;
                    }
                    finally {
                        if (fileOut == null) continue;
                        fileOut.close();
                        continue;
                    }
                }
                finally {
                    if (URIIn == null) continue;
                    URIIn.close();
                    continue;
                }
            }
            catch (Exception e) {
                this.errorImages.add(downloadURI);
                try {
                    Files.deleteIfExists(URIFile);
                    continue;
                }
                catch (IOException deleteException) {
                    Imaginebook.LOGGER.error("Failed to clean up incomplete file: " + String.valueOf(URIFile));
                    deleteException.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    public BookDrawable requestTexture(String URIStr) {
        URI URI2 = null;
        try {
            URI2 = new URL(URIStr).toURI();
        }
        catch (MalformedURLException e) {
            return URI_INVALID_ERROR;
        }
        catch (URISyntaxException e) {
            return URI_INVALID_ERROR;
        }
        if (this.downloadedImages.containsKey(URI2.toString())) {
            return this.downloadedImages.get(URI2.toString());
        }
        if (this.inProgressImages.contains(URI2)) {
            return DOWNLOADING_IMAGE;
        }
        if (this.inProgressRetryImages.contains(URI2)) {
            return ERROR_IMAGE;
        }
        if (this.errorImages.contains(URI2)) {
            this.inProgressRetryImages.add(URI2);
            this.errorImages.remove(URI2);
            return ERROR_IMAGE;
        }
        if (this.overLimitImages.contains(URI2)) {
            return SIZE_ERROR;
        }
        if (Files.exists(this.URIPath(URI2), new LinkOption[0])) {
            this.unregisteredImages.add(URI2);
        }
        if (this.unregisteredImages.contains(URI2)) {
            BookDrawable image = null;
            try {
                image = AsyncImageDownloader.registerTexture(new FileInputStream(this.URIPath(URI2).toFile()), this.URIIdentifier(URI2));
                this.downloadedImages.put(URI2.toString(), image);
                this.unregisteredImages.remove(URI2);
            }
            catch (FileNotFoundException e) {
                this.errorImages.add(URI2);
                return ERROR_IMAGE;
            }
            return image;
        }
        this.inProgressImages.add(URI2);
        return ERROR_IMAGE;
    }

    public static BookDrawable registerTexture(InputStream texture, class_2960 identifier) {
        class_1011 nativeImage = AsyncImageDownloader.toNativeImage(texture);
        class_1043 backedTestTexture = new class_1043(nativeImage);
        class_310.method_1551().method_1531().method_4616(identifier, (class_1044)backedTestTexture);
        return new Image(identifier, new Image.ImageSize(nativeImage.method_4307(), nativeImage.method_4323()));
    }

    public static class_1011 toNativeImage(InputStream file) {
        try {
            class_1011 nativeImage = class_1011.method_4309((InputStream)file);
            file.close();
            return nativeImage;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("problem registring texture", new Object[0]));
        }
    }

    public static InputStream convertToPng(InputStream inputStream) throws IOException {
        BufferedImage inputImage = ImageIO.read(inputStream);
        if (inputImage == null) {
            throw new IOException("The input stream does not contain a valid image.");
        }
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        boolean success = ImageIO.write((RenderedImage)inputImage, "png", pngOutputStream);
        if (!success) {
            throw new IOException("Failed to write the image in PNG format.");
        }
        return new ByteArrayInputStream(pngOutputStream.toByteArray());
    }
}

