/*
 * Decompiled with CFR 0.152.
 */
package dev.bscit.item_labels.components;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_8824;
import net.minecraft.class_9299;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public class LabelsComponent
implements class_9299 {
    private static final int MAX_LABELS = 256;
    private static final class_2561 tooltipTemplate = class_2561.method_43470((String)"- ").method_27692(class_124.field_1080);
    private static final class_2561 tooltipTitleTemplate = class_2561.method_43471((String)"item_labels.tooltip.labels").method_27693(":").method_27692(class_124.field_1080);
    public static final Codec<LabelsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)class_8824.field_46597).fieldOf("labels").forGetter(LabelsComponent::getLabels)).apply((Applicative)instance, LabelsComponent::new));
    private final List<class_2561> labels;

    private List<class_2561> getLabels() {
        return this.labels;
    }

    public LabelsComponent(class_2371<class_2561> labels) {
        if (labels.size() > 256) {
            throw new IllegalArgumentException("Got " + labels.size() + " items, but maximum is 256");
        }
        this.labels = Lists.newArrayList();
        this.labels.addAll((Collection<class_2561>)labels);
    }

    private LabelsComponent(int size) {
        this((class_2371<class_2561>)class_2371.method_10213((int)size, (Object)class_2561.method_43473()));
    }

    private LabelsComponent(List<class_2561> list) {
        this(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.labels.set(i, list.get(i));
        }
    }

    public static LabelsComponent from(List<class_2561> list) {
        LabelsComponent labelsComponent = new LabelsComponent(list.size());
        int i = 0;
        for (class_2561 str : list) {
            labelsComponent.labels.set(i, str);
            ++i;
        }
        return labelsComponent;
    }

    public class_2561 last() {
        return this.labels.getLast();
    }

    public boolean isEmpty() {
        return this.labels.isEmpty();
    }

    public class_1799 pop() {
        if (this.isEmpty()) {
            return null;
        }
        class_1799 stack = new class_1799((class_1935)class_1802.field_8448, 1);
        stack.method_57379(class_9334.field_49631, (Object)this.last().method_27662());
        this.labels.removeLast();
        return stack;
    }

    public LabelsComponent withLabel(class_1799 stack) {
        this.labels.add(this.labels.size(), stack.method_7964());
        return this;
    }

    public LabelsComponent withLabel(class_2561 text) {
        this.labels.add(this.labels.size(), text);
        return this;
    }

    public void push(class_1799 stack) {
        this.labels.add(this.labels.size(), stack.method_7964());
    }

    public void push(class_2561 text) {
        this.labels.add(this.labels.size(), text);
    }

    public boolean contains(class_1799 stack) {
        return this.labels.contains(stack.method_7964());
    }

    public boolean contains(class_2561 text) {
        return this.labels.contains(text);
    }

    public boolean containsAll(LabelsComponent other) {
        return this.labels.containsAll(other.labels);
    }

    public boolean containsAll(Collection<class_2561> list) {
        return this.labels.containsAll(list);
    }

    public boolean dyeLast(class_124 formatting) {
        class_5250 text = this.labels.getLast().method_27661();
        this.labels.set(this.labels.size() - 1, (class_2561)text.method_27692(formatting));
        return true;
    }

    public void undyeLast() {
        class_5250 text = this.labels.getLast().method_27661();
        text.method_10862(class_2583.field_24360);
        this.labels.set(this.labels.size() - 1, (class_2561)text);
    }

    public static LabelsComponent makeCopy(LabelsComponent labelsComponent) {
        LabelsComponent newComponent = new LabelsComponent(labelsComponent.labels.size());
        int i = 0;
        for (class_2561 str : labelsComponent.labels) {
            newComponent.labels.set(i, (class_2561)str.method_27661());
            ++i;
        }
        return newComponent;
    }

    public LabelsComponent copyTo(LabelsComponent other) {
        for (class_2561 str : this.labels) {
            other.labels.add(other.labels.size(), (class_2561)str.method_27661());
        }
        return other;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof LabelsComponent)) return false;
        LabelsComponent labelsComponent = (LabelsComponent)object;
        if (!this.labels.equals(labelsComponent.labels)) return false;
        return true;
    }

    public int hashCode() {
        return this.labels.hashCode();
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipConsumer, class_1836 type, class_9473 componentsAccess) {
        if (this.isEmpty()) {
            return;
        }
        tooltipConsumer.accept((class_2561)tooltipTitleTemplate.method_27661());
        for (class_2561 txt : this.labels) {
            class_5251 col = txt.method_10866().method_10973();
            if (col == class_5251.method_27718((class_124)class_124.field_1070)) {
                col = class_5251.method_27718((class_124)class_124.field_1054);
            }
            class_5251 c = col;
            tooltipConsumer.accept((class_2561)tooltipTemplate.method_27661().method_10852((class_2561)txt.method_27661().method_27694(style -> style.method_27703(c))));
        }
    }
}

