/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.data;

import foundry.veil.api.client.render.rendertype.VeilRenderType;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.NativeImageTracker;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.AbstractPage;
import wawa.mapwright.data.PageIO;

public class Page
extends AbstractPage {
    private final class_2960 textureID;
    private final class_1043 texture;
    private boolean uploadDirty = true;
    private boolean diskDirty = false;

    public Page(int rx, int ry, class_1043 texture) {
        super(rx, ry);
        this.texture = texture;
        this.textureID = MapwrightClient.id("map_" + rx + "_" + ry);
        class_310.method_1551().method_1531().method_4616(this.textureID, (class_1044)texture);
    }

    public Page(int rx, int ry) {
        this(rx, ry, new class_1043(512, 512, false));
        this.texture.method_4525().method_4326(0, 0, 512, 512, 0);
    }

    @Override
    public void setPixel(int x, int y, int RGBA) {
        this.texture.method_4525().method_4305(x, y, RGBA);
        this.uploadDirty = true;
        this.diskDirty = true;
    }

    @Override
    public class_1011 getImage() {
        return this.texture.method_4525();
    }

    @Override
    public class_1011 unboChanges(class_1011 replacement) {
        class_1011 previous = NativeImageTracker.newImage(512, 512, false);
        previous.method_4317(this.texture.method_4525());
        this.texture.method_4525().method_4317(replacement);
        replacement.close();
        this.diskDirty = true;
        this.uploadDirty = true;
        return previous;
    }

    @Override
    public int getPixel(int x, int y) {
        return this.texture.method_4525().method_4315(x, y);
    }

    @Override
    public void render(class_332 guiGraphics, double xOff, double yOff) {
        super.render(guiGraphics, xOff, yOff);
        class_1921 renderType = VeilRenderType.get((class_2960)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{this.textureID});
        if (renderType == null) {
            return;
        }
        if (this.uploadDirty) {
            this.texture.method_4524();
        }
        Rendering.renderTypeBlit(guiGraphics, renderType, (double)this.left() + xOff, (double)this.top() + yOff, 0, 0.0f, 0.0f, 512, 512, 512, 512, 1.0f);
    }

    @Override
    public void save(PageIO pageIO, boolean close) {
        if (this.diskDirty) {
            this.diskDirty = false;
            class_156.method_27958().execute(() -> {
                pageIO.trySaveImage(this.rx, this.ry, this.isEmpty() ? null : this.texture.method_4525());
                if (close) {
                    this.close();
                }
            });
        }
    }

    public boolean isEmpty() {
        int[] pixels;
        for (int pixel : pixels = this.texture.method_4525().method_48463()) {
            if (pixel == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void close() {
        class_310.method_1551().method_1531().method_4615(this.textureID);
    }
}

