/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import wawa.mapwright.DistantRaycast;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.compat.multithread_testing.DHBridge;
import wawa.mapwright.compat.multithread_testing.DhRequest;
import wawa.mapwright.data.Pin;
import wawa.mapwright.map.MapScreen;

public class SpyglassPins {
    private static final class_2960 PING_RENDERTYPE = MapwrightClient.id("ping");
    private static final class_2960 PING_TEXTURE = MapwrightClient.id("textures/gui/sprites/pin/spyglass/spyglass.png");
    private static final Vector3d EMPTY = new Vector3d();
    public static final int MAX_PINS = 16;
    private final List<PinData> pins = new ArrayList<PinData>();
    private final List<DhRequest> delayedPins = new ArrayList<DhRequest>();
    private int zoomlessTimer = 0;

    public List<PinData> getPins() {
        return this.pins;
    }

    public void addDelayedRequest(DhRequest request) {
        this.delayedPins.add(request);
        DHBridge.addRequest(request);
    }

    public void add(Vector3dc position) {
        if (this.pins.size() < 16) {
            this.pins.add(new PinData(position));
            class_310.method_1551().field_1724.method_5783(class_3417.field_26981, 0.25f, 1.0f);
            for (int i = 0; i < 20; ++i) {
                class_310.method_1551().field_1713.method_3056((class_2394)new class_2388(class_2398.field_11217, class_2246.field_27119.method_9564()), position.x(), position.y(), position.z(), 0.0, 0.1, 0.0);
            }
        }
    }

    public void clear() {
        if (!this.pins.isEmpty()) {
            class_310.method_1551().field_1724.method_5783(class_3417.field_43154, 0.25f, 1.0f);
            this.pins.clear();
            this.delayedPins.clear();
            DHBridge.voidRequests();
            DistantRaycast.clearCache();
        }
    }

    public void tick() {
        if (class_310.method_1551().field_1724 != null) {
            int size = this.delayedPins.size();
            Iterator<DhRequest> iter = this.delayedPins.iterator();
            while (iter.hasNext()) {
                DhRequest req = iter.next();
                if (!req.isFinished()) continue;
                iter.remove();
                if (req.finishedLoc().equals((Object)EMPTY)) continue;
                this.add((Vector3dc)req.finishedLoc());
                if (size != 1) continue;
                MapwrightClient.targetPanningPosition.set(req.finishedLoc().x, req.finishedLoc().z);
            }
            if (!this.delayedPins.isEmpty()) {
                boolean oneTookLong = false;
                for (DhRequest delayedPin : this.delayedPins) {
                    int ticks = delayedPin.ticksSinceRequested.incrementAndGet();
                    if (ticks <= 20) continue;
                    oneTookLong = true;
                }
                if (oneTookLong) {
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Triangulating Position..."), true);
                }
            }
            if (Helper.isUsingSpyglass((class_1657)class_310.method_1551().field_1724) || class_310.method_1551().field_1755 instanceof MapScreen) {
                this.zoomlessTimer = 0;
            } else if (!class_310.method_1551().method_1493()) {
                ++this.zoomlessTimer;
                if (this.zoomlessTimer > 200) {
                    this.clear();
                }
            }
        }
    }

    public void render(class_4597 bufferSource, class_4587 poseStack, float partialTick) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Quaternionf quaternion = new Quaternionf(0.0f, camera.method_23767().y, 0.0f, camera.method_23767().w);
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23576((class_2960)PING_TEXTURE));
        poseStack.method_22903();
        poseStack.method_22904(-camera.method_19326().method_10216(), -camera.method_19326().method_10214(), -camera.method_19326().method_10215());
        for (PinData ping : this.pins) {
            poseStack.method_22903();
            poseStack.method_22904(ping.position.x(), ping.position.y(), ping.position.z());
            SpyglassPins.renderPing(consumer, poseStack.method_23760(), partialTick, (Quaternionfc)quaternion);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private static void renderPing(class_4588 consumer, class_4587.class_4665 pose, float partialTick, Quaternionfc quaternion) {
        SpyglassPins.vertex(consumer, pose, -0.5f, 0.0f, 0.25f, 0.0f, 1.0f, quaternion);
        SpyglassPins.vertex(consumer, pose, 0.5f, 0.0f, 0.25f, 1.0f, 1.0f, quaternion);
        SpyglassPins.vertex(consumer, pose, 0.5f, 1.0f, 0.25f, 1.0f, 0.0f, quaternion);
        SpyglassPins.vertex(consumer, pose, -0.5f, 1.0f, 0.25f, 0.0f, 0.0f, quaternion);
    }

    private static void vertex(class_4588 consumer, class_4587.class_4665 pose, float x, float y, float z, float u, float v, Quaternionfc quaternion) {
        Vector3f vec = new Vector3f(x, y, z).rotate(quaternion);
        consumer.method_56824(pose, vec.x, vec.y, vec.z).method_22914(0.0f, 1.0f, 0.0f).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_39415(-1);
    }

    public record PinData(Pin pin, Vector3dc position) {
        public PinData(Vector3dc position) {
            this(new Pin(Pin.SPYGLASS_EPHEMERAL, new Vector2d(position.x(), position.z())), position);
        }
    }
}

