/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.compat.multithread_testing;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.data.IDhApiTerrainDataCache;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import com.seibel.distanthorizons.api.objects.data.DhApiRaycastResult;
import java.util.Queue;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import wawa.mapwright.compat.multithread_testing.DhRequest;

public class DHThread
extends Thread {
    private final Queue<DhRequest> requests;
    private final IDhApiTerrainDataCache cache;

    public DHThread(Queue<DhRequest> requests) {
        this.requests = requests;
        this.cache = DhApi.Delayed.terrainRepo.getSoftCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            DhRequest request = null;
            Queue<DhRequest> queue = this.requests;
            synchronized (queue) {
                if (!this.requests.isEmpty()) {
                    request = this.requests.poll();
                }
            }
            if (request == null) {
                LockSupport.park(this);
                continue;
            }
            Vector3d clip = this.clip(request.origin(), request.direction(), request.length());
            if (clip != null) {
                request.setFinishedLoc(clip);
            }
            request.setFinished();
        }
    }

    @Nullable
    private Vector3d clip(Vec3 origin, Vec3 direction, int length) {
        if (!DhApi.Delayed.worldProxy.worldLoaded()) {
            return null;
        }
        IDhApiLevelWrapper levelWrapper = DhApi.Delayed.worldProxy.getSinglePlayerLevel();
        if (levelWrapper == null) {
            return null;
        }
        DhApiResult result = DhApi.Delayed.terrainRepo.raycast(levelWrapper, origin.x, origin.y, origin.z, (float)direction.x, (float)direction.y, (float)direction.z, length, this.cache);
        if (result.success && result.payload != null) {
            return new Vector3d((double)((DhApiRaycastResult)result.payload).pos.x, (double)((DhApiRaycastResult)result.payload).pos.y, (double)((DhApiRaycastResult)result.payload).pos.z);
        }
        return null;
    }

    private synchronized void clearCache() {
    }
}

