/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.data.Pin;
import wawa.mapwright.mixin.BiomeManagerAccessor;
import wawa.mapwright.mixin.MinecraftServerAccessor;
import wawa.mapwright.mixin.MultiPlayerGameModeAccessor;

public class PageIO {
    public static final String mapName = "mapwright_maps";
    private final Path pagePath;

    public PageIO(Level level, Minecraft client) {
        this.pagePath = this.buildMapPath(level, client);
        try {
            Files.createDirectories(this.pagePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            MapwrightClient.LOGGER.error("Could not create map directory", (Throwable)e);
        }
    }

    private Path buildMapPath(Level level, Minecraft client) {
        Path path = client.gameDirectory.toPath().resolve(mapName);
        long seed = ((BiomeManagerAccessor)level.getBiomeManager()).getBiomeZoomSeed();
        path = client.isLocalServer() ? path.resolve("singleplayer").resolve(((MinecraftServerAccessor)client.getSingleplayerServer()).getStorageSource().getLevelId()) : path.resolve("multiplayer").resolve(((MultiPlayerGameModeAccessor)client.gameMode).getConnection().getServerData().ip.replace(":", "_"));
        return path.resolve(level.dimension().location().toDebugFileName() + "_" + seed);
    }

    public Path getPagePath() {
        return this.pagePath;
    }

    public Path pageFilepath(int rx, int ry) {
        return this.pagePath.resolve(String.format("%d_%d.png", rx, ry));
    }

    @Nullable
    public NativeImage tryLoadImage(int rx, int ry) {
        Path path = this.pageFilepath(rx, ry);
        File file = new File(path.toUri());
        if (file.isFile()) {
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                return NativeImage.read((InputStream)inputStream);
            }
            catch (IOException e) {
                MapwrightClient.LOGGER.error("Failed to load image {}\n{}", (Object)path, (Object)e);
            }
        }
        return null;
    }

    public void trySaveImage(int rx, int ry, @Nullable NativeImage image) {
        Path path = this.pageFilepath(rx, ry);
        try {
            if (image == null) {
                Files.deleteIfExists(path);
            } else {
                image.writeToFile(path);
            }
        }
        catch (IOException e) {
            MapwrightClient.LOGGER.error("Failed to save region {} {} to {}\n{}", new Object[]{rx, ry, path, e});
        }
    }

    public void savePins(Map<Pin.Type, Pin> pins) {
        Gson gson = new Gson();
        JsonObject pinsObject = new JsonObject();
        for (Map.Entry<Pin.Type, Pin> entry : pins.entrySet()) {
            JsonArray position = new JsonArray();
            position.add((Number)entry.getValue().getPosition().x());
            position.add((Number)entry.getValue().getPosition().y());
            JsonObject pinObject = new JsonObject();
            pinObject.add("position", (JsonElement)position);
            pinsObject.add(entry.getKey().id().toString(), (JsonElement)pinObject);
        }
        try (FileWriter writer = new FileWriter(this.pagePath.resolve("pins.json").toFile(), false);){
            gson.toJson((JsonElement)pinsObject, (Appendable)writer);
        }
        catch (IOException e) {
            MapwrightClient.LOGGER.error("Error saving pin data", (Throwable)e);
        }
    }

    public Map<Pin.Type, Pin> readPins() {
        Gson gson = new Gson();
        File file = this.pagePath.resolve("pins.json").toFile();
        if (file.exists() && file.isFile()) {
            HashMap<Pin.Type, Pin> hashMap;
            FileReader reader = new FileReader(file);
            try {
                JsonObject pinsObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                HashMap<Pin.Type, Pin> pins = new HashMap<Pin.Type, Pin>();
                for (Map.Entry entry : pinsObject.entrySet()) {
                    JsonElement position;
                    ResourceLocation id = ResourceLocation.tryParse((String)((String)entry.getKey()));
                    Pin.Type type = Pin.getType(id);
                    if (type == null) {
                        MapwrightClient.LOGGER.warn("Unknown pin type {}", (Object)id);
                        continue;
                    }
                    if (!((JsonElement)entry.getValue()).isJsonObject() || !(position = ((JsonElement)entry.getValue()).getAsJsonObject().get("position")).isJsonArray() || position.getAsJsonArray().size() < 2) continue;
                    Pin pin = new Pin(type);
                    pin.setPosition((Vector2dc)new Vector2d(position.getAsJsonArray().get(0).getAsDouble(), position.getAsJsonArray().get(1).getAsDouble()));
                    pins.put(type, pin);
                }
                hashMap = pins;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    MapwrightClient.LOGGER.error("Error reading pin data", (Throwable)e);
                }
            }
            reader.close();
            return hashMap;
        }
        return new HashMap<Pin.Type, Pin>();
    }
}

