/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.data;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import wawa.mapwright.DistantRaycast;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.compat.multithread_testing.DHBridge;
import wawa.mapwright.compat.multithread_testing.DhRequest;
import wawa.mapwright.data.Pin;
import wawa.mapwright.map.MapScreen;

public class SpyglassPins {
    private static final ResourceLocation PING_RENDERTYPE = MapwrightClient.id("ping");
    private static final ResourceLocation PING_TEXTURE = MapwrightClient.id("textures/gui/sprites/pin/spyglass/spyglass.png");
    private static final Vector3d EMPTY = new Vector3d();
    public static final int MAX_PINS = 16;
    private final List<PinData> pins = new ArrayList<PinData>();
    private final List<DhRequest> delayedPins = new ArrayList<DhRequest>();
    private int zoomlessTimer = 0;

    public List<PinData> getPins() {
        return this.pins;
    }

    public void addDelayedRequest(DhRequest request) {
        this.delayedPins.add(request);
        DHBridge.addRequest(request);
    }

    public void add(Vector3dc position) {
        if (this.pins.size() < 16) {
            this.pins.add(new PinData(position));
            Minecraft.getInstance().player.playSound(SoundEvents.AMETHYST_BLOCK_FALL, 0.25f, 1.0f);
            for (int i = 0; i < 20; ++i) {
                Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.COPPER_BLOCK.defaultBlockState()), position.x(), position.y(), position.z(), 0.0, 0.1, 0.0);
            }
        }
    }

    public void clear() {
        if (!this.pins.isEmpty()) {
            Minecraft.getInstance().player.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE, 0.25f, 1.0f);
            this.pins.clear();
            this.delayedPins.clear();
            DHBridge.voidRequests();
            DistantRaycast.clearCache();
        }
    }

    public void tick() {
        if (Minecraft.getInstance().player != null) {
            int size = this.delayedPins.size();
            Iterator<DhRequest> iter = this.delayedPins.iterator();
            while (iter.hasNext()) {
                DhRequest req = iter.next();
                if (!req.isFinished()) continue;
                iter.remove();
                if (req.finishedLoc().equals((Object)EMPTY)) continue;
                this.add((Vector3dc)req.finishedLoc());
                if (size != 1) continue;
                MapwrightClient.targetPanningPosition.set(req.finishedLoc().x, req.finishedLoc().z);
            }
            if (!this.delayedPins.isEmpty()) {
                boolean oneTookLong = false;
                for (DhRequest delayedPin : this.delayedPins) {
                    int ticks = delayedPin.ticksSinceRequested.incrementAndGet();
                    if (ticks <= 20) continue;
                    oneTookLong = true;
                }
                if (oneTookLong) {
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Triangulating Position..."), true);
                }
            }
            if (Helper.isUsingSpyglass((Player)Minecraft.getInstance().player) || Minecraft.getInstance().screen instanceof MapScreen) {
                this.zoomlessTimer = 0;
            } else if (!Minecraft.getInstance().isPaused()) {
                ++this.zoomlessTimer;
                if (this.zoomlessTimer > 200) {
                    this.clear();
                }
            }
        }
    }

    public void render(MultiBufferSource bufferSource, PoseStack poseStack, float partialTick) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Quaternionf quaternion = new Quaternionf(0.0f, camera.rotation().y, 0.0f, camera.rotation().w);
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)PING_TEXTURE));
        poseStack.pushPose();
        poseStack.translate(-camera.getPosition().x(), -camera.getPosition().y(), -camera.getPosition().z());
        for (PinData ping : this.pins) {
            poseStack.pushPose();
            poseStack.translate(ping.position.x(), ping.position.y(), ping.position.z());
            SpyglassPins.renderPing(consumer, poseStack.last(), partialTick, (Quaternionfc)quaternion);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private static void renderPing(VertexConsumer consumer, PoseStack.Pose pose, float partialTick, Quaternionfc quaternion) {
        SpyglassPins.vertex(consumer, pose, -0.5f, 0.0f, 0.25f, 0.0f, 1.0f, quaternion);
        SpyglassPins.vertex(consumer, pose, 0.5f, 0.0f, 0.25f, 1.0f, 1.0f, quaternion);
        SpyglassPins.vertex(consumer, pose, 0.5f, 1.0f, 0.25f, 1.0f, 0.0f, quaternion);
        SpyglassPins.vertex(consumer, pose, -0.5f, 1.0f, 0.25f, 0.0f, 0.0f, quaternion);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, float u, float v, Quaternionfc quaternion) {
        Vector3f vec = new Vector3f(x, y, z).rotate(quaternion);
        consumer.addVertex(pose, vec.x, vec.y, vec.z).setNormal(0.0f, 1.0f, 0.0f).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setColor(-1);
    }

    public record PinData(Pin pin, Vector3dc position) {
        public PinData(Vector3dc position) {
            this(new Pin(Pin.SPYGLASS_EPHEMERAL, new Vector2d(position.x(), position.z())), position);
        }
    }
}

