/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.input;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import wawa.mapwright.DistantRaycast;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.compat.multithread_testing.DHBridge;
import wawa.mapwright.data.SpyglassPins;
import wawa.mapwright.map.MapScreen;
import wawa.mapwright.platform.MapWrightServices;
import wawa.mapwright.platform.services.IKeyMappings;

public class InputListener {
    public static void tick(Minecraft minecraft) {
        while (minecraft.level != null && MapWrightServices.KEY_MAPPINGS.consume(IKeyMappings.Normal.OPEN_MAP)) {
            Vector2d playerPosition = new Vector2d((double)((int)minecraft.player.getX()), (double)((int)minecraft.player.getZ()));
            minecraft.level.playLocalSound((Entity)Minecraft.getInstance().player, SoundEvents.BOOK_PAGE_TURN, SoundSource.MASTER, 0.5f, 1.0f);
            if (MapwrightClient.PAGE_MANAGER.pageIO.getPagePath().endsWith("_0")) {
                MapwrightClient.PAGE_MANAGER.reloadPageIO((Level)minecraft.level, minecraft);
            }
            if (Helper.isUsingSpyglass((Player)minecraft.player)) {
                Vector3d target = InputListener.getEndingPosition(minecraft.player);
                if (target != null) {
                    MapwrightClient.PAGE_MANAGER.getSpyglassPins().add((Vector3dc)target);
                } else {
                    target = new Vector3d(minecraft.player.getX(), minecraft.player.getY(), minecraft.player.getZ());
                    MapwrightClient.PAGE_MANAGER.getSpyglassPins().addDelayedRequest(DHBridge.createRequest(minecraft.player));
                }
                MapwrightClient.targetPanningPosition.set(target.x, target.z);
                minecraft.setScreen((Screen)new MapScreen(playerPosition));
                return;
            }
            int numPins = MapwrightClient.PAGE_MANAGER.getSpyglassPins().getPins().size();
            if (numPins >= 1) {
                double avgX = 0.0;
                double avgZ = 0.0;
                for (SpyglassPins.PinData pin : MapwrightClient.PAGE_MANAGER.getSpyglassPins().getPins()) {
                    avgX += pin.position().x() / (double)numPins;
                    avgZ += pin.position().z() / (double)numPins;
                }
                MapwrightClient.targetPanningPosition.set(avgX, avgZ);
                minecraft.setScreen((Screen)new MapScreen(playerPosition));
                return;
            }
            MapwrightClient.targetPanningPosition.set((Vector2dc)playerPosition);
            minecraft.setScreen((Screen)new MapScreen(playerPosition));
        }
    }

    @Nullable
    public static Vector3d getEndingPosition(LocalPlayer player) {
        return DistantRaycast.clip((Player)player, player.getEyePosition(), player.getLookAngle(), Minecraft.getInstance().options.getEffectiveRenderDistance() * 16, DHBridge.getViewDistance());
    }
}

