/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.lwjgl.glfw.GLFW;
import wawa.mapwright.Helper;
import wawa.mapwright.LerpedVector2d;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.map.StampBagScreen;
import wawa.mapwright.map.stamp_bag.widgets.StampBagWidget;
import wawa.mapwright.map.tool.PanTool;
import wawa.mapwright.map.widgets.CompassWidget;
import wawa.mapwright.map.widgets.DebugTextRenderable;
import wawa.mapwright.map.widgets.MapWidget;
import wawa.mapwright.map.widgets.ToolPickerWidget;
import wawa.mapwright.platform.MapWrightServices;
import wawa.mapwright.platform.services.IKeyMappings;

public class MapScreen
extends Screen {
    private int zoomNum = 0;
    private float zoom = 1.0f;
    public LerpedVector2d lerpedPanning;
    public Vector2d backgroundPanning = new Vector2d();
    private MapWidget mapWidget;
    public ToolPickerWidget toolPicker;
    public CompassWidget compassWidget;
    public List<AbstractWidget> allWidgets = new ArrayList<AbstractWidget>();
    public StampBagWidget stampBag;
    public StampBagScreen stampScreen;
    public static boolean cursorAdjusted;

    public MapScreen(Vector2d openingPos) {
        super((Component)Component.literal((String)"Mapwright Map"));
        this.lerpedPanning = new LerpedVector2d(openingPos, MapwrightClient.targetPanningPosition);
        cursorAdjusted = false;
    }

    protected void init() {
        super.init();
        this.mapWidget = new MapWidget(this);
        this.allWidgets.add(this.mapWidget);
        this.addRenderableWidget(this.mapWidget);
        int toolX = this.width - 20 - 8;
        this.toolPicker = new ToolPickerWidget(toolX, 50);
        this.allWidgets.add(this.toolPicker);
        this.addRenderableWidget(this.toolPicker);
        this.stampBag = new StampBagWidget(toolX, this.toolPicker.finalToolY + 20, this);
        this.allWidgets.add(this.stampBag);
        this.addRenderableWidget(this.stampBag);
        this.compassWidget = new CompassWidget(this.width - 110, this.height - 110);
        this.addRenderableOnly((Renderable)this.compassWidget);
        this.addRenderableOnly(new DebugTextRenderable(this));
        if (MapwrightClient.TOOL_MANAGER.get() instanceof PanTool) {
            GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().getWindow(), (int)208897, (int)212993);
        } else {
            GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().getWindow(), (int)208897, (int)212994);
        }
        this.stampScreen = StampBagScreen.INSTANCE;
        this.stampScreen.setMapScreen(this);
        this.stampScreen.changeStage(this.stampScreen.getState());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Vector2d diffTracker = new Vector2d();
        this.lerpedPanning.tickProgress(0.05 * (double)Minecraft.getInstance().getTimer().getRealtimeDeltaTicks(), diffTracker);
        this.backgroundPanning.add((Vector2dc)diffTracker.mul((double)this.zoom));
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.stampScreen.renderScreen(guiGraphics, mouseX, mouseY, partialTick);
        Vec2 mouse = Helper.preciseMousePos();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(mouse.x % 1.0f, mouse.y % 1.0f, 0.0f);
        MapwrightClient.TOOL_MANAGER.get().renderScreen(guiGraphics, mouseX, mouseY);
        guiGraphics.pose().popPose();
    }

    public List<? extends GuiEventListener> children() {
        return super.children().reversed();
    }

    public Vector2d screenToWorld(Vector2d mouse) {
        return new Vector2d((Vector2dc)mouse).sub((double)this.width / 2.0, (double)this.height / 2.0).div((double)this.zoom).add((Vector2dc)this.lerpedPanning.get());
    }

    public void deltaZoom(int delta) {
        this.zoomNum = Mth.clamp((int)(this.zoomNum + delta), (int)-2, (int)3);
        this.zoom = (float)Math.pow(2.0, this.zoomNum);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.mapWidget.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean result = super.mouseReleased(mouseX, mouseY, button);
        this.mapWidget.mouseType = MapWidget.MouseType.NONE;
        return result;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        StampBagScreen.INSTANCE.mouseClicked(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.stampScreen.hasAnyTextBoxFoxused()) {
            if (MapWrightServices.KEY_MAPPINGS.matches(IKeyMappings.Normal.OPEN_MAP, keyCode, scanCode, modifiers)) {
                this.onClose();
                return true;
            }
            if (MapWrightServices.KEY_MAPPINGS.matches(IKeyMappings.Normal.SWAP, keyCode, scanCode, modifiers)) {
                MapwrightClient.TOOL_MANAGER.swap();
            }
            if (MapWrightServices.KEY_MAPPINGS.matches(IKeyMappings.Normal.UNDO, keyCode, scanCode, modifiers)) {
                MapwrightClient.PAGE_MANAGER.undoChanges();
            }
            if (MapWrightServices.KEY_MAPPINGS.matches(IKeyMappings.Normal.REDO, keyCode, scanCode, modifiers)) {
                MapwrightClient.PAGE_MANAGER.redoChanges();
            }
            IKeyMappings.ToolSwap toolSwap = MapWrightServices.KEY_MAPPINGS.getToolSwap(keyCode, scanCode, modifiers);
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"HAND", "BRUSH", "PEN", "ERASER"}, (IKeyMappings.ToolSwap)toolSwap, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    this.toolPicker.pickHand();
                    break;
                }
                case 1: {
                    this.toolPicker.pickBrush();
                    break;
                }
                case 2: {
                    this.toolPicker.pickPen();
                    break;
                }
                case 3: {
                    this.toolPicker.pickEraser();
                }
                case -1: 
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        super.onClose();
        this.minecraft.level.playLocalSound((Entity)Minecraft.getInstance().player, SoundEvents.BOOK_PUT, SoundSource.MASTER, 1.0f, 0.5f);
        StampBagScreen.INSTANCE.changeStage(StampBagScreen.ScreenState.IDLE);
        this.stampScreen.parentClose();
        MapwrightClient.PAGE_MANAGER.getSpyglassPins().clear();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public float getScale() {
        return this.zoom;
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        return (T)super.addRenderableWidget(widget);
    }

    public <T extends GuiEventListener & NarratableEntry> T addWidget(T listener) {
        return (T)super.addWidget(listener);
    }

    public void removeWidget(GuiEventListener listener) {
        super.removeWidget(listener);
    }

    public void clearWidgets() {
        super.clearWidgets();
    }

    public void rebuildWidgets() {
        super.rebuildWidgets();
    }
}

