/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.gui.GUIElementAtlases;
import wawa.mapwright.map.MapScreen;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.map.stamp_bag.widgets.DualGUIElement;
import wawa.mapwright.map.stamp_bag.widgets.GUIElementButton;
import wawa.mapwright.map.stamp_bag.widgets.StampEntryWidget;
import wawa.mapwright.map.tool.StampBagDebuggerTool;

public class StampBagScreen {
    public static final StampBagScreen INSTANCE = new StampBagScreen();
    public MapScreen mapScreen;
    private ScreenState state = ScreenState.IDLE;
    private final Set<AbstractWidget> allWidgets = new HashSet<AbstractWidget>();
    private final Set<AbstractWidget> activeWidgets = new HashSet<AbstractWidget>();
    private int page = 1;
    boolean usingSearch = false;
    boolean usingFavorites = false;
    private final List<StampInformation> requestedInfo = new ArrayList<StampInformation>();
    private final EditBox saveText;
    private GUIElementButton confirmSave;
    private GUIElementButton cancelSave;
    private final GUIElementButton up;
    private final GUIElementButton down;
    private final GUIElementButton favorites;
    private final EditBox searchWidget;
    public StampEntry[] entries = new StampEntry[3];
    private final int browseBGWidth = 178;
    private final int browseBGY = 100;
    private final int browseBGHeight = 138;

    public StampBagScreen() {
        this.saveText = new EditBox(Minecraft.getInstance().font, 72, 17, (Component)Component.empty());
        this.saveText.setFocused(false);
        this.saveText.setCanLoseFocus(true);
        this.saveText.setMaxLength(72);
        this.createSaveWidgets();
        this.createEntryWidgets();
        this.up = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_UP, b -> {
            int maxPageCount = this.usingSearch ? this.requestedInfo.size() : (this.usingFavorites ? MapwrightClient.STAMP_HANDLER.getTotalEntryCount(true) : MapwrightClient.STAMP_HANDLER.getTotalEntryCount());
            this.page = (int)Math.clamp((double)(this.page - 1), 1.0, maxPageCount == 0 ? 1.0 : Math.ceil((float)maxPageCount / 3.0f));
            this.refreshStamps();
        });
        this.down = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_DOWN, b -> {
            int maxPageCount = this.usingSearch ? this.requestedInfo.size() : (this.usingFavorites ? MapwrightClient.STAMP_HANDLER.getTotalEntryCount(true) : MapwrightClient.STAMP_HANDLER.getTotalEntryCount());
            this.page = (int)Math.clamp((double)(this.page + 1), 1.0, maxPageCount == 0 ? 1.0 : Math.ceil((float)maxPageCount / 3.0f));
            this.refreshStamps();
        });
        this.favorites = new DualGUIElement(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_UNFAVORITE, GUIElementAtlases.STAMP_BAG_BROWSE_FAVORITE, b -> {
            this.usingFavorites ^= true;
            this.page = 1;
            ((DualGUIElement)b).imageSwitch = this.usingFavorites;
            this.refreshStamps();
        });
        this.searchWidget = new EditBox(Minecraft.getInstance().font, GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() - 1, 16, (Component)Component.empty());
        this.searchWidget.setResponder(s -> {
            boolean bl = this.usingSearch = !s.isEmpty();
            if (!s.isEmpty()) {
                this.page = 1;
            }
            this.refreshStamps();
        });
        this.searchWidget.setFocused(false);
        this.searchWidget.setCanLoseFocus(true);
        this.searchWidget.setMaxLength(72);
    }

    private void createSaveWidgets() {
        this.confirmSave = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_SAVE_CONFIRM, b -> {
            NativeImage texture;
            if (!this.saveText.getValue().isEmpty() && this.mapScreen != null && (texture = MapwrightClient.STAMP_HANDLER.temporaryStampInformation.getTextureManager().getTexture()) != null) {
                NativeImage copied = new NativeImage(texture.getWidth(), texture.getHeight(), false);
                copied.copyFrom(texture);
                MapwrightClient.STAMP_HANDLER.addNewStamp(copied, this.saveText.getValue());
                this.saveText.setValue("");
                this.mapScreen.toolPicker.pickHand();
                this.changeStage(ScreenState.BROWSING);
                return;
            }
            this.changeStage(ScreenState.IDLE);
        });
        this.cancelSave = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_SAVE_CANCEL, b -> {
            this.saveText.setValue("");
            this.changeStage(ScreenState.IDLE);
        });
        this.allWidgets.addAll(List.of(this.saveText, this.confirmSave, this.cancelSave));
    }

    private void createEntryWidgets() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new StampEntry();
            StampEntry entry = this.entries[i];
            entry.self = new StampEntryWidget(0, 0, this, wid -> {}, MapwrightClient.id("stamp_widget_" + i));
            entry.delete = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_TRASH, b -> {
                StampInformation si = entry.self.stampInformation;
                if (si != null) {
                    MapwrightClient.STAMP_HANDLER.removeStamp(si);
                }
                this.refreshStamps();
            });
            entry.favorite = new DualGUIElement(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_UNFAVORITE, GUIElementAtlases.STAMP_BAG_BROWSE_FAVORITE, b -> {
                StampInformation si = entry.self.stampInformation;
                if (si != null) {
                    si.setFavorited(!si.isFavorited());
                    ((DualGUIElement)b).imageSwitch = si.isFavorited();
                    MapwrightClient.STAMP_HANDLER.setDirty();
                }
            });
        }
    }

    public void setMapScreen(MapScreen screen) {
        this.mapScreen = screen;
    }

    public void resetWidgetInfo() {
        this.allWidgets.forEach(w -> {
            w.active = false;
            w.setFocused(false);
        });
        int stampBagX = this.mapScreen.stampBag.getX();
        int stampBagY = this.mapScreen.stampBag.getY();
        StampBagScreen.setWidgetXY((AbstractWidget)this.saveText, stampBagX - 123, stampBagY - 1);
        StampBagScreen.setWidgetXY((AbstractWidget)this.confirmSave, stampBagX - 49, stampBagY);
        StampBagScreen.setWidgetXY((AbstractWidget)this.cancelSave, stampBagX - 28, stampBagY);
        int backgroundX = this.mapScreen.width - 15 - 8 - 164 - 21;
        int backgroundY = 100;
        for (int i = 0; i < this.entries.length; ++i) {
            int entryY = 126 + i * 37;
            StampEntry entry = this.entries[i];
            StampBagScreen.setWidgetXY(entry.self, backgroundX + 10, entryY);
            StampBagScreen.setWidgetXY((AbstractWidget)entry.favorite, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 9, entryY);
            StampBagScreen.setWidgetXY((AbstractWidget)entry.delete, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 9, entryY + 16);
        }
        StampBagScreen.setWidgetXY((AbstractWidget)this.up, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 28, 126);
        StampBagScreen.setWidgetXY((AbstractWidget)this.down, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 28, 216);
        StampBagScreen.setWidgetXY((AbstractWidget)this.favorites, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 9, 105);
        StampBagScreen.setWidgetXY((AbstractWidget)this.searchWidget, backgroundX + 10, 105);
    }

    private static void setWidgetXY(AbstractWidget w, int x, int y) {
        w.setX(x);
        w.setY(y);
    }

    public void changeStage(ScreenState newStage) {
        for (AbstractWidget w : this.activeWidgets) {
            this.mapScreen.removeWidget((GuiEventListener)w);
            w.setFocused(false);
            w.active = false;
        }
        this.resetWidgetInfo();
        this.activeWidgets.clear();
        if (this.state == ScreenState.BROWSING) {
            for (StampInformation si : this.requestedInfo) {
                si.getTextureManager().removeUser();
            }
        }
        this.state = newStage;
        switch (newStage.ordinal()) {
            case 1: {
                this.addWidget((AbstractWidget)this.saveText);
                this.addWidget((AbstractWidget)this.confirmSave);
                this.addWidget((AbstractWidget)this.cancelSave);
                this.setMapScreenWidgetActivity(false);
                break;
            }
            case 2: {
                if (this.refreshStamps()) {
                    return;
                }
                this.addWidget((AbstractWidget)this.up);
                this.addWidget((AbstractWidget)this.down);
                this.addWidget((AbstractWidget)this.searchWidget);
                this.addWidget((AbstractWidget)this.favorites);
                break;
            }
            case 0: {
                this.setMapScreenWidgetActivity(true);
            }
        }
    }

    private boolean refreshStamps() {
        for (StampInformation si : this.requestedInfo) {
            si.getTextureManager().removeUser();
        }
        this.requestedInfo.clear();
        int pageLoc = 3 * this.page;
        if (this.usingSearch) {
            MapwrightClient.STAMP_HANDLER.requestStampContaining(this.requestedInfo, this.searchWidget.getValue(), this.usingFavorites);
        } else {
            MapwrightClient.STAMP_HANDLER.bulkRequestStamps(this.requestedInfo, this.usingFavorites, pageLoc - 3, pageLoc - 2, pageLoc - 1);
        }
        for (int i = 0; i < 3; ++i) {
            int index = i;
            if (this.usingSearch) {
                index = pageLoc - (3 - i);
            }
            StampEntry entry = this.entries[i];
            if (!this.requestedInfo.isEmpty() && index >= 0 && index <= this.requestedInfo.size() - 1) {
                StampInformation si = this.requestedInfo.get(index);
                entry.self.changeStampInformation(si);
                this.addWidget(entry.self);
                this.addWidget((AbstractWidget)entry.delete);
                this.addWidget((AbstractWidget)entry.favorite);
                entry.favorite.imageSwitch = si.isFavorited();
                entry.addedWidgets = true;
                continue;
            }
            this.removeWidget(entry.self);
            this.removeWidget((AbstractWidget)entry.delete);
            this.removeWidget((AbstractWidget)entry.favorite);
            entry.self.changeStampInformation(null);
            entry.addedWidgets = false;
        }
        for (StampInformation si : this.requestedInfo) {
            si.getTextureManager().addUser();
        }
        return false;
    }

    private void setMapScreenWidgetActivity(boolean active) {
        for (AbstractWidget w : this.mapScreen.allWidgets) {
            w.active = active;
        }
        this.mapScreen.stampBag.active = true;
    }

    public void addWidget(AbstractWidget wid) {
        wid.active = true;
        this.mapScreen.addWidget(wid);
        this.activeWidgets.add(wid);
    }

    public void removeWidget(AbstractWidget wid) {
        this.mapScreen.removeWidget((GuiEventListener)wid);
        this.activeWidgets.remove(wid);
        wid.setFocused(false);
        wid.active = false;
    }

    public void renderScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack ps = guiGraphics.pose();
        ps.pushPose();
        ps.pushPose();
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        ps.popPose();
        ps.pushPose();
        for (AbstractWidget w : this.activeWidgets) {
            ps.pushPose();
            w.render(guiGraphics, mouseX, mouseY, partialTick);
            ps.popPose();
        }
        ps.popPose();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        switch (this.state.ordinal()) {
            case 1: {
                GUIElementAtlases background = GUIElementAtlases.STAMP_BAG_SAVE;
                int x = this.mapScreen.stampBag.getX() - background.width();
                int y = this.mapScreen.stampBag.getY() - 5;
                background.render(guiGraphics, x, y);
                break;
            }
            case 2: {
                int browseBGX = this.mapScreen.width - 15 - 8 - 164 - 21;
                guiGraphics.blitSprite(StampBagDebuggerTool.backgroundID, browseBGX, this.browseBGY, this.browseBGWidth, this.browseBGHeight);
                for (int i = 0; i < this.entries.length; ++i) {
                    if (this.entries[i].addedWidgets) {
                        GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.render(guiGraphics, browseBGX + 10, this.browseBGY + 26 + i * 37);
                    }
                    int maxPageCount = this.usingSearch ? this.requestedInfo.size() : (this.usingFavorites ? MapwrightClient.STAMP_HANDLER.getTotalEntryCount(true) : MapwrightClient.STAMP_HANDLER.getTotalEntryCount());
                    guiGraphics.drawString(Minecraft.getInstance().font, "%s/%s".formatted(maxPageCount == 0 ? 0 : this.page, (int)Math.ceil((float)maxPageCount / 3.0f)), browseBGX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 27, this.browseBGY + 74, Color.WHITE.getRGB(), true);
                }
                break;
            }
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        int browseBGX;
        if (this.state != ScreenState.IDLE && this.state != ScreenState.SAVING && (mouseX < (double)(browseBGX = this.mapScreen.width - 15 - 8 - 164 - 21) || mouseX > (double)(browseBGX + this.browseBGWidth) || mouseY < (double)this.browseBGY || mouseY > (double)(this.browseBGY + this.browseBGHeight)) && !this.mapScreen.stampBag.isHovered()) {
            this.changeStage(ScreenState.IDLE);
        }
    }

    public void parentClose() {
        for (AbstractWidget w : this.activeWidgets) {
            w.setFocused(false);
            this.mapScreen.removeWidget((GuiEventListener)w);
        }
        this.mapScreen = null;
    }

    public ScreenState getState() {
        return this.state;
    }

    public boolean hasAnyTextBoxFoxused() {
        return this.saveText.isFocused() || this.searchWidget.isFocused();
    }

    public static enum ScreenState {
        IDLE,
        SAVING,
        BROWSING;

    }

    public class StampEntry {
        public DualGUIElement favorite;
        public GUIElementButton delete;
        public StampEntryWidget self;
        public boolean addedWidgets = false;

        public void addAllWidgets() {
            StampBagScreen.this.addWidget((AbstractWidget)this.favorite);
            StampBagScreen.this.addWidget((AbstractWidget)this.delete);
            StampBagScreen.this.addWidget(this.self);
        }
    }
}

