/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.stamp_bag;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.util.GsonHelper;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.platform.MapWrightServices;

public class StampBagHandler {
    public static final Codec<MetaDataRecord> META_DATA_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.list(StampInformation.CODEC).fieldOf("translatables").forGetter(MetaDataRecord::allStamps)).apply((Applicative)i, translatable -> new MetaDataRecord(new ArrayList<StampInformation>((Collection<StampInformation>)translatable), new ArrayList<StampInformation>())));
    private Path stampPath;
    private Path metaDataPath;
    private SavingState state = SavingState.NORMAL;
    private MetaDataRecord metadataObject;
    public StampInformation temporaryStampInformation = new StampInformation("placeholder.png", "placeholder", false);
    private Future<MetaDataRecord> loadingRecordThread;
    private Future<?> savingRecordThread;
    private final List<Future<?>> stampThreads = new ArrayList();
    private boolean dirty = false;
    private boolean metaDataLoadingRequested = false;

    public StampBagHandler() {
        if (!MapWrightServices.PLATFORM.isRunningDatagen()) {
            this.createStampDirectory();
        }
    }

    private void createStampDirectory() {
        Path mainPath = Minecraft.getInstance().gameDirectory.toPath().resolve("mapwright_maps");
        this.stampPath = mainPath.resolve("stamps");
        this.metaDataPath = this.stampPath.resolve("metadata.json");
        if (Files.notExists(this.stampPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.stampPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                MapwrightClient.LOGGER.error("Could not create stamp directory\n{}", (Object)String.valueOf(e));
            }
        }
        if (Files.notExists(this.metaDataPath, new LinkOption[0])) {
            this.metadataObject = new MetaDataRecord(new ArrayList<StampInformation>(), new ArrayList<StampInformation>());
            this.dirty = true;
        } else {
            this.metaDataLoadingRequested = true;
        }
    }

    public void tick() {
        this.switchStates();
        this.state.stateManager.accept(this);
        if (this.metadataObject != null) {
            this.metadataObject.allStamps.forEach(si -> si.getTextureManager().tick());
        }
    }

    private void switchStates() {
        if (this.state == SavingState.NORMAL) {
            if (!this.stampThreads.isEmpty()) {
                this.state = SavingState.LOADING_IMAGES;
                return;
            }
            if (this.dirty) {
                this.state = SavingState.SAVING;
                return;
            }
            if (this.metaDataLoadingRequested) {
                this.state = SavingState.LOADING;
            }
        }
    }

    public void addNewStamp(NativeImage newStamp, String desiredName) {
        String adjustedName = StampBagHandler.slug(desiredName);
        adjustedName = StampBagHandler.findFirstValidFilename(adjustedName, this.stampPath, "png");
        MapwrightClient.LOGGER.debug("Saving new stamp image: {}; adjusted to:{}", (Object)desiredName, (Object)adjustedName);
        Path imagePath = this.stampPath.resolve(adjustedName);
        this.metadataObject.allStamps.add(new StampInformation(adjustedName, desiredName, false, newStamp));
        this.dirty = true;
        Util.ioPool().execute(() -> {
            try {
                newStamp.writeToFile(imagePath);
            }
            catch (IOException e) {
                MapwrightClient.LOGGER.error("Could not save stamp image\n{}", (Object)String.valueOf(e));
            }
        });
    }

    private static String findFirstValidFilename(String name, Path folderPath, String extension) {
        String filename;
        Path filepath;
        int index = 0;
        do {
            filename = StampBagHandler.slug(name) + (String)(index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(filepath = folderPath.resolve(filename), new LinkOption[0]));
        return filename;
    }

    private static String slug(String name) {
        return name.replaceAll("\\W+", "_");
    }

    private Future<MetaDataRecord> loadStableMetaData() {
        if (this.state == SavingState.LOADING) {
            return Util.ioPool().submit(() -> {
                MapwrightClient.LOGGER.info("attempting to load stamps");
                MetaDataRecord loadedRecord = null;
                try {
                    DataResult md = META_DATA_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)MapwrightClient.MAPWRIGHT_GSON.newJsonReader((Reader)Files.newBufferedReader(this.metaDataPath))));
                    if (md.isError()) {
                        MapwrightClient.LOGGER.error("Malformed metadata file! {}", (Object)md.error());
                        return null;
                    }
                    loadedRecord = (MetaDataRecord)md.getOrThrow();
                }
                catch (IOException e) {
                    MapwrightClient.LOGGER.error("Unable to read metadata file: {}", (Object)e.toString());
                }
                return loadedRecord;
            });
        }
        return null;
    }

    private Future<?> saveStableMetaData(MetaDataRecord record) {
        if (this.state == SavingState.SAVING) {
            return Util.ioPool().submit(() -> {
                MapwrightClient.LOGGER.info("attempting to save stamps");
                try {
                    JsonElement ele = (JsonElement)META_DATA_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)record).getOrThrow();
                    JsonWriter jwriter = MapwrightClient.MAPWRIGHT_GSON.newJsonWriter((Writer)Files.newBufferedWriter(this.metaDataPath, new OpenOption[0]));
                    jwriter.setSerializeNulls(false);
                    jwriter.setIndent(" ".repeat(Math.max(0, 2)));
                    GsonHelper.writeValue((JsonWriter)jwriter, (JsonElement)ele, null);
                    jwriter.close();
                }
                catch (IOException e) {
                    MapwrightClient.LOGGER.error("Unable to write metadata file: {}", (Object)e.toString());
                }
            });
        }
        return null;
    }

    public void requestAllStamps(Collection<StampInformation> collection, boolean favoritesOnly) {
        collection.addAll(this.getCorrectStampCollection(favoritesOnly));
        this.filterAndLoadStampsFromDisk(collection);
    }

    public void requestStampContaining(Collection<StampInformation> collection, String searchParam, boolean favoritesOnly) {
        for (StampInformation si : this.getCorrectStampCollection(favoritesOnly)) {
            if (!si.getCustomName().toLowerCase().contains(searchParam.toLowerCase())) continue;
            collection.add(si);
        }
        this.filterAndLoadStampsFromDisk(collection);
    }

    public void bulkRequestStamps(Collection<StampInformation> collection, boolean favoritesOnly, int ... indices) {
        List<StampInformation> stampCollection = this.getCorrectStampCollection(favoritesOnly);
        for (StampInformation si : stampCollection) {
            for (int i : indices) {
                if (stampCollection.indexOf(si) != i) continue;
                collection.add(si);
            }
        }
        this.filterAndLoadStampsFromDisk(collection);
    }

    private List<StampInformation> getCorrectStampCollection(boolean favoritesOnly) {
        List<StampInformation> stampCollection;
        if (favoritesOnly) {
            this.metadataObject.bulkUpdateFavorites();
            stampCollection = this.metadataObject.favorites();
        } else {
            stampCollection = this.metadataObject.allStamps();
        }
        return stampCollection;
    }

    private void filterAndLoadStampsFromDisk(Collection<StampInformation> collection) {
        for (StampInformation si : collection) {
            if (si.getTextureManager().getTexture() != null) continue;
            this.loadStampImage(si);
        }
    }

    private void loadStampImage(StampInformation si) {
        this.stampThreads.add(Util.ioPool().submit(() -> {
            Path stampPath = this.stampPath.resolve(si.getFileName());
            try {
                MapwrightClient.LOGGER.info("attempting to load stamp image for: {}", (Object)si.getFileName());
                InputStream inputStream = Files.newInputStream(stampPath, new OpenOption[0]);
                NativeImage image = NativeImage.read((InputStream)inputStream);
                si.setStampTexture(image);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public int getTotalEntryCount() {
        return this.getTotalEntryCount(false);
    }

    public int getTotalEntryCount(boolean favoritesOnly) {
        if (favoritesOnly) {
            int favoriteCount = 0;
            for (StampInformation allStamp : this.metadataObject.allStamps()) {
                if (!allStamp.isFavorited()) continue;
                ++favoriteCount;
            }
            return favoriteCount;
        }
        return this.metadataObject.allStamps().size();
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void removeStamp(StampInformation si) {
        si.setRemoved();
        this.metadataObject.allStamps().remove(si);
        this.setDirty();
    }

    private static enum SavingState {
        NORMAL(null),
        SAVING(sbh -> {
            if (!sbh.dirty) {
                sbh.state = NORMAL;
                return;
            }
            if (sbh.savingRecordThread == null) {
                sbh.savingRecordThread = sbh.saveStableMetaData(sbh.metadataObject);
            }
            if (sbh.savingRecordThread != null && sbh.savingRecordThread.isDone()) {
                sbh.state = NORMAL;
                sbh.dirty = false;
                sbh.savingRecordThread = null;
            }
        }),
        LOADING(sbh -> {
            if (!sbh.metaDataLoadingRequested) {
                sbh.state = NORMAL;
                return;
            }
            if (sbh.loadingRecordThread == null) {
                sbh.loadingRecordThread = sbh.loadStableMetaData();
            }
            if (sbh.loadingRecordThread != null && sbh.loadingRecordThread.isDone()) {
                sbh.state = NORMAL;
                sbh.metaDataLoadingRequested = false;
                try {
                    sbh.metadataObject = sbh.loadingRecordThread.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    MapwrightClient.LOGGER.error("Unable to successfully load MetaData! {}", (Object)e.toString());
                }
                sbh.loadingRecordThread = null;
            }
        }),
        LOADING_IMAGES(sbh -> {
            sbh.stampThreads.removeIf(Future::isDone);
            if (sbh.stampThreads.isEmpty()) {
                sbh.state = NORMAL;
            }
        });

        private final Consumer<StampBagHandler> stateManager;

        private SavingState(Consumer<StampBagHandler> handler) {
            this.stateManager = Objects.requireNonNullElseGet(handler, () -> sbh -> {});
        }
    }

    public record MetaDataRecord(List<StampInformation> allStamps, List<StampInformation> favorites) {
        public void bulkUpdateFavorites() {
            this.favorites.clear();
            for (StampInformation si : this.allStamps) {
                if (!si.isFavorited()) continue;
                this.favorites.add(si);
            }
        }
    }
}

