/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.stamp_bag.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.gui.GUIElementAtlases;
import wawa.mapwright.map.MapScreen;
import wawa.mapwright.map.StampBagScreen;
import wawa.mapwright.map.tool.CopyTool;
import wawa.mapwright.map.tool.StampTool;
import wawa.mapwright.map.tool.Tool;

public class StampBagWidget
extends AbstractWidget {
    private final MapScreen mapScreen;

    public StampBagWidget(int x, int y, MapScreen screen) {
        super(x, y, 16, 16, (Component)Component.literal((String)"Stamp Bag"));
        this.mapScreen = screen;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.mapScreen.toolPicker.getImageFromScissorTool() != null & MapwrightClient.TOOL_MANAGER.get() instanceof CopyTool || StampBagScreen.INSTANCE.getState() != StampBagScreen.ScreenState.IDLE) {
            GUIElementAtlases.STAMP_BAG_OPEN.render(guiGraphics, this.getX(), this.getY());
            if (this.isHovered) {
                GUIElementAtlases.STAMP_BAG_OPEN_HIGHLIGHT.render(guiGraphics, this.getX() - 1, this.getY() - 1);
            }
        } else {
            GUIElementAtlases.STAMP_BAG_CLOSED.render(guiGraphics, this.getX(), this.getY());
            if (this.isHovered) {
                GUIElementAtlases.STAMP_BAG_CLOSED_HIGHLIGHT.render(guiGraphics, this.getX() - 1, this.getY() - 1);
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"mapwright.tool.stamp"), mouseX, mouseY);
            }
        }
    }

    public void onClick(double mouseX, double mouseY) {
        StampTool st;
        super.onClick(mouseX, mouseY);
        StampBagScreen ss = this.mapScreen.stampScreen;
        if (ss.getState() != StampBagScreen.ScreenState.IDLE) {
            ss.changeStage(StampBagScreen.ScreenState.IDLE);
            return;
        }
        Tool tool = MapwrightClient.TOOL_MANAGER.get();
        if (tool instanceof StampTool && (st = (StampTool)tool).isTempStamp()) {
            ss.changeStage(StampBagScreen.ScreenState.SAVING);
        } else {
            ss.changeStage(StampBagScreen.ScreenState.BROWSING);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

