/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.stamp_bag.widgets;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.gui.GUIElementAtlases;
import wawa.mapwright.map.StampBagScreen;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.map.stamp_bag.StampTexture;
import wawa.mapwright.map.stamp_bag.widgets.abstract_classes.AbstractStampScreenWidget;
import wawa.mapwright.map.tool.StampBagDebuggerTool;
import wawa.mapwright.map.tool.StampTool;

public class StampEntryWidget
extends AbstractStampScreenWidget {
    @Nullable
    public StampInformation stampInformation;
    private final Consumer<StampEntryWidget> onClick;
    private final ResourceLocation id;
    private boolean registered = false;

    public StampEntryWidget(int x, int y, StampBagScreen parentScreen, Consumer<StampEntryWidget> onclick, ResourceLocation loc) {
        super(x, y, GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width(), GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.height(), parentScreen);
        this.onClick = onclick;
        this.id = loc;
    }

    public void changeStampInformation(StampInformation newInfo) {
        this.registered = false;
        Minecraft.getInstance().getTextureManager().release(this.id);
        this.stampInformation = newInfo;
    }

    public void onClick(double mouseX, double mouseY) {
        this.onClick.accept(this);
        MapwrightClient.TOOL_MANAGER.set(StampTool.INSTANCE);
        StampTool.INSTANCE.setActiveStamp(this.stampInformation);
        StampBagScreen.INSTANCE.changeStage(StampBagScreen.ScreenState.IDLE);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mx, int my, float v) {
        if (this.stampInformation == null) {
            return;
        }
        StampTexture manager = this.stampInformation.getTextureManager();
        NativeImage tex = manager.getTexture();
        if (tex == null) {
            return;
        }
        if (!this.registered) {
            this.registered = true;
            Minecraft.getInstance().getTextureManager().register(this.id, (AbstractTexture)manager);
        }
        PoseStack ps = guiGraphics.pose();
        ps.pushPose();
        RenderType renderType = VeilRenderType.get((ResourceLocation)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{this.id});
        if (renderType == null) {
            return;
        }
        ps.pushPose();
        ps.translate((float)(this.getX() + 1), (float)(this.getY() + 1), 0.0f);
        float scale = Math.min(56.0f / (float)tex.getWidth() / 2.0f, 56.0f / (float)tex.getHeight() / 2.0f);
        ps.scale(scale, scale, 1.0f);
        Rendering.renderTypeBlit(guiGraphics, renderType, 4.1, 4.0, 0, 0.0f, 0.0f, manager.getTexture().getWidth(), manager.getTexture().getHeight(), manager.getTexture().getWidth(), manager.getTexture().getHeight(), 1.0f);
        ps.popPose();
        ps.pushPose();
        guiGraphics.enableScissor(this.getX() + 36, this.getY() + 5, this.getX() + 123, this.getY() + 27);
        ps.translate((float)(this.getX() + 38), (float)(this.getY() + 8), 0.0f);
        if (Minecraft.getInstance().font.width(this.stampInformation.getCustomName()) < 85) {
            ps.translate(0.0f, 4.0f, 0.0f);
        }
        ps.scale(1.05f, 1.05f, 1.0f);
        guiGraphics.drawWordWrap(Minecraft.getInstance().font, FormattedText.of((String)this.stampInformation.getCustomName()), 0, 0, 85, Color.WHITE.getRGB());
        guiGraphics.disableScissor();
        ps.popPose();
        if (this.isHovered()) {
            ps.translate(0.0f, 0.0f, 10.0f);
            int tx = mx - tex.getWidth() - 16;
            int ty = my - tex.getHeight() / 2;
            guiGraphics.blitSprite(StampBagDebuggerTool.backgroundID, tx - 5, ty - 5, tex.getWidth() + 10, tex.getHeight() + 10);
            Rendering.renderTypeBlit(guiGraphics, renderType, (double)tx, (double)ty, 0, 0.0f, 0.0f, manager.getTexture().getWidth(), manager.getTexture().getHeight(), manager.getTexture().getWidth(), manager.getTexture().getHeight(), 1.0f);
        }
        ps.popPose();
    }
}

