/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.tool;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.PageManager;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.map.stamp_bag.StampTexture;
import wawa.mapwright.map.tool.Tool;

public class StampBagDebuggerTool
extends Tool {
    private final List<InfoAndID> idList = new ArrayList<InfoAndID>();
    private int pointer;
    public static final ResourceLocation backgroundID = MapwrightClient.id("stamp_browser_background");

    @Override
    public void onSelect() {
        ArrayList<StampInformation> collection = new ArrayList<StampInformation>();
        MapwrightClient.STAMP_HANDLER.requestAllStamps(collection, false);
        for (int i = 0; i < collection.size(); ++i) {
            StampInformation si = collection.get(i);
            si.getTextureManager().addUser();
            this.idList.add(new InfoAndID(MapwrightClient.id("stamp_debugger_" + i), si, new AtomicBoolean()));
        }
    }

    @Override
    public void onDeselect() {
        for (InfoAndID id : this.idList) {
            Minecraft.getInstance().getTextureManager().release(id.id);
            id.info.getTextureManager().removeUser();
            id.textureRegistered.set(false);
        }
        this.idList.clear();
        this.pointer = 0;
    }

    @Override
    public void controlScroll(PageManager activePage, double mouseX, double mouseY, double scrollY) {
        this.pointer += (int)scrollY;
        this.pointer = Mth.clamp((int)this.pointer, (int)0, (int)(this.idList.size() - 1));
    }

    @Override
    public void renderWorld(GuiGraphics graphics, int worldX, int worldY, double xOff, double yOff) {
        if (!this.idList.isEmpty()) {
            RenderType renderType;
            InfoAndID infoAndID = this.idList.get(this.pointer);
            NativeImage texture = infoAndID.info.getTextureManager().getTexture();
            if (texture == null) {
                return;
            }
            if (!infoAndID.textureRegistered.get()) {
                infoAndID.textureRegistered.set(true);
                Minecraft.getInstance().getTextureManager().register(infoAndID.id, (AbstractTexture)infoAndID.info().getTextureManager());
            }
            if ((renderType = VeilRenderType.get((ResourceLocation)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{infoAndID.id})) == null) {
                return;
            }
            StampTexture renderable = infoAndID.info.getTextureManager();
            double x = (double)worldX + xOff - (double)(renderable.getTexture().getWidth() / 2);
            double y = (double)worldY + yOff - (double)(renderable.getTexture().getHeight() / 2);
            PoseStack ps = graphics.pose();
            ps.pushPose();
            ps.translate(x, y, 0.0);
            graphics.blitSprite(backgroundID, -2, -32, Math.max(renderable.getTexture().getWidth() + 4, 98), renderable.getTexture().getHeight() + 34);
            Rendering.renderTypeBlit(graphics, renderType, 0.0, 0.0, 0, 0.0f, 0.0f, renderable.getTexture().getWidth(), renderable.getTexture().getHeight(), renderable.getTexture().getWidth(), renderable.getTexture().getHeight(), 1.0f);
            graphics.drawString(Minecraft.getInstance().font, infoAndID.info.getCustomName(), 0, -4, Color.GREEN.getRGB());
            graphics.drawString(Minecraft.getInstance().font, infoAndID.info.getFileName(), 0, -16, Color.GREEN.getRGB());
            graphics.drawString(Minecraft.getInstance().font, "is favorited: " + infoAndID.info.isFavorited(), 0, -26, Color.GREEN.getRGB());
            ps.popPose();
        }
    }

    public record InfoAndID(ResourceLocation id, StampInformation info, AtomicBoolean textureRegistered) {
    }
}

