/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.widgets;

import com.mojang.blaze3d.platform.NativeImage;
import foundry.veil.api.client.color.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.map.tool.PaletteDrawTool;
import wawa.mapwright.map.widgets.SingleToolWidget;

public class ColorPickerWidget
extends AbstractWidget {
    public static final int COLOR_COUNT = 12;
    private final List<PaletteSwabWidget> swabs = new ArrayList<PaletteSwabWidget>();
    private final SingleToolWidget.BrushWidget brushWidget;
    private final int defaultX;
    private final int defaultY;

    public ColorPickerWidget(int rightAnchor, int centerY, SingleToolWidget.BrushWidget brushWidget) {
        super(rightAnchor, centerY, 0, 0, (Component)Component.literal((String)"color picker"));
        this.brushWidget = brushWidget;
        NativeImage texture = Rendering.getPaletteTexture();
        int colorCount = Math.min(12, texture.getWidth());
        for (int i = 0; i < colorCount; ++i) {
            float n = (float)(i + 1) / 13.0f;
            Color color = new Color(n, n, n);
            int pixelRGBA = texture.getPixelRGBA(i + 1, 0);
            Color trueColor = new Color(Integer.reverseBytes(pixelRGBA) >> 8);
            int columns = 4;
            int sx = i % 4 * 10;
            int sy = i / 4 * 10;
            this.width = Math.max(this.width, sx + 8);
            this.height = Math.max(this.height, sy + 8);
            this.swabs.add(new PaletteSwabWidget(this, sx, sy, color.argb(), trueColor.argb()));
        }
        this.defaultX = rightAnchor - this.width - 4;
        this.defaultY = centerY - this.height / 2 + 8;
        this.setX(this.defaultX);
        this.setY(this.defaultY);
        brushWidget.last = this.swabs.getFirst().tool;
    }

    public void openToMouse(double mouseX, double mouseY) {
        this.active = true;
        this.setX((int)(mouseX - (double)(this.width / 2)));
        this.setY((int)(mouseY - (double)(this.height / 2)));
    }

    public void resetPos() {
        this.setX(this.defaultX);
        this.setY(this.defaultY);
    }

    public List<PaletteDrawTool> getBrushes() {
        return this.swabs.stream().map(swab -> swab.tool).collect(Collectors.toList());
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int padding = 10;
        return this.isActive() && (mouseX >= (double)this.getX() - 10.0 && mouseY >= (double)this.getY() - 10.0 && mouseX < (double)(this.getX() + this.width + 10) && mouseY < (double)(this.getY() + this.height + 10) || this.swabs.stream().anyMatch(swab -> swab.isMouseOver(mouseX, mouseY)));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (PaletteSwabWidget swab : this.swabs) {
            if (!swab.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return this.isMouseOver(mouseX, mouseY);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (int)0);
        for (PaletteSwabWidget swab : this.swabs) {
            swab.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static class PaletteSwabWidget
    extends AbstractWidget {
        private final ColorPickerWidget parent;
        private final int relX;
        private final int relY;
        public final int color;
        public final int visualColor;
        public final PaletteDrawTool tool;

        public PaletteSwabWidget(ColorPickerWidget parent, int x, int y, int color, int visualColor) {
            super(0, 0, 8, 8, (Component)Component.literal((String)"color swab"));
            this.parent = parent;
            this.relX = x;
            this.relY = y;
            this.color = color;
            this.visualColor = visualColor;
            this.tool = new PaletteDrawTool(MapwrightClient.id("tool/brush/brush_cursor"), this.getABGR(), this.visualColor, parent.brushWidget);
        }

        public int getX() {
            return this.parent.getX() + this.relX;
        }

        public int getY() {
            return this.parent.getY() + this.relY;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.isMouseOver(mouseX, mouseY)) {
                guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getRight() + 1, this.getBottom() + 1, -1);
                guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), -16777216);
                guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getRight() - 1, this.getBottom() - 1, this.visualColor);
            } else {
                guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), this.visualColor);
            }
        }

        public void onClick(double mouseX, double mouseY) {
            MapwrightClient.TOOL_MANAGER.set(this.tool);
            this.parent.brushWidget.last = this.tool;
        }

        public int getABGR() {
            int B = this.color & 0xFF;
            int G = this.color >> 8 & 0xFF;
            int R = this.color >> 16 & 0xFF;
            int A = this.color >> 24 & 0xFF;
            return A << 24 | B << 16 | G << 8 | R;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

