/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.Pin;
import wawa.mapwright.data.SpyglassPins;
import wawa.mapwright.map.MapScreen;
import wawa.mapwright.map.background.MapBackground;
import wawa.mapwright.map.tool.PanTool;
import wawa.mapwright.map.tool.PinTool;
import wawa.mapwright.map.tool.Tool;

public class MapWidget
extends AbstractWidget {
    private static final int OUTER_PADDING = 30;
    private static final int TOP_MARGIN = 40;
    private static final int LEFT_MARGIN = 96;
    private static final int RIGHT_MARGIN = 96;
    private static final int BOTTOM_MARGIN = 40;
    private static final int TOP_SCISSOR = 20;
    private static final int LEFT_SCISSOR = 50;
    private static final int RIGHT_SCISSOR = 20;
    private static final int BOTTOM_SCISSOR = 20;
    private final MapScreen parent;
    private final MapBackground background;
    public MouseType mouseType = MouseType.NONE;
    public double oldMouseX;
    public double oldMouseY;

    public MapWidget(MapScreen parent) {
        super(30, 30, parent.width - 60, parent.height - 60, (Component)Component.literal((String)"Map Display"));
        this.background = new MapBackground(this.width, this.height, 40, 96, 96, 40);
        this.setWidth(this.background.getTrueWidth() + 96 + 96);
        this.setHeight(this.background.getTrueHeight() + 40 + 40);
        this.setX((parent.width - this.width) / 2);
        this.setY((parent.height - this.height) / 2);
        this.parent = parent;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Vector2d panning = this.parent.lerpedPanning.get();
        float scale = this.parent.getScale();
        this.background.render(guiGraphics, this.getX(), this.getY(), this.width, this.height, (Vector2dc)this.parent.backgroundPanning, -1);
        guiGraphics.pose().pushPose();
        double hw = (double)this.width / 2.0;
        double hh = (double)this.height / 2.0;
        guiGraphics.pose().translate((double)this.getX() + hw, (double)this.getY() + hh, 0.0);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        double xOff = -panning.x;
        double yOff = -panning.y;
        guiGraphics.enableScissor(this.getX() + 50, this.getY() + 20, this.getRight() - 20, this.getBottom() - 20);
        Vector2d topLeftWorld = this.parent.screenToWorld(new Vector2d((double)this.getX(), (double)this.getY()));
        Vector2d bottomRightWorld = this.parent.screenToWorld(new Vector2d((double)this.getRight(), (double)this.getBottom()));
        Vector2i topLeft = new Vector2i(topLeftWorld.x / 512.0, topLeftWorld.y / 512.0, 2);
        Vector2i bottomRight = new Vector2i(bottomRightWorld.x / 512.0, bottomRightWorld.y / 512.0, 1);
        for (int x = topLeft.x; x < bottomRight.x; ++x) {
            for (int y = topLeft.y; y < bottomRight.y; ++y) {
                MapwrightClient.PAGE_MANAGER.getOrCreatePage(x, y).render(guiGraphics, xOff, yOff);
            }
        }
        Vec2 mouse = Helper.preciseMousePos();
        Vector2d world = this.parent.screenToWorld(new Vector2d((double)mouse.x, (double)mouse.y));
        MapwrightClient.TOOL_MANAGER.get().renderWorld(guiGraphics, Mth.floor((double)world.x), Mth.floor((double)world.y), xOff, yOff);
        guiGraphics.disableScissor();
        guiGraphics.pose().popPose();
        Vector2d mouseScreen = new Vector2d((double)(mouseX - this.getX()) - hw, (double)(mouseY - this.getY()) - hh);
        Vector4d transformedScreenBounds = new Vector4d(-hw + 50.0, -hh + 20.0, (double)this.width - hw - 20.0, (double)this.height - hh - 20.0);
        for (Pin pin : MapwrightClient.PAGE_MANAGER.getPins()) {
            boolean highlight = false;
            Tool tool = MapwrightClient.TOOL_MANAGER.get();
            if (tool instanceof PinTool) {
                PinTool pinTool = (PinTool)tool;
                highlight = pinTool.currentPin == pin.type;
            }
            pin.draw(guiGraphics, (Vector2dc)mouseScreen, xOff, yOff, scale, highlight, (Vector4dc)transformedScreenBounds);
        }
        for (SpyglassPins.PinData pinData : MapwrightClient.PAGE_MANAGER.getSpyglassPins().getPins()) {
            pinData.pin().draw(guiGraphics, (Vector2dc)mouseScreen, xOff, yOff, scale, false, (Vector4dc)transformedScreenBounds);
        }
        Vec3 playerPos = Minecraft.getInstance().player.position();
        Rendering.renderHead(guiGraphics, (Vector2dc)new Vector2d(playerPos.x, playerPos.z), (Vector2dc)mouseScreen, xOff, yOff, scale, (Vector4dc)transformedScreenBounds);
        guiGraphics.pose().popPose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (Screen.hasControlDown()) {
            MapwrightClient.TOOL_MANAGER.get().controlScroll(MapwrightClient.PAGE_MANAGER, mouseX, mouseY, scrollY);
        } else {
            this.parent.deltaZoom((int)scrollY);
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.oldMouseX = mouseX;
            this.oldMouseY = mouseY;
            MouseType newType = switch (button) {
                case 0 -> MouseType.LEFT;
                case 1 -> MouseType.RIGHT;
                case 2 -> MouseType.MIDDLE;
                default -> MouseType.NONE;
            };
            Vector2d world = this.parent.screenToWorld(new Vector2d(mouseX, mouseY));
            if (newType != this.mouseType && this.mouseType != MouseType.NONE) {
                MapwrightClient.TOOL_MANAGER.get().mouseRelease(MapwrightClient.PAGE_MANAGER, this.mouseType, world);
            }
            this.mouseType = newType;
            if (Screen.hasControlDown()) {
                int color = MapwrightClient.PAGE_MANAGER.getPixelARGB(Mth.floor((double)world.x), Mth.floor((double)world.y));
                this.parent.toolPicker.pickColor(color);
            } else if (this.mouseType == MouseType.LEFT || this.mouseType == MouseType.RIGHT) {
                MapwrightClient.TOOL_MANAGER.get().mouseDown(MapwrightClient.PAGE_MANAGER, this.mouseType, world);
                MapwrightClient.TOOL_MANAGER.get().mouseMove(MapwrightClient.PAGE_MANAGER, this.mouseType, (Vector2dc)world, (Vector2dc)world);
            }
            return true;
        }
        return false;
    }

    private boolean shouldPan() {
        if (this.mouseType == MouseType.MIDDLE) {
            return true;
        }
        if (this.mouseType == MouseType.LEFT || this.mouseType == MouseType.RIGHT) {
            return Screen.hasControlDown() || MapwrightClient.TOOL_MANAGER.get() instanceof PanTool;
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        Vector2d world = this.parent.screenToWorld(new Vector2d(mouseX, mouseY));
        Vector2d oldWorld = this.parent.screenToWorld(new Vector2d(this.oldMouseX, this.oldMouseY));
        if (this.shouldPan()) {
            this.parent.lerpedPanning.set(this.parent.lerpedPanning.get().add((Vector2dc)oldWorld).sub((Vector2dc)world));
            this.parent.backgroundPanning.add(this.oldMouseX, this.oldMouseY).sub(mouseX, mouseY);
        } else {
            if (!this.isMouseOver(mouseX, mouseY)) {
                this.mouseType = MouseType.NONE;
                return;
            }
            if (!Screen.hasAltDown() && !Screen.hasControlDown()) {
                MapwrightClient.TOOL_MANAGER.get().mouseMove(MapwrightClient.PAGE_MANAGER, this.mouseType, (Vector2dc)oldWorld, (Vector2dc)world);
            }
        }
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Vector2d world = this.parent.screenToWorld(new Vector2d(mouseX, mouseY));
        if (this.mouseType != MouseType.NONE) {
            MapwrightClient.TOOL_MANAGER.get().mouseRelease(MapwrightClient.PAGE_MANAGER, this.mouseType, world);
        }
        this.mouseType = MouseType.NONE;
        return true;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static enum MouseType {
        NONE,
        LEFT,
        RIGHT,
        MIDDLE;

    }
}

