/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.widgets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.data.Pin;
import wawa.mapwright.map.tool.PinTool;
import wawa.mapwright.map.widgets.SingleToolWidget;

public class PinPickerWidget
extends AbstractWidget {
    private final SingleToolWidget.PinWidget pinWidget;
    private final int defaultX;
    private final int defaultY;
    private final List<PinSwabWidget> swabs = new ArrayList<PinSwabWidget>();

    public PinPickerWidget(int rightAnchor, int centerY, SingleToolWidget.PinWidget pinWidget) {
        super(rightAnchor, centerY, 0, 16, (Component)Component.literal((String)"pin picker"));
        this.pinWidget = pinWidget;
        Pin.getTypes().forEach(pinType -> {
            this.width += 16;
            this.swabs.add(new PinSwabWidget(this, this.width - 16, 0, (Pin.Type)pinType));
        });
        this.defaultX = rightAnchor - this.width - 4;
        this.defaultY = centerY - this.height / 2 + 8;
        this.setX(this.defaultX);
        this.setY(this.defaultY);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (int)0);
        for (PinSwabWidget swab : this.swabs) {
            swab.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int padding = 10;
        return this.isActive() && (mouseX >= (double)this.getX() - 10.0 && mouseY >= (double)this.getY() - 10.0 && mouseX < (double)(this.getX() + this.width + 10) && mouseY < (double)(this.getY() + this.height + 10) || this.swabs.stream().anyMatch(swab -> swab.isMouseOver(mouseX, mouseY)));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (PinSwabWidget swab : this.swabs) {
            if (!swab.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public static class PinSwabWidget
    extends AbstractWidget {
        private final PinPickerWidget parent;
        private final int relX;
        private final int relY;
        private final Pin.Type type;

        public PinSwabWidget(PinPickerWidget parent, int x, int y, Pin.Type type) {
            super(x, y, 16, 16, (Component)Component.literal((String)"pin swab"));
            this.parent = parent;
            this.relX = x;
            this.relY = y;
            this.type = type;
        }

        public int getX() {
            return this.parent.getX() + this.relX;
        }

        public int getY() {
            return this.parent.getY() + this.relY;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.type.draw(guiGraphics, this.getX(), this.getY(), this.isMouseOver(mouseX, mouseY), false, 1.0f);
        }

        public void onClick(double mouseX, double mouseY) {
            PinTool tool = this.parent.pinWidget.getTool();
            this.parent.pinWidget.last = this.type;
            tool.setPinType(this.type);
            MapwrightClient.TOOL_MANAGER.set(tool);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

