/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.widgets;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.data.Pin;
import wawa.mapwright.map.tool.PaletteDrawTool;
import wawa.mapwright.map.tool.PinTool;
import wawa.mapwright.map.tool.Tool;
import wawa.mapwright.map.widgets.ColorPickerWidget;
import wawa.mapwright.map.widgets.PinPickerWidget;

public class SingleToolWidget
extends AbstractWidget {
    private final ResourceLocation sprite;
    private final ResourceLocation highlight;
    protected final Function<SingleToolWidget, Tool> toolFunction;
    protected String id = "";

    public SingleToolWidget(int x, int y, ResourceLocation sprite, ResourceLocation highlight, Function<SingleToolWidget, Tool> toolFunction, Component message) {
        super(x, y, 16, 16, message);
        this.sprite = sprite;
        this.highlight = highlight;
        this.toolFunction = toolFunction;
        if (sprite != null) {
            this.id = "mapwright.tool." + Arrays.stream(sprite.getPath().split("/")).toList().get(sprite.getPath().split("/").length - 1);
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isMouseOver(mouseX, mouseY)) {
            guiGraphics.blitSprite(this.highlight, this.getX() - 1, this.getY() - 1, 18, 18);
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        guiGraphics.blitSprite(this.sprite, this.getX(), this.getY(), 16, 16);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)this.id), mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            MapwrightClient.TOOL_MANAGER.set(this.toolFunction.apply(this));
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static class PinWidget
    extends SingleToolWidget {
        public Pin.Type last;
        private final PinPickerWidget pinPicker;

        public PinWidget(int x, int y, Function<SingleToolWidget, Tool> toolFunction, Component message) {
            super(x, y, null, null, toolFunction, message);
            this.last = this.getTool().currentPin;
            this.pinPicker = new PinPickerWidget(this.getX() - 5, this.getY(), this);
            this.pinPicker.active = false;
            this.id = "mapwright.tool.pin";
        }

        public PinTool getTool() {
            return (PinTool)this.toolFunction.apply(this);
        }

        @Override
        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.last.draw(guiGraphics, this.getX(), this.getY(), this.isMouseOver(mouseX, mouseY), false, 1.0f);
            if (this.isMouseOver(mouseX, mouseY)) {
                this.pinPicker.active = true;
                this.pinPicker.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                this.renderTooltip(guiGraphics, mouseX, mouseY);
            } else {
                this.pinPicker.active = false;
            }
        }

        @Override
        protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            mouseX = this.pinPicker.getX() - Minecraft.getInstance().font.width((FormattedText)Component.translatable((String)this.id)) - 24;
            super.renderTooltip(guiGraphics, mouseX, mouseY);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return super.isMouseOver(mouseX, mouseY) || this.pinPicker.isMouseOver(mouseX, mouseY) && this.pinPicker.isActive();
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.pinPicker.isActive()) {
                return false;
            }
            if (!super.mouseClicked(mouseX, mouseY, button)) {
                return this.pinPicker.mouseClicked(mouseX, mouseY, button);
            }
            return false;
        }
    }

    public static class BrushWidget
    extends SingleToolWidget {
        public PaletteDrawTool last;
        private static final TextureAtlasSprite mask = Minecraft.getInstance().getGuiSprites().getSprite(MapwrightClient.id("tool/brush/brush_mask"));
        private final ColorPickerWidget colorPicker = new ColorPickerWidget(this.getX() - 5, this.getY(), this);
        private boolean atMouse = false;

        public BrushWidget(int x, int y) {
            super(x, y, MapwrightClient.id("tool/brush/brush"), MapwrightClient.id("tool/brush/brush_highlight"), w -> ((BrushWidget)w).last, (Component)Component.literal((String)"brush"));
            this.colorPicker.active = false;
        }

        public List<PaletteDrawTool> getBrushes() {
            return this.colorPicker.getBrushes();
        }

        public void openToMouse(double mouseX, double mouseY) {
            this.colorPicker.openToMouse(mouseX, mouseY);
            this.atMouse = true;
        }

        @Override
        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            float[] rgb = new Color(this.last.getVisualColor()).getRGBColorComponents(null);
            guiGraphics.blit(this.getX(), this.getY(), 0, 16, 16, mask, rgb[0], rgb[1], rgb[2], 1.0f);
            if (this.isMouseOver(mouseX, mouseY)) {
                this.colorPicker.active = true;
                this.colorPicker.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            } else {
                this.colorPicker.active = false;
                this.colorPicker.resetPos();
                this.atMouse = false;
            }
        }

        @Override
        protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (!this.atMouse) {
                mouseX = this.colorPicker.getX() - Minecraft.getInstance().font.width((FormattedText)Component.translatable((String)this.id)) - 24;
                super.renderTooltip(guiGraphics, mouseX, mouseY);
            }
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return super.isMouseOver(mouseX, mouseY) || this.colorPicker.isMouseOver(mouseX, mouseY) && this.colorPicker.isActive();
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.colorPicker.isActive()) {
                return false;
            }
            if (!super.mouseClicked(mouseX, mouseY, button)) {
                return this.colorPicker.mouseClicked(mouseX, mouseY, button);
            }
            return false;
        }
    }
}

