/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.neoforge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import wawa.mapwright.ClientEvents;
import wawa.mapwright.mixin.LevelRendererAccessor;

@EventBusSubscriber(modid="mapwright", value={Dist.CLIENT})
public class ClientEventsRuntime {
    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Post event) {
        ClientEvents.tick(Minecraft.getInstance());
    }

    @SubscribeEvent
    public static void levelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            ClientEvents.loadLevel((Level)level, Minecraft.getInstance());
        }
    }

    @SubscribeEvent
    public static void leaveServer(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientEvents.leaveServer();
    }

    @SubscribeEvent
    public static void postWorldRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            MultiBufferSource.BufferSource bufferSource = ((LevelRendererAccessor)event.getLevelRenderer()).getRenderBuffers().bufferSource();
            ClientEvents.postWorldRender((MultiBufferSource)bufferSource, event.getPoseStack(), event.getPartialTick().getRealtimeDeltaTicks());
        }
    }
}

