/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.neoforge.input;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.util.Lazy;
import wawa.mapwright.platform.services.IKeyMappings;

public class NeoKeyMappings
implements IKeyMappings {
    public static final Lazy<KeyMapping> OPEN_MAP = Lazy.of(() -> NeoKeyMappings.create("map", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 77));
    public static final Lazy<KeyMapping> UNDO = Lazy.of(() -> NeoKeyMappings.create("undo", KeyConflictContext.GUI, KeyModifier.CONTROL, 90));
    public static final Lazy<KeyMapping> REDO = Lazy.of(() -> NeoKeyMappings.create("redo", KeyConflictContext.GUI, KeyModifier.CONTROL, 89));
    public static final Lazy<KeyMapping> SWAP = Lazy.of(() -> NeoKeyMappings.create("swap", KeyConflictContext.GUI, KeyModifier.NONE, 88));
    public static final Lazy<KeyMapping> HAND = Lazy.of(() -> NeoKeyMappings.create("hand", KeyConflictContext.GUI, KeyModifier.NONE, 72));
    public static final Lazy<KeyMapping> PEN = Lazy.of(() -> NeoKeyMappings.create("pen", KeyConflictContext.GUI, KeyModifier.NONE, 78));
    public static final Lazy<KeyMapping> BRUSH = Lazy.of(() -> NeoKeyMappings.create("brush", KeyConflictContext.GUI, KeyModifier.NONE, 66));
    public static final Lazy<KeyMapping> ERASER = Lazy.of(() -> NeoKeyMappings.create("eraser", KeyConflictContext.GUI, KeyModifier.NONE, 69));

    private static KeyMapping create(String name, KeyConflictContext conflictContext, KeyModifier modifier, int keycode) {
        return new KeyMapping("key.mapwright." + name, (IKeyConflictContext)conflictContext, modifier, InputConstants.Type.KEYSYM, keycode, "key.categories.mapwright");
    }

    @Override
    public boolean consume(IKeyMappings.Normal bind) {
        Lazy<KeyMapping> mapping = switch (bind) {
            default -> throw new MatchException(null, null);
            case IKeyMappings.Normal.OPEN_MAP -> OPEN_MAP;
            case IKeyMappings.Normal.UNDO -> UNDO;
            case IKeyMappings.Normal.REDO -> REDO;
            case IKeyMappings.Normal.SWAP -> SWAP;
        };
        return ((KeyMapping)mapping.get()).consumeClick();
    }

    @Override
    public boolean matches(IKeyMappings.Normal bind, int keysym, int scancode, int modifier) {
        Lazy<KeyMapping> mapping = switch (bind) {
            default -> throw new MatchException(null, null);
            case IKeyMappings.Normal.OPEN_MAP -> OPEN_MAP;
            case IKeyMappings.Normal.UNDO -> UNDO;
            case IKeyMappings.Normal.REDO -> REDO;
            case IKeyMappings.Normal.SWAP -> SWAP;
        };
        return ((KeyMapping)mapping.get()).isActiveAndMatches(InputConstants.getKey((int)keysym, (int)scancode));
    }

    @Override
    public IKeyMappings.ToolSwap getToolSwap(int keysym, int scancode, int modifier) {
        InputConstants.Key key = InputConstants.getKey((int)keysym, (int)scancode);
        if (((KeyMapping)HAND.get()).isActiveAndMatches(key)) {
            return IKeyMappings.ToolSwap.HAND;
        }
        if (((KeyMapping)PEN.get()).isActiveAndMatches(key)) {
            return IKeyMappings.ToolSwap.PEN;
        }
        if (((KeyMapping)BRUSH.get()).isActiveAndMatches(key)) {
            return IKeyMappings.ToolSwap.BRUSH;
        }
        if (((KeyMapping)ERASER.get()).isActiveAndMatches(key)) {
            return IKeyMappings.ToolSwap.ERASER;
        }
        return null;
    }
}

