/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.minimaps;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.platform.Services;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelMap;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_418;
import xaero.common.HudMod;

public class CurrentMinimap {
    private static boolean minimapLoaded(Minimap minimap) {
        String modID = minimap.getModID();
        return Services.PLATFORM.isModLoaded(modID);
    }

    public static boolean xaeroLoaded() {
        return CurrentMinimap.minimapLoaded(Minimap.XAERO) || CurrentMinimap.minimapLoaded(Minimap.XAERO_FAIRPLAY);
    }

    public static boolean journeyMapLoaded() {
        return CurrentMinimap.minimapLoaded(Minimap.JOURNEYMAP);
    }

    public static boolean ftbChunksLoaded() {
        return CurrentMinimap.minimapLoaded(Minimap.FTB_CHUNKS);
    }

    public static boolean mapAtlasesLoaded() {
        return CurrentMinimap.minimapLoaded(Minimap.MAP_ATLASES);
    }

    private static List<Minimap> getLoadedMinimaps() {
        List<Minimap> values = Arrays.asList(Minimap.values());
        ArrayList<Minimap> loaded = new ArrayList<Minimap>();
        values.forEach(minimaps -> {
            if (CurrentMinimap.minimapLoaded(minimaps)) {
                loaded.add((Minimap)((Object)minimaps));
            }
        });
        return loaded;
    }

    public static boolean noMinimapLoaded() {
        return CurrentMinimap.getLoadedMinimaps().isEmpty();
    }

    public static boolean hiddenMinimap(Minimap minimap) {
        class_310 mc = class_310.method_1551();
        boolean hidden = false;
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return false;
        }
        switch (minimap.ordinal()) {
            case 3: {
                hidden = (Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false || mc.field_1690.field_1866;
                break;
            }
            case 0: {
                hidden = !HudMod.INSTANCE.getSettings().getMinimap() || mc.field_1690.field_1866 || mc.field_1755 != null && !(mc.field_1755 instanceof class_408) && !(mc.field_1755 instanceof class_418);
                break;
            }
            case 1: {
                hidden = !HudMod.INSTANCE.getSettings().getMinimap() || mc.field_1690.field_1866 || mc.field_1755 != null && !(mc.field_1755 instanceof class_408) && !(mc.field_1755 instanceof class_418);
                break;
            }
            case 4: {
                hidden = Services.MINIMAP.hideMapAtlases();
                break;
            }
            case 6: {
                MapSettingsManager voxelOptions = VoxelMap.getInstance().getMapOptions();
                hidden = voxelOptions.hide || !voxelOptions.showUnderMenus && (mc.field_1755 != null || mc.field_1690.field_1866);
            }
        }
        return hidden;
    }

    public static boolean allMinimapsHidden() {
        List<Minimap> loadedMinimaps = CurrentMinimap.getLoadedMinimaps();
        ArrayList<Boolean> hiddenMinimaps = new ArrayList<Boolean>();
        loadedMinimaps.forEach(minimap -> hiddenMinimaps.add(CurrentMinimap.hiddenMinimap(minimap)));
        return Common.allTrue(hiddenMinimaps);
    }

    public static boolean shouldDrawMinimapHud(Minimap minimap) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return false;
        }
        boolean enabled = SeasonHudClient.getEnableMod() && SeasonHudClient.getEnableMinimapIntegration();
        boolean hiddenMinimap = Common.hideHudInCurrentDimension() || CurrentMinimap.hiddenMinimap(minimap);
        return enabled && Calendar.validNeedCalendar() && !mc.field_1690.field_1842 && !hiddenMinimap;
    }

    public static enum Minimap {
        XAERO("xaerominimap"),
        XAERO_FAIRPLAY("xaerominimapfair"),
        JOURNEYMAP("journeymap"),
        FTB_CHUNKS("ftbchunks"),
        MAP_ATLASES("map_atlases"),
        MAP_ATLASES_FORGE("mapatlases"),
        VOXELMAP("voxelmap");

        private final String modID;

        private Minimap(String modID) {
            this.modID = modID;
        }

        public String getModID() {
            return this.modID;
        }
    }
}

