/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.client.gui.components.buttons.DefaultColorButton;
import club.iananderson.seasonhud.client.gui.components.sliders.rgb.BlueSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.rgb.GreenSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.rgb.RedSlider;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5676;

public class ColorScreen
extends SeasonHudScreen {
    private static final class_2561 SCREEN_TITLE = Common.translatedText("menu.seasonhud.color.title");
    private final List<ColorEditBox> seasonBoxes = new ArrayList<ColorEditBox>();
    private int x;
    private int y;
    private boolean seasonColor;

    public ColorScreen(class_437 parentScreen) {
        super(parentScreen, SCREEN_TITLE);
        this.BUTTON_WIDTH = 170;
        this.loadConfig();
    }

    public static ColorScreen getInstance(class_437 parentScreen) {
        return new ColorScreen(parentScreen);
    }

    private static EnumSet<Seasons> seasonListSet() {
        Object set = Seasons.SEASONS_ENUM_LIST.clone();
        ((AbstractCollection)set).remove((Object)Seasons.NULL);
        if (!SeasonHudClient.getShowTropicalSeason() || Common.fabricSeasonsLoaded()) {
            ((AbstractCollection)set).remove((Object)Seasons.DRY);
            ((AbstractCollection)set).remove((Object)Seasons.WET);
        }
        return set;
    }

    public void loadConfig() {
        this.seasonColor = SeasonHudClient.getEnableSeasonNameColor();
    }

    @Override
    public void onDone() {
        this.seasonBoxes.forEach(editBox -> {
            if (Integer.parseInt(editBox.method_1882()) != editBox.getColor()) {
                editBox.save();
            }
        });
        super.onDone();
    }

    @Override
    public void method_25419() {
        SeasonHudClient.setEnableSeasonNameColor(this.seasonColor);
        super.method_25419();
    }

    public int getBoxWidth() {
        int widgetCount = ColorScreen.seasonListSet().size();
        int widgetTotalSize = 86 * widgetCount;
        int boxWidth = this.field_22789 < widgetTotalSize ? 60 : 80;
        return boxWidth;
    }

    private List<class_339> seasonWidget(int x, int y, Seasons season) {
        ColorEditBox colorBox = new ColorEditBox(this.field_22793, x, y, this.getBoxWidth(), this.BUTTON_HEIGHT, season);
        int initialR = Rgb.rColor(colorBox.getColor());
        int initialG = Rgb.gColor(colorBox.getColor());
        int initialB = Rgb.bColor(colorBox.getColor());
        y += colorBox.method_25364() + 6;
        RedSlider redSlider = new RedSlider(--x, y += this.BUTTON_HEIGHT + 2, initialR, colorBox);
        GreenSlider greenSlider = new GreenSlider(x, y += redSlider.method_25364() + 2, initialG, colorBox);
        BlueSlider blueSlider = new BlueSlider(x, y += greenSlider.method_25364() + 2, initialB, colorBox);
        DefaultColorButton defaultButton = DefaultColorButton.builder(colorBox, press -> {
            int defaultColorInt = season.getDefaultColor();
            if (colorBox.getNewColor() != defaultColorInt) {
                int r = Rgb.rColor(defaultColorInt);
                int g = Rgb.gColor(defaultColorInt);
                int b = Rgb.bColor(defaultColorInt);
                redSlider.setValue(r);
                greenSlider.setValue(g);
                blueSlider.setValue(b);
                colorBox.method_1852(String.valueOf(defaultColorInt));
                Rgb.setRgb(season, defaultColorInt);
            }
        }).withPos(x, y -= greenSlider.method_25364() + redSlider.method_25364() + 2 + this.BUTTON_HEIGHT + 2).build();
        this.seasonBoxes.add(colorBox);
        return new ArrayList<class_339>(Arrays.asList(new class_339[]{colorBox, defaultButton, redSlider, greenSlider, blueSlider}));
    }

    @Override
    public void method_25426() {
        super.method_25426();
        int widgetWidth = this.getBoxWidth() + 6;
        int totalWidgetWidth = ColorScreen.seasonListSet().size() * widgetWidth - 6;
        this.x = this.field_22789 / 2 - totalWidgetWidth / 2;
        this.y = 50 + this.BUTTON_HEIGHT + 6 + this.BUTTON_HEIGHT;
        ColorScreen.seasonListSet().forEach(season -> {
            this.widgets.addAll(this.seasonWidget(this.x, this.y, (Seasons)((Object)season)));
            this.x += widgetWidth;
        });
        class_5676 seasonColorButton = class_5676.method_32613((boolean)SeasonHudClient.getEnableSeasonNameColor()).method_32618(t -> Common.newTooltip("menu.seasonhud.color.enableSeasonNameColor.tooltip")).method_32617(this.leftButtonX, 50, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.color.enableSeasonNameColor.button"), (b, val) -> {
            SeasonHudClient.setEnableSeasonNameColor(val);
            this.rebuildWidgets();
        });
        this.widgets.add(seasonColorButton);
        this.widgets.forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    public void method_25393() {
        this.seasonBoxes.forEach(class_342::method_1865);
        super.method_25393();
    }
}

