/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.platform.Services;
import com.demonwav.mcdev.annotations.Translatable;
import io.github.lucaargolo.seasons.FabricSeasons;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_418;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5481;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sereneseasons.config.ServerConfig;

public class Common {
    public static final String MOD_ID = "seasonhud";
    public static final String MOD_NAME = "SeasonHUD";
    public static final Logger LOG = LoggerFactory.getLogger((String)"SeasonHUD");
    public static final class_2960 SEASON_ICONS = Common.location("season_icons");
    public static final class_2583 SEASON_ICON_STYLE = class_2583.field_24360.method_27704(SEASON_ICONS);
    public static class_2960 slotIcon = new class_2960("seasonhud", "slot/calendarslot");
    private static String platformName;
    private static boolean sereneSeasonsLoaded;
    private static boolean fabricSeasonsLoaded;
    private static boolean fabricSeasonsExtrasLoaded;
    private static boolean terrafirmacraftLoaded;
    private static boolean eclipticSeasonsLoaded;
    private static boolean curiosLoaded;
    private static boolean trinketsLoaded;
    private static boolean accessoriesLoaded;

    private Common() {
    }

    public static void init() {
        platformName = Services.PLATFORM.getPlatformName();
        sereneSeasonsLoaded = Services.PLATFORM.isModLoaded("sereneseasons");
        fabricSeasonsLoaded = Services.PLATFORM.isModLoaded("seasons");
        fabricSeasonsExtrasLoaded = Services.PLATFORM.isModLoaded("seasonsextras");
        terrafirmacraftLoaded = Services.PLATFORM.isModLoaded("tfc");
        eclipticSeasonsLoaded = Services.PLATFORM.isModLoaded("eclipticseasons");
        curiosLoaded = Services.PLATFORM.isModLoaded("curios");
        trinketsLoaded = Services.PLATFORM.isModLoaded("trinkets");
        accessoriesLoaded = Services.PLATFORM.isModLoaded("accessories");
    }

    public static String platformName() {
        return platformName;
    }

    public static boolean sereneSeasonsLoaded() {
        return sereneSeasonsLoaded;
    }

    public static boolean fabricSeasonsLoaded() {
        return fabricSeasonsLoaded;
    }

    public static boolean fabricSeasonsExtrasLoaded() {
        return fabricSeasonsExtrasLoaded;
    }

    public static boolean terrafirmacraftLoaded() {
        return terrafirmacraftLoaded;
    }

    public static boolean eclipticSeasonsLoaded() {
        return eclipticSeasonsLoaded;
    }

    public static boolean curiosLoaded() {
        return curiosLoaded;
    }

    public static boolean trinketsLoaded() {
        return trinketsLoaded;
    }

    public static boolean accessoriesLoaded() {
        return accessoriesLoaded;
    }

    public static boolean hasCalendarLoaded() {
        return Common.fabricSeasonsExtrasLoaded() || Common.sereneSeasonsLoaded() || Common.eclipticSeasonsLoaded();
    }

    public static boolean hasSubSeasons() {
        return Common.sereneSeasonsLoaded() || Common.terrafirmacraftLoaded() || Common.eclipticSeasonsLoaded();
    }

    public static boolean clientSideConfig() {
        class_310 mc = class_310.method_1551();
        return mc.method_1558() == null;
    }

    public static boolean vanillaShouldDrawHud() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return false;
        }
        return (mc.field_1755 == null || mc.field_1755 instanceof class_408 || mc.field_1755 instanceof class_418) && !mc.field_1690.field_1866 && !mc.field_1690.field_1842 && !mc.field_1724.method_31550();
    }

    public static boolean minimapIntegrationHidden() {
        return SeasonHudClient.getEnableMinimapIntegration() && CurrentMinimap.allMinimapsHidden() && SeasonHudClient.getShowDefaultWhenMinimapHidden();
    }

    public static boolean drawDefaultHud() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return false;
        }
        return SeasonHudClient.getEnableMod() && (CurrentMinimap.noMinimapLoaded() || !SeasonHudClient.getEnableMinimapIntegration() || Common.minimapIntegrationHidden());
    }

    public static boolean drawDefaultHudMenu() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return false;
        }
        return SeasonHudClient.getEnableMod() && (CurrentMinimap.noMinimapLoaded() || !SeasonHudClient.getEnableMinimapIntegration() || SeasonHudClient.getShowDefaultWhenMinimapHidden());
    }

    public static boolean isDimensionValid(List<? extends String> validDimensions, class_5321<class_1937> dimension) {
        for (String string : validDimensions) {
            if (!dimension.method_29177().toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean hideHudInCurrentDimension() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return false;
        }
        class_5321 currentDim = Objects.requireNonNull(mc.field_1687).method_27983();
        if (Common.fabricSeasonsLoaded()) {
            return !FabricSeasons.CONFIG.isValidInDimension(currentDim);
        }
        if (Common.sereneSeasonsLoaded()) {
            return !ServerConfig.isDimensionWhitelisted((class_5321)currentDim);
        }
        if (Common.eclipticSeasonsLoaded()) {
            List<String> validDimensions = List.of(class_1937.field_25179.method_29177().toString());
            return !Common.isDimensionValid(validDimensions, (class_5321<class_1937>)currentDim);
        }
        return false;
    }

    public static boolean allTrue(List<Boolean> values) {
        for (boolean value : values) {
            if (value) continue;
            return false;
        }
        return true;
    }

    public static class_2960 location(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static class_5250 literalText(String text) {
        return new class_2585(text);
    }

    public static class_5250 translatedText(@Translatable(foldMethod=true) String key) {
        return new class_2588(key);
    }

    public static class_5250 translatedText(@Translatable(foldMethod=true) String key, Object ... args) {
        return new class_2588(key, args);
    }

    public static List<class_5481> newTooltip(@Translatable(foldMethod=true) String key) {
        ArrayList<class_5481> List2 = new ArrayList<class_5481>();
        List2.add(Common.translatedText(key).method_30937());
        return List2;
    }
}

