/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.buttons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.util.Rgb;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultColorButton
extends class_4185 {
    private static final class_2561 DEFAULT = Common.translatedText("menu.seasonhud.color.default.button");
    private final ColorEditBox colorEditBox;
    private final int defaultColor;

    private DefaultColorButton(int x, int y, ColorEditBox colorEditBox, class_4185.class_4241 onPress) {
        super(x, y, colorEditBox.method_25368() + 2, colorEditBox.method_25364() - 2, DEFAULT, onPress, field_40754);
        this.colorEditBox = colorEditBox;
        this.defaultColor = colorEditBox.getSeason().getDefaultColor();
    }

    public static Builder builder(ColorEditBox colorEditBox, class_4185.class_4241 onPress) {
        return new Builder(colorEditBox, onPress);
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException var) {
            return false;
        }
    }

    public int getTextureY() {
        int k = 1;
        if (!this.field_22763) {
            k = 0;
        } else if (this.method_25367()) {
            k = 2;
        }
        return 46 + k * 20;
    }

    public int getFGColor() {
        return this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.refresh();
        String boxValue = this.colorEditBox.method_1882();
        if (this.validate(boxValue) && Integer.parseInt(boxValue) == this.defaultColor) {
            this.field_22763 = false;
        }
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
    }

    private void refresh() {
        Map<String, Integer> currentColors;
        Map<String, Integer> defaultColors = Rgb.defaultSeasonMap(this.colorEditBox.getSeason());
        this.field_22763 = defaultColors != (currentColors = this.colorEditBox.getSeason().getRgbMap());
    }

    public static class Builder {
        protected final class_4185.class_4241 onPress;
        protected final ColorEditBox colorEditBox;
        protected int x;
        protected int y;
        protected class_7919 tooltip;

        public Builder(ColorEditBox colorEditBox, class_4185.class_4241 onPress) {
            this.colorEditBox = colorEditBox;
            this.onPress = onPress;
        }

        public Builder withPos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder withTooltip(@Nullable class_7919 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public DefaultColorButton build() {
            DefaultColorButton button = new DefaultColorButton(this.x, this.y, this.colorEditBox, this.onPress);
            button.method_47400(this.tooltip);
            return button;
        }
    }
}

