/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.Location;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.client.gui.components.sliders.HudOffsetSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.HudScaleSlider;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import org.jetbrains.annotations.NotNull;

public class SeasonOptionsScreen
extends SeasonHudScreen {
    private static final class_2561 SCREEN_TITLE = Common.translatedText("menu.seasonhud.season.title");
    private Location hudLocation;
    private int xSliderInt;
    private int ySliderInt;
    private double seasonScale;
    private ShowDay showDay;
    private boolean seasonColor;
    private boolean showSubSeason;
    private boolean showTropicalSeason;
    private boolean showFertility;
    private boolean needCalendar;
    private boolean enableCalendarDetail;
    private boolean drawDefaultHud;
    private int dayLength;
    private int newDayLength;
    private class_5676<Location> hudLocationButton;
    private HudOffsetSlider xSlider;
    private HudOffsetSlider ySlider;
    private HudScaleSlider hudScaleSlider;
    private class_342 dayLengthBox;

    public SeasonOptionsScreen(class_437 parentScreen) {
        super(parentScreen, SCREEN_TITLE);
    }

    public static SeasonOptionsScreen getInstance(class_437 parentScreen) {
        return new SeasonOptionsScreen(parentScreen);
    }

    public void loadConfig() {
        this.drawDefaultHud = Common.drawDefaultHudMenu();
        this.hudLocation = SeasonHudClient.getHudLocation();
        this.xSliderInt = SeasonHudClient.getHudX();
        this.ySliderInt = SeasonHudClient.getHudY();
        this.seasonScale = SeasonHudClient.getHudScale();
        this.showDay = SeasonHudClient.getShowDay();
        this.seasonColor = SeasonHudClient.getEnableSeasonNameColor();
        this.showSubSeason = SeasonHudClient.getShowSubSeason();
        this.showTropicalSeason = SeasonHudClient.getShowTropicalSeason();
        if (Common.hasCalendarLoaded()) {
            this.needCalendar = SeasonHudServer.getNeedCalendar();
            this.enableCalendarDetail = SeasonHudServer.getCalendarDetailMode();
        }
        if (Common.fabricSeasonsLoaded()) {
            this.dayLength = SeasonHudServer.getDayLength();
        }
        if (Common.sereneSeasonsLoaded()) {
            this.showFertility = SeasonHudClient.getShowFertility();
        }
    }

    @Override
    public void saveConfig() {
        if (this.drawDefaultHud) {
            SeasonHudClient.setHudLocation((Location)((Object)this.hudLocationButton.method_32603()));
            SeasonHudClient.setHudX(this.xSlider.getValueInt());
            SeasonHudClient.setHudY(this.ySlider.getValueInt());
            SeasonHudClient.setHudScale(this.hudScaleSlider.getValueDouble());
        }
        SeasonHudClient.setShowDay(this.showDay);
        SeasonHudClient.setEnableSeasonNameColor(this.seasonColor);
        if (Common.hasSubSeasons()) {
            SeasonHudClient.setShowSubSeason(this.showSubSeason);
            SeasonHudClient.setShowTropicalSeason(this.showTropicalSeason);
        }
        if (Common.clientSideConfig()) {
            if (Common.hasCalendarLoaded()) {
                SeasonHudServer.setCalendarDetailMode(this.enableCalendarDetail);
                SeasonHudServer.setNeedCalendar(this.needCalendar);
            }
            if (Common.fabricSeasonsLoaded()) {
                SeasonHudServer.setDayLength(Integer.parseInt(this.dayLengthBox.method_1882()));
            }
            SeasonHudServer.SERVER_SPEC.save();
        }
        if (Common.sereneSeasonsLoaded()) {
            SeasonHudClient.setShowFertility(this.showFertility);
        }
        SeasonHudClient.CLIENT_SPEC.save();
    }

    @Override
    public void onDone() {
        this.saveConfig();
        super.onDone();
    }

    @Override
    public void method_25419() {
        super.method_25419();
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        int x = 3;
        int y = 3;
        this.seasonScale = 1.0;
        class_5250 seasonCombined = CurrentSeason.getInstance(this.field_22787).getConfigText(this.showDay, this.showSubSeason, this.seasonColor);
        class_5250 fertility = CurrentFertility.getInstance(this.field_22787).getHudText();
        if (this.drawDefaultHud) {
            int DEFAULT_X_OFFSET_SCALED = 2;
            int DEFAULT_Y_OFFSET_SCALED = 2;
            this.seasonScale = this.hudScaleSlider.getValueDouble();
            int componentWidth = (int)((double)this.field_22793.method_27525((class_5348)seasonCombined) * this.seasonScale);
            Objects.requireNonNull(this.field_22793);
            int componentHeight = (int)(9.0 * this.seasonScale);
            boolean customLocation = this.hudLocationButton.method_32603() == Location.CUSTOM;
            this.hudScaleSlider.field_22764 = this.drawDefaultHud;
            this.xSlider.field_22763 = customLocation;
            this.xSlider.field_22764 = this.drawDefaultHud;
            this.ySlider.field_22763 = customLocation;
            this.ySlider.field_22764 = this.drawDefaultHud;
            switch (this.hudLocation) {
                case TOP_LEFT: {
                    x = DEFAULT_X_OFFSET_SCALED;
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case TOP_CENTER: {
                    x = (int)(((double)this.field_22789 / 2.0 - (double)componentWidth / 2.0) / this.seasonScale);
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case TOP_RIGHT: {
                    x = (int)((double)(this.field_22789 - componentWidth - DEFAULT_X_OFFSET_SCALED) / this.seasonScale);
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case BOTTOM_LEFT: {
                    x = DEFAULT_X_OFFSET_SCALED;
                    y = (int)((double)(this.field_22790 - componentHeight - DEFAULT_Y_OFFSET_SCALED) / this.seasonScale);
                    break;
                }
                case BOTTOM_RIGHT: {
                    x = (int)((double)(this.field_22789 - componentWidth - DEFAULT_X_OFFSET_SCALED) / this.seasonScale);
                    y = (int)((double)(this.field_22790 - componentHeight - DEFAULT_Y_OFFSET_SCALED) / this.seasonScale);
                    break;
                }
                case CUSTOM: {
                    x = this.xSlider.getValueInt();
                    y = this.ySlider.getValueInt();
                }
            }
        }
        if (Common.fabricSeasonsLoaded() && Common.clientSideConfig()) {
            int row = 4;
            if (Common.fabricSeasonsExtrasLoaded()) {
                ++row;
            }
            if (!this.drawDefaultHud) {
                row -= 2;
            }
            int n = this.leftButtonX + this.BUTTON_WIDTH / 2;
            Objects.requireNonNull(this.field_22793);
            graphics.method_25300(this.field_22793, "Day Length", n, 50 + row * (this.BUTTON_HEIGHT + 6) - (9 + 6), 0xFFFFFF);
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 50.0f);
        graphics.method_51448().method_22905((float)this.seasonScale, (float)this.seasonScale, 1.0f);
        graphics.method_27535(this.field_22793, (class_2561)seasonCombined, x, y, 0xFFFFFF);
        if (this.showFertility) {
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)fertility, x, y += 9, 0xFFFFFF);
        }
        graphics.method_51448().method_22909();
    }

    private int maxWidth(class_5250 seasonText) {
        int textWidth = this.field_22793.method_27525((class_5348)seasonText);
        return (int)(((double)this.field_22789 - (double)textWidth * this.seasonScale) / this.seasonScale);
    }

    private int maxHeight() {
        Objects.requireNonNull(this.field_22793);
        int textHeight = 9;
        return (int)(((double)this.field_22790 - (double)textHeight * this.seasonScale) / this.seasonScale);
    }

    @Override
    public void method_25426() {
        this.loadConfig();
        super.method_25426();
        class_5250 seasonCombined = CurrentSeason.getInstance(this.field_22787).getHudText();
        this.row = -1;
        if (this.drawDefaultHud) {
            ++this.row;
            this.hudLocationButton = class_5676.method_32606(Location::getLocationName).method_32618(t -> Common.newTooltip("menu.seasonhud.season.hudLocation.tooltip")).method_32624((Object[])Location.values()).method_32619((Object)this.hudLocation).method_32617(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.hudLocation.button"), (b, val) -> {
                this.hudLocation = val;
            });
            this.hudScaleSlider = HudScaleSlider.builder((class_2561)Common.translatedText("menu.seasonhud.season.scale.slider")).withTooltip(Common.newTooltip("menu.seasonhud.season.scale.tooltip")).withValueRange(0.5, 10.0).withInitialValue(this.seasonScale).withDefaultValue(1.0).withStepSize(0.5).withPrecision(1).withBounds(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT).build();
            ++this.row;
            this.xSlider = HudOffsetSlider.builder((class_2561)Common.translatedText("menu.seasonhud.season.xOffset.slider")).withTooltip(Common.newTooltip("menu.seasonhud.season.xOffset.tooltip")).withValues(0, this.maxWidth(seasonCombined), this.xSliderInt, 2).withBounds(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH / 2 - 2, this.BUTTON_HEIGHT).build();
            this.ySlider = HudOffsetSlider.builder((class_2561)Common.translatedText("menu.seasonhud.season.yOffset.slider")).withTooltip(Common.newTooltip("menu.seasonhud.season.yOffset.tooltip")).withValues(0, this.maxHeight(), this.ySliderInt, 2).withBounds(this.rightButtonX + this.BUTTON_WIDTH / 2 + 2, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH / 2 - 2, this.BUTTON_HEIGHT).build();
            this.widgets.addAll(Arrays.asList(new class_339[]{this.hudLocationButton, this.hudScaleSlider, this.xSlider, this.ySlider}));
        }
        ++this.row;
        class_5676 showDayButton = class_5676.method_32606(ShowDay::getDayDisplayName).method_32618(t -> Common.newTooltip("menu.seasonhud.season.showDay.tooltip")).method_32620(ShowDay.getValues()).method_32619((Object)this.showDay).method_32617(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.showDay.button"), (b, val) -> {
            this.showDay = val;
        });
        class_5676 seasonColorButton = class_5676.method_32613((boolean)this.seasonColor).method_32618(t -> Common.newTooltip("menu.seasonhud.color.enableSeasonNameColor.tooltip")).method_32617(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.color.enableSeasonNameColor.button"), (b, val) -> {
            this.seasonColor = val;
        });
        this.widgets.addAll(Arrays.asList(showDayButton, seasonColorButton));
        if (Common.hasSubSeasons()) {
            ++this.row;
            class_5676 showSubSeasonButton = class_5676.method_32613((boolean)this.showSubSeason).method_32618(t -> Common.newTooltip("menu.seasonhud.season.showSubSeason.tooltip")).method_32617(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.showSubSeason.button"), (b, val) -> {
                this.showSubSeason = val;
            });
            class_5676 showTropicalSeasonButton = class_5676.method_32613((boolean)this.showTropicalSeason).method_32618(t -> Common.newTooltip("menu.seasonhud.season.showTropicalSeason.tooltip")).method_32617(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.showTropicalSeason.button"), (b, val) -> {
                this.showTropicalSeason = val;
            });
            this.widgets.addAll(Arrays.asList(showSubSeasonButton, showTropicalSeasonButton));
        }
        if (Common.hasCalendarLoaded()) {
            ++this.row;
            class_5676 needCalendarButton = class_5676.method_32613((boolean)this.needCalendar).method_32618(t -> Common.newTooltip("menu.seasonhud.season.needCalendar.tooltip")).method_32617(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.needCalendar.button"), (b, val) -> {
                this.needCalendar = val;
            });
            needCalendarButton.field_22763 = Common.clientSideConfig();
            class_5676 calendarDetailModeButton = class_5676.method_32613((boolean)this.enableCalendarDetail).method_32618(t -> Common.newTooltip("menu.seasonhud.season.calendarDetail.tooltip")).method_32617(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.calendarDetail.button"), (b, val) -> {
                this.enableCalendarDetail = val;
            });
            if (!Common.clientSideConfig()) {
                needCalendarButton.field_22763 = false;
                needCalendarButton.method_47400(Common.newTooltip("menu.seasonhud.season.serverSide.tooltip"));
                calendarDetailModeButton.field_22763 = false;
                calendarDetailModeButton.method_47400(Common.newTooltip("menu.seasonhud.season.serverSide.tooltip"));
            }
            this.widgets.addAll(Arrays.asList(needCalendarButton, calendarDetailModeButton));
        }
        if (Common.sereneSeasonsLoaded()) {
            ++this.row;
            class_5676 showFertilityButton = class_5676.method_32613((boolean)this.showFertility).method_32618(t -> Common.newTooltip("menu.seasonhud.season.showFertility.tooltip")).method_32617(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.showFertility.button"), (b, val) -> {
                this.showFertility = val;
            });
            this.widgets.add(showFertilityButton);
        }
        if (Common.fabricSeasonsLoaded()) {
            this.row += 2;
            this.dayLengthBox = new class_342(this.field_22793, this.leftButtonX + 1, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH - 2, this.BUTTON_HEIGHT, (class_2561)Common.literalText(String.valueOf(this.dayLength)));
            this.dayLengthBox.method_1880(10);
            this.dayLengthBox.method_1852(String.valueOf(this.dayLength));
            this.dayLengthBox.method_1863(lengthString -> {
                if (this.validate((String)lengthString)) {
                    this.dayLengthBox.method_1868(0xFFFFFF);
                    int currentLength = Integer.parseInt(lengthString);
                    if (currentLength != this.newDayLength) {
                        this.newDayLength = currentLength;
                        this.dayLengthBox.method_1852(lengthString);
                    }
                    SeasonOptionsScreen.doneButton.field_22763 = true;
                } else {
                    this.dayLengthBox.method_1868(0xFF5555);
                    SeasonOptionsScreen.doneButton.field_22763 = false;
                }
            });
            this.dayLengthBox.method_47404((class_2561)Common.literalText("" + this.dayLength).method_27692(class_124.field_1063));
            this.dayLengthBox.field_22764 = Common.clientSideConfig();
            this.widgets.add(this.dayLengthBox);
        }
        this.widgets.forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    private boolean inBounds(int length) {
        int minInt = 0;
        return length >= minInt;
    }

    public boolean validate(String length) {
        try {
            int dayLength = Integer.parseInt(length);
            return this.inBounds(dayLength);
        }
        catch (NumberFormatException formatException) {
            return false;
        }
    }
}

