/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders;

import club.iananderson.seasonhud.Common;
import java.text.DecimalFormat;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import org.jetbrains.annotations.NotNull;

public class BasicSlider
extends class_357 {
    public static final int SLIDER_PADDING = 2;
    protected static final class_2960 SLIDER_LOCATION = Common.location("textures/gui/slider.png");
    protected boolean drawString;
    protected boolean canChangeValue;
    protected double minValue;
    protected double maxValue;
    protected double defaultValue;
    protected double stepSize;
    protected class_124 textColor;
    private DecimalFormat format;

    private BasicSlider(int x, int y, int width, int height, boolean drawString, double initial) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.drawString = drawString;
        this.field_22753 = this.snapToNearest(initial);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision, class_124 textColor) {
        this(x, y, width, height, drawString, initial);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.field_22753 = this.snapToNearest((initial - minValue) / (maxValue - minValue));
        this.stepSize = Math.abs(stepSize);
        this.textColor = textColor;
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = class_3532.method_20390((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.method_25346();
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, class_124 textColor) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, 1.0, 0, textColor);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, stepSize, precision, class_124.field_1068);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, 1.0, 0, class_124.field_1068);
    }

    public void onRightClick() {
        this.setValue(this.defaultValue);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        boolean rightClicked;
        if (this.field_22763 && this.field_22764 && mouseButton == 1 && (rightClicked = this.method_25361(mouseX, mouseY))) {
            this.method_25354(class_310.method_1551().method_1483());
            this.onRightClick();
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public int getTextureY() {
        int i = this.method_25370() && !this.canChangeValue ? 1 : 0;
        return i * 20;
    }

    public int getHandleTextureY() {
        int i = !this.field_22762 && !this.canChangeValue ? 2 : 3;
        return i * 20;
    }

    public int getFGColor() {
        return this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
    }

    protected double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        }
        value = class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? class_3532.method_15350((double)value, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
        return class_3532.method_33722((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    public double getValue() {
        return this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.field_22753 = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.method_25346();
    }

    public double getValueDouble() {
        return (double)Math.round(this.getValue() * 10.0) / 10.0;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void setSliderValue(double value) {
        double oldValue = this.field_22753;
        this.field_22753 = this.snapToNearest(value);
        if (!class_3532.method_20390((double)oldValue, (double)this.field_22753)) {
            this.method_25344();
        }
        this.method_25346();
    }

    protected void method_25344() {
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean bl;
        boolean bl2 = bl = keyCode == 263;
        if (bl || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                bl = !bl;
            }
            float f2 = f = bl ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.field_22753 + (double)(f / (float)(this.field_22758 - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    protected void method_25346() {
        if (this.drawString) {
            this.method_25355((class_2561)Common.literalText(this.getValueString()));
        } else {
            this.method_25355((class_2561)class_2561.method_43473());
        }
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(graphics, mouseX, mouseY, partialTick);
    }
}

