/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class MapAtlasesCommon {
    private MapAtlasesCommon() {
    }

    private static void drawSeasonWithLighterShadow(class_332 graphics, class_327 font, class_5250 text, class_5250 shadowText) {
        graphics.method_51439(font, (class_2561)shadowText, 1, 1, 0x595959, false);
        graphics.method_51439(font, (class_2561)text, 0, 0, 0xFFFFFF, false);
    }

    private static void drawScaledComponent(class_332 graphics, class_327 font, int x, int y, class_5250 text, class_5250 shadowText, float textScaling, int maxWidth, int targetWidth) {
        class_4587 pose = graphics.method_51448();
        float textWidth = font.method_27525((class_5348)text);
        float scale = Math.min(1.0f, (float)maxWidth * textScaling / textWidth);
        float centerX = (float)x + (float)targetWidth / 2.0f;
        pose.method_22903();
        pose.method_46416(centerX, (float)(y + 4), 5.0f);
        pose.method_22905(scale *= textScaling, scale, 1.0f);
        pose.method_46416(-textWidth / 2.0f, -4.0f, 0.0f);
        MapAtlasesCommon.drawSeasonWithLighterShadow(graphics, font, text, shadowText);
        pose.method_22909();
    }

    public static void drawMapComponentSeason(class_332 graphics, class_327 font, int x, int y, int targetWidth, float textScaling, float globalScale) {
        class_5250 seasonCombined = CurrentSeason.getInstance(class_310.method_1551()).getHudText();
        class_5250 seasonShadowText = CurrentSeason.getInstance(class_310.method_1551()).getHudTextNoFormat();
        class_5250 fertility = CurrentFertility.getInstance(class_310.method_1551()).getMinimapText();
        class_5250 fertilityShadowText = CurrentFertility.getInstance(class_310.method_1551()).getHudTextNoFormat();
        MapAtlasesCommon.drawScaledComponent(graphics, font, x, y, seasonCombined, seasonShadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        if (Common.sereneSeasonsLoaded() && SeasonHudClient.getShowFertility()) {
            Objects.requireNonNull(font);
            MapAtlasesCommon.drawScaledComponent(graphics, font, x, y + 9, fertility, fertilityShadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        }
    }

    public static void drawScaledText(class_332 context, int x, int y, class_5250 text, class_5250 shadowText, float textScaling, int originOffsetWidth, int originOffsetHeight) {
        class_310 mc = class_310.method_1551();
        class_4587 poseStack = context.method_51448();
        float textWidth = (float)mc.field_1772.method_27525((class_5348)text) * textScaling;
        float textX = (float)((double)x + (double)originOffsetWidth / 2.0 - (double)textWidth / 2.0);
        float textY = y + originOffsetHeight;
        if (textX + textWidth >= (float)mc.method_22683().method_4486()) {
            textX = (float)mc.method_22683().method_4486() - textWidth;
        }
        poseStack.method_22903();
        poseStack.method_46416(textX, textY, 5.0f);
        poseStack.method_22905(textScaling, textScaling, 1.0f);
        context.method_51439(mc.field_1772, (class_2561)shadowText, 1, 1, Integer.parseInt("595959", 16), false);
        context.method_51439(mc.field_1772, (class_2561)text, 0, 0, Integer.parseInt("E0E0E0", 16), false);
        poseStack.method_22909();
    }

    public static void drawMapComponentSeasonOld(class_332 poseStack, int x, int y, int originOffsetWidth, int originOffsetHeight, float textScaling) {
        if (CurrentMinimap.mapAtlasesLoaded()) {
            class_310 mc = class_310.method_1551();
            class_5250 seasonCombined = CurrentSeason.getInstance(class_310.method_1551()).getHudText();
            class_5250 seasonShadowText = CurrentSeason.getInstance(class_310.method_1551()).getHudTextNoFormat();
            class_5250 fertility = CurrentFertility.getInstance(class_310.method_1551()).getMinimapText();
            class_5250 fertilityShadowText = CurrentFertility.getInstance(class_310.method_1551()).getHudTextNoFormat();
            MapAtlasesCommon.drawScaledText(poseStack, x, y, seasonCombined, seasonShadowText, textScaling, originOffsetWidth, originOffsetHeight);
            if (Common.sereneSeasonsLoaded() && SeasonHudClient.getShowFertility()) {
                Objects.requireNonNull(mc.field_1772);
                MapAtlasesCommon.drawScaledText(poseStack, x, y + 9, fertility, fertilityShadowText, textScaling, originOffsetWidth, originOffsetHeight);
            }
        }
    }
}

