/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.CommonSeasonHelper;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import java.time.LocalDateTime;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class CurrentSeason {
    private final String currentSeason;
    private final String currentSubSeason;
    private final String seasonFileName;
    private final long seasonDate;
    private final int seasonDuration;
    private final class_1657 player;
    private class_2583 seasonFormat;

    public CurrentSeason(class_310 mc) {
        this.player = mc.field_1724;
        this.seasonFormat = class_2583.field_24360;
        this.currentSeason = CommonSeasonHelper.commonSeasons.getCurrentSeason(this.player);
        this.currentSubSeason = CommonSeasonHelper.commonSeasons.getCurrentSubSeason(this.player);
        this.seasonFileName = CommonSeasonHelper.commonSeasons.getSeasonFileName(this.player);
        this.seasonDate = CommonSeasonHelper.commonSeasons.getDate(this.player);
        this.seasonDuration = CommonSeasonHelper.commonSeasons.seasonDuration(this.player);
    }

    public static CurrentSeason getInstance(class_310 mc) {
        return new CurrentSeason(mc);
    }

    public String getSubSeasonLowerCase() {
        String lowerSubSeason = this.currentSubSeason.toLowerCase();
        if (Common.fabricSeasonsLoaded()) {
            return this.currentSeason.toLowerCase();
        }
        return this.currentSeason.toLowerCase() + "." + lowerSubSeason.substring(0, lowerSubSeason.indexOf("_"));
    }

    public String getSeasonLowerCase() {
        return this.currentSeason.toLowerCase();
    }

    public class_2561 getKey(boolean showSubSeason) {
        String season;
        String string = season = showSubSeason ? this.getSubSeasonLowerCase() : this.getSeasonLowerCase();
        if (!Calendar.validDetailedMode() || Common.fabricSeasonsLoaded()) {
            season = this.getSeasonLowerCase();
        }
        if (Common.eclipticSeasonsLoaded() && Calendar.validDetailedMode() && SeasonHudClient.getShowSubSeason()) {
            season = this.currentSubSeason;
            if (this.currentSubSeason.equals("MID_NULL")) {
                return Common.translatedText("desc.seasonhud.season." + this.getSubSeasonLowerCase());
            }
            return Common.translatedText("info.eclipticseasons.environment.solar_term." + season);
        }
        return Common.translatedText("desc.seasonhud.season." + season);
    }

    public String getIcon() {
        for (Seasons season : Seasons.values()) {
            if (!season.getFileName().equals(this.seasonFileName)) continue;
            return season.getIconChar();
        }
        return "Icon Error";
    }

    public class_2561 getText(ShowDay showDay, boolean showSubSeason) {
        class_5250 text = Common.literalText("");
        class_2561 seasonKey = this.getKey(showSubSeason);
        switch (showDay) {
            case NONE: {
                text = Common.translatedText(ShowDay.NONE.getKey(), seasonKey);
                break;
            }
            case SHOW_DAY: {
                text = Common.translatedText(ShowDay.SHOW_DAY.getKey(), seasonKey, this.seasonDate);
                break;
            }
            case SHOW_WITH_TOTAL_DAYS: {
                text = Common.translatedText(ShowDay.SHOW_WITH_TOTAL_DAYS.getKey(), seasonKey, this.seasonDate, this.seasonDuration);
                break;
            }
            case SHOW_WITH_MONTH: {
                if (CommonSeasonHelper.commonSeasons.isSeasonTiedWithSystemTime()) {
                    int systemMonth = LocalDateTime.now().getMonth().getValue();
                    Object systemMonthString = String.valueOf(systemMonth);
                    if (systemMonth < 10) {
                        systemMonthString = "0" + (String)systemMonthString;
                    }
                    class_5250 currentMonth = Common.translatedText("desc.seasonhud.month." + (String)systemMonthString);
                    text = Common.translatedText(ShowDay.SHOW_WITH_MONTH.getKey(), seasonKey, currentMonth, this.seasonDate);
                    if (Calendar.validDetailedMode()) break;
                    text = Common.translatedText(ShowDay.NONE.getKey(), seasonKey);
                    break;
                }
                text = Common.translatedText(ShowDay.SHOW_DAY.getKey(), seasonKey, this.seasonDate);
            }
        }
        return text;
    }

    public int getTextColor() {
        for (Seasons season : Seasons.values()) {
            if (!season.getFileName().equals(this.seasonFileName)) continue;
            return season.getSeasonColor();
        }
        return 0xFFFFFF;
    }

    public class_5250 getHudTextNoFormat() {
        class_5250 seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getIcon()).method_27696(Common.SEASON_ICON_STYLE);
        ShowDay showDay = SeasonHudClient.getShowDay();
        boolean showSubSeason = SeasonHudClient.getShowSubSeason();
        class_5250 seasonText = this.getText(showDay, showSubSeason).method_27661();
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon, seasonText);
    }

    public class_5250 getHudText() {
        class_5250 seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getIcon());
        ShowDay showDay = SeasonHudClient.getShowDay();
        boolean showSubSeason = SeasonHudClient.getShowSubSeason();
        class_5250 seasonText = this.getText(showDay, showSubSeason).method_27661();
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = class_2583.field_24360.method_36139(this.getTextColor());
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.method_27696(Common.SEASON_ICON_STYLE).method_54663(0xFFFFFF), seasonText.method_27696(this.seasonFormat));
    }

    public class_5250 getMenuText(Seasons season, int newRgb, boolean seasonShort) {
        class_5250 seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", season.getIconChar());
        class_5250 seasonText = Common.translatedText(ShowDay.NONE.getKey(), season.getSeasonName());
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = class_2583.field_24360.method_36139(newRgb);
        }
        if (season == Seasons.DRY && seasonShort) {
            seasonText = Common.translatedText("menu.seasonhud.color.season.dry.editbox");
        }
        if (season == Seasons.WET && seasonShort) {
            seasonText = Common.translatedText("menu.seasonhud.color.season.wet.editbox");
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.method_27696(Common.SEASON_ICON_STYLE), seasonText.method_27696(this.seasonFormat));
    }

    public class_5250 getConfigText(ShowDay showDay, boolean showSubSeason, boolean seasonColor) {
        class_5250 seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getIcon());
        class_5250 seasonText = this.getText(showDay, showSubSeason).method_27661();
        if (seasonColor) {
            this.seasonFormat = class_2583.field_24360.method_36139(this.getTextColor());
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.method_27696(Common.SEASON_ICON_STYLE), seasonText.method_27696(this.seasonFormat));
    }
}

