/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.Fertility;
import club.iananderson.seasonhud.impl.seasons.mods.ISeasonModHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.calendar.Season;
import net.minecraft.class_1657;
import net.minecraft.class_1792;

public class TerrafirmaCraftHelper
implements ISeasonModHelper {
    private Month getCurrentMonth() {
        return Calendars.get().getHemispheralCalendarMonthOfYear(ClientHelpers.inNorthernHemisphere());
    }

    private List<Month> getSeasonMonths(Season season) {
        ArrayList<Month> SEASON = new ArrayList<Month>();
        switch (season) {
            case WINTER: {
                SEASON.add(SubSeason.EARLY.getWinter());
                SEASON.add(SubSeason.MID.getWinter());
                SEASON.add(SubSeason.LATE.getWinter());
                break;
            }
            case SPRING: {
                SEASON.add(SubSeason.EARLY.getSpring());
                SEASON.add(SubSeason.MID.getSpring());
                SEASON.add(SubSeason.LATE.getSpring());
                break;
            }
            case SUMMER: {
                SEASON.add(SubSeason.EARLY.getSummer());
                SEASON.add(SubSeason.MID.getSummer());
                SEASON.add(SubSeason.LATE.getSummer());
                break;
            }
            case FALL: {
                SEASON.add(SubSeason.EARLY.getAutumn());
                SEASON.add(SubSeason.MID.getAutumn());
                SEASON.add(SubSeason.LATE.getAutumn());
            }
        }
        return SEASON;
    }

    private String getSeasonPrefix() {
        Season season = this.getCurrentMonth().getSeason();
        HashMap<Month, String> SEASON = new HashMap<Month, String>();
        switch (season) {
            case WINTER: {
                SEASON.put(SubSeason.EARLY.getWinter(), SubSeason.EARLY.getPrefix());
                SEASON.put(SubSeason.MID.getWinter(), SubSeason.MID.getPrefix());
                SEASON.put(SubSeason.LATE.getWinter(), SubSeason.LATE.getPrefix());
                break;
            }
            case SPRING: {
                SEASON.put(SubSeason.EARLY.getSpring(), SubSeason.EARLY.getPrefix());
                SEASON.put(SubSeason.MID.getSpring(), SubSeason.MID.getPrefix());
                SEASON.put(SubSeason.LATE.getSpring(), SubSeason.LATE.getPrefix());
                break;
            }
            case SUMMER: {
                SEASON.put(SubSeason.EARLY.getSummer(), SubSeason.EARLY.getPrefix());
                SEASON.put(SubSeason.MID.getSummer(), SubSeason.MID.getPrefix());
                SEASON.put(SubSeason.LATE.getSummer(), SubSeason.LATE.getPrefix());
                break;
            }
            case FALL: {
                SEASON.put(SubSeason.EARLY.getAutumn(), SubSeason.EARLY.getPrefix());
                SEASON.put(SubSeason.MID.getAutumn(), SubSeason.MID.getPrefix());
                SEASON.put(SubSeason.LATE.getAutumn(), SubSeason.LATE.getPrefix());
            }
        }
        return (String)SEASON.get(this.getCurrentMonth());
    }

    @Override
    public class_1792 CALENDAR() {
        return null;
    }

    @Override
    public boolean isTropicalSeason(class_1657 player) {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        return false;
    }

    @Override
    public String getCurrentSubSeason(class_1657 player) {
        Season season = this.getCurrentMonth().getSeason();
        String prefix = this.getSeasonPrefix();
        if (season == Season.FALL) {
            return prefix + "AUTUMN";
        }
        return prefix + season.getSerializedName();
    }

    @Override
    public String getCurrentSeason(class_1657 player) {
        Season season = this.getCurrentMonth().getSeason();
        if (season == Season.FALL) {
            return "AUTUMN";
        }
        return season.getSerializedName();
    }

    @Override
    public long getDate(class_1657 player) {
        Season currentSeason = this.getCurrentMonth().getSeason();
        List<Month> currentSeasonMonths = this.getSeasonMonths(currentSeason);
        int subSeasonPos = currentSeasonMonths.indexOf(this.getCurrentMonth());
        int dayOfMonth = Calendars.get().getCalendarDayOfMonth();
        int daysInMonth = Calendars.get().getCalendarDaysInMonth();
        if (SeasonHudClient.getShowSubSeason()) {
            return dayOfMonth;
        }
        return (long)dayOfMonth + (long)subSeasonPos * (long)daysInMonth;
    }

    @Override
    public int seasonDuration(class_1657 player) {
        int daysInMonth = Calendars.get().getCalendarDaysInMonth();
        if (SeasonHudClient.getShowSubSeason() && Calendar.validDetailedMode()) {
            return daysInMonth;
        }
        return daysInMonth * 3;
    }

    @Override
    public boolean infertileBiome(class_1657 player) {
        return false;
    }

    @Override
    public boolean alwaysWinterBiome(class_1657 player) {
        return false;
    }

    @Override
    public boolean undergroundFertile(class_1657 player) {
        return true;
    }

    @Override
    public Fertility fertility(class_1657 player) {
        return Fertility.FERTILE;
    }

    private static enum SubSeason {
        EARLY("EARLY_", Month.DECEMBER, Month.MARCH, Month.JUNE, Month.SEPTEMBER),
        MID("MID_", Month.JANUARY, Month.APRIL, Month.JULY, Month.OCTOBER),
        LATE("LATE_", Month.FEBRUARY, Month.MAY, Month.AUGUST, Month.NOVEMBER);

        private final String prefix;
        private final Month winter;
        private final Month spring;
        private final Month summer;
        private final Month autumn;

        private SubSeason(String prefix, Month winter, Month spring, Month summer, Month autumn) {
            this.prefix = prefix;
            this.winter = winter;
            this.spring = spring;
            this.summer = summer;
            this.autumn = autumn;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Month getWinter() {
            return this.winter;
        }

        public Month getSpring() {
            return this.spring;
        }

        public Month getSummer() {
            return this.summer;
        }

        public Month getAutumn() {
            return this.autumn;
        }
    }
}

