/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.mixin;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class SeasonHUDMixinPlugin
implements IMixinConfigPlugin {
    private static final boolean HAS_XAERO = SeasonHUDMixinPlugin.hasClass("xaero.common.HudMod");
    private static final boolean HAS_FTB = SeasonHUDMixinPlugin.hasClass("dev.ftb.mods.ftbchunks.FTBChunks");
    private static final boolean HAS_MAP_ATLASES = SeasonHUDMixinPlugin.hasClass("pepjebs.mapatlases.MapAtlasesMod");
    private String prefix = null;

    private static boolean hasClass(String modClass) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(modClass);
            return true;
        }
        catch (IOException | ClassNotFoundException e) {
            return false;
        }
    }

    public void onLoad(String mixinPackage) {
        this.prefix = mixinPackage + ".";
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Preconditions.checkState((boolean)mixinClassName.startsWith(this.prefix), (Object)("Unexpected prefix on " + mixinClassName));
        if (mixinClassName.startsWith("club.iananderson.seasonhud.mixin.xaero")) {
            return HAS_XAERO;
        }
        if (mixinClassName.startsWith("club.iananderson.seasonhud.mixin.ftbchunks")) {
            return HAS_FTB;
        }
        if (mixinClassName.startsWith("club.iananderson.seasonhud.mixin.mapatlases")) {
            return HAS_MAP_ATLASES;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

