/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.buttons.MenuButton;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.client.gui.screens.SeasonOptionsScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import org.jetbrains.annotations.NotNull;

public class MainConfigScreen
extends SeasonHudScreen {
    private static final class_2561 SCREEN_TITLE = Common.translatedText("menu.seasonhud.main.title");
    private static final class_2561 MINIMAP_SETTINGS = Common.translatedText("menu.seasonhud.main.minimap.options");
    private static final class_2561 JOURNEYMAP = Common.translatedText("menu.seasonhud.main.journeymap.title");
    private final List<class_339> optionButtons = new ArrayList<class_339>();
    MenuButton seasonButton;
    MenuButton colorButton;
    class_5676<Boolean> enableMinimapIntegrationButton;
    class_5676<Boolean> showMinimapHiddenButton;
    class_5676<Boolean> journeyMapAboveMapButton;
    class_5676<Boolean> journeyMapMacOSButton;
    private boolean enableMod;
    private boolean showMinimapHidden;
    private boolean enableMinimapIntegration;
    private boolean journeyMapAboveMap;
    private boolean journeyMapMacOS;

    public MainConfigScreen() {
        super(null, SCREEN_TITLE);
        this.loadConfig();
        this.BUTTON_WIDTH = 170;
    }

    public static MainConfigScreen getInstance() {
        return new MainConfigScreen();
    }

    public void loadConfig() {
        this.enableMod = SeasonHudClient.getEnableMod();
        this.showMinimapHidden = SeasonHudClient.getShowDefaultWhenMinimapHidden();
        this.enableMinimapIntegration = SeasonHudClient.getEnableMinimapIntegration();
        if (CurrentMinimap.journeyMapLoaded()) {
            this.journeyMapAboveMap = SeasonHudClient.getJourneyMapAboveMap();
            this.journeyMapMacOS = SeasonHudClient.getJourneyMapMacOS();
        }
    }

    @Override
    public void saveConfig() {
        SeasonHudClient.setEnableMod(this.enableMod);
        SeasonHudClient.setEnableMinimapIntegration(this.enableMinimapIntegration);
        SeasonHudClient.setShowDefaultWhenMinimapHidden(this.showMinimapHidden);
        if (CurrentMinimap.journeyMapLoaded()) {
            SeasonHudClient.setJourneyMapAboveMap(this.journeyMapAboveMap);
            SeasonHudClient.setJourneyMapMacOS(this.journeyMapMacOS);
        }
    }

    @Override
    public void onDone() {
        this.saveConfig();
        super.onDone();
    }

    @Override
    public void method_25419() {
        super.method_25419();
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        int n = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        graphics.method_27534(this.field_22793, MINIMAP_SETTINGS, n, 50 + 2 * (this.BUTTON_HEIGHT + 6) - (9 + 6), 0xFFFFFF);
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            int n2 = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            graphics.method_27534(this.field_22793, JOURNEYMAP, n2, 50 + 4 * (this.BUTTON_HEIGHT + 6) - (9 + 6), 0xFFFFFF);
            this.journeyMapAboveMapButton.field_22763 = this.enableMod;
            this.journeyMapMacOSButton.field_22763 = this.enableMod;
        }
        this.seasonButton.field_22763 = this.enableMod;
        this.colorButton.field_22763 = this.enableMod;
        this.enableMinimapIntegrationButton.field_22763 = this.enableMod;
        this.showMinimapHiddenButton.field_22763 = this.enableMod;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        int enableModWidth = this.field_22793.method_27525((class_5348)Common.translatedText("menu.seasonhud.main.enableMod.button").method_27693(": OFF")) + 8;
        class_5676 enableModButton = class_5676.method_32613((boolean)this.enableMod).method_32618(t -> Common.newTooltip("menu.seasonhud.main.enableMod.tooltip")).method_32617(this.field_22789 - enableModWidth - 5, 5, enableModWidth, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.main.enableMod.button"), (b, val) -> {
            this.enableMod = val;
        });
        int row = 0;
        this.seasonButton = MenuButton.builder(MenuButton.MenuButtons.SEASON, b -> {
            this.saveConfig();
            SeasonOptionsScreen.getInstance(this).open();
        }).withTooltip(Common.newTooltip("menu.seasonhud.main.season.tooltip")).withPos(this.leftButtonX, this.buttonStartY + row * this.yOffset).withWidth(this.BUTTON_WIDTH).build();
        this.colorButton = MenuButton.builder(MenuButton.MenuButtons.COLORS, b -> {
            this.saveConfig();
            ColorScreen.getInstance(this).open();
        }).withTooltip(Common.newTooltip("menu.seasonhud.main.color.tooltip")).withPos(this.rightButtonX, this.buttonStartY + row * this.yOffset).withWidth(this.BUTTON_WIDTH).build();
        row = 2;
        this.enableMinimapIntegrationButton = class_5676.method_32613((boolean)this.enableMinimapIntegration).method_32618(t -> Common.newTooltip("menu.seasonhud.main.minimapIntegration.tooltip")).method_32617(this.leftButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.main.enableMinimapIntegration.button"), (b, val) -> {
            this.enableMinimapIntegration = val;
        });
        this.showMinimapHiddenButton = class_5676.method_32613((boolean)this.showMinimapHidden).method_32618(t -> Common.newTooltip("menu.seasonhud.main.showMinimapHidden.tooltip")).method_32617(this.rightButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.main.showMinimapHidden.button"), (b, val) -> {
            this.showMinimapHidden = val;
        });
        this.widgets.addAll(Arrays.asList(new class_4264[]{this.seasonButton, this.colorButton, enableModButton, this.enableMinimapIntegrationButton, this.showMinimapHiddenButton}));
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            this.journeyMapAboveMapButton = class_5676.method_32613((boolean)this.journeyMapAboveMap).method_32618(t -> Common.newTooltip("menu.seasonhud.main.journeymap.aboveMap.tooltip")).method_32617(this.leftButtonX, this.buttonStartY + (row += 2) * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.main.journeymap.aboveMap.button"), (b, val) -> {
                this.journeyMapAboveMap = val;
            });
            this.journeyMapMacOSButton = class_5676.method_32613((boolean)this.journeyMapMacOS).method_32618(t -> Common.newTooltip("menu.seasonhud.main.journeymap.macOS.tooltip")).method_32617(this.rightButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.main.journeymap.macOS.button"), (b, val) -> {
                this.journeyMapMacOS = val;
            });
            this.widgets.add(this.journeyMapAboveMapButton);
            this.widgets.add(this.journeyMapMacOSButton);
        }
        this.widgets.forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }
}

