/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import journeymap.client.JourneymapClient;
import journeymap.client.io.ThemeLoader;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeLabelSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;

public class JourneyMapCommon {
    private final class_5250 seasonCombined;
    private final boolean fontShadow;
    private final float fontScale;
    private final float labelAlpha;
    private final float textAlpha;
    private final double textureX;
    private final double textureY;
    private final int minimapHeight;
    private final int halfWidth;
    private final int margin;
    private final int labelColor;
    private final int textColor;
    private final int labelHeight;
    private final int topLabelHeight;
    private final int bottomLabelHeight;
    private final double scaledWidth;
    private final double scaledHeight;
    private double screenWidth;
    private double screenHeight;

    public JourneyMapCommon(class_310 mc) {
        class_327 fontRenderer = mc.field_1772;
        this.seasonCombined = CurrentSeason.getInstance(mc).getSeasonHudText();
        JourneymapClient jm = JourneymapClient.getInstance();
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        MiniMapProperties mapProperties = jm.getActiveMiniMapProperties();
        Theme.LabelSpec currentTheme = ThemeLoader.getCurrentTheme().minimap.square.labelBottom;
        this.fontShadow = currentTheme.shadow;
        this.fontScale = jm.getActiveMiniMapProperties().fontScale.get().floatValue();
        this.labelAlpha = jm.getActiveMiniMapProperties().infoSlotAlpha.get().floatValue();
        this.textAlpha = currentTheme.foreground.alpha;
        this.textureX = vars.textureX;
        this.textureY = vars.textureY;
        this.minimapHeight = vars.minimapHeight;
        int minimapWidth = vars.minimapWidth;
        this.halfWidth = minimapWidth / 2;
        this.margin = ThemeLoader.getCurrentTheme().minimap.square.margin;
        this.labelColor = currentTheme.background.getColor();
        this.textColor = currentTheme.foreground.getColor();
        this.labelHeight = (int)((float)(DrawUtil.getLabelHeight((class_327)fontRenderer, (boolean)this.fontShadow) + currentTheme.margin) * this.fontScale);
        this.topLabelHeight = vars.getInfoLabelAreaHeight(fontRenderer, currentTheme, new ThemeLabelSource.InfoSlot[]{(ThemeLabelSource.InfoSlot)ThemeLabelSource.values.get(mapProperties.info1Label.get()), (ThemeLabelSource.InfoSlot)ThemeLabelSource.values.get(mapProperties.info2Label.get())});
        this.bottomLabelHeight = vars.getInfoLabelAreaHeight(fontRenderer, currentTheme, new ThemeLabelSource.InfoSlot[]{(ThemeLabelSource.InfoSlot)ThemeLabelSource.values.get(mapProperties.info3Label.get()), (ThemeLabelSource.InfoSlot)ThemeLabelSource.values.get(mapProperties.info4Label.get())});
        this.screenWidth = mc.method_22683().method_4489();
        this.screenHeight = mc.method_22683().method_4506();
        if (SeasonHudClient.getJourneyMapMacOS()) {
            this.screenWidth /= 2.0;
            this.screenHeight /= 2.0;
        }
        double guiScale = mc.method_22683().method_4495();
        this.scaledWidth = this.screenWidth / guiScale;
        this.scaledHeight = this.screenHeight / guiScale;
    }

    public static JourneyMapCommon getInstance(class_310 mc) {
        return new JourneyMapCommon(mc);
    }

    private int labelX() {
        return (int)(this.textureX + (double)this.halfWidth);
    }

    private int labelY() {
        int startY = (int)(this.textureY + (double)(SeasonHudClient.getJourneyMapAboveMap() ? 0 : (SeasonHudClient.getJourneyMapMacOS() ? -this.margin - this.labelHeight : this.minimapHeight + this.margin)));
        return startY + (SeasonHudClient.getJourneyMapAboveMap() ? -this.topLabelHeight - this.margin - this.labelHeight : this.bottomLabelHeight);
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public double getScreenWidth() {
        return this.screenWidth;
    }

    public double getScreenHeight() {
        return this.screenHeight;
    }

    public void drawSeasonLabel(class_332 graphics) {
        class_4597.class_4598 buffers = graphics.method_51450();
        buffers.method_22993();
        DrawUtil.drawBatchLabel((class_4587)graphics.method_51448(), (class_2561)this.seasonCombined, (class_4597)buffers, (double)this.labelX(), (double)this.labelY(), (DrawUtil.HAlign)DrawUtil.HAlign.Center, (DrawUtil.VAlign)DrawUtil.VAlign.Below, (Integer)this.labelColor, (float)this.labelAlpha, (int)this.textColor, (float)this.textAlpha, (double)this.fontScale, (boolean)this.fontShadow);
        graphics.method_51450().method_22993();
        DrawUtil.sizeDisplay((class_4587)graphics.method_51448(), (double)this.scaledWidth, (double)this.scaledHeight);
    }
}

