/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.util.Rgb;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.class_2561;

public enum Seasons {
    SPRING(0, "desc.seasonhud.season.spring", "spring", "\uea00", 16753595, SeasonHudClient.getSpringColor(), Rgb.seasonMap(SeasonHudClient.getSpringColor())),
    SUMMER(1, "desc.seasonhud.season.summer", "summer", "\uea01", 16705834, SeasonHudClient.getSummerColor(), Rgb.seasonMap(SeasonHudClient.getSummerColor())),
    AUTUMN(2, "desc.seasonhud.season.autumn", "autumn", "\uea02", 12344871, SeasonHudClient.getAutumnColor(), Rgb.seasonMap(SeasonHudClient.getAutumnColor())),
    WINTER(3, "desc.seasonhud.season.winter", "winter", "\uea03", 0xDFFCFC, SeasonHudClient.getWinterColor(), Rgb.seasonMap(SeasonHudClient.getWinterColor())),
    DRY(4, "desc.seasonhud.season.dry", "dry", "\uea04", 16745216, SeasonHudClient.getDryColor(), Rgb.seasonMap(SeasonHudClient.getDryColor())),
    WET(5, "desc.seasonhud.season.wet", "wet", "\uea05", 2068975, SeasonHudClient.getWetColor(), Rgb.seasonMap(SeasonHudClient.getWetColor())),
    NULL(100, "desc.seasonhud.season.null", "null", "\uea99", 0xFFFFFF, 0xFFFFFF, Rgb.seasonMap(0xFFFFFF));

    public static final EnumSet<Seasons> SEASONS_ENUM_LIST;
    private final int id;
    private final String key;
    private final String seasonFileName;
    private final String seasonIconChar;
    private final int defaultColor;
    private final Map<String, Integer> rgbMap;
    private final class_2561 seasonName;
    private int seasonColor;

    private Seasons(int id, String key, String fileName, String iconChar, int defaultColor, int seasonColor, Map<String, Integer> rgbMap) {
        this.id = id;
        this.key = key;
        this.seasonFileName = fileName;
        this.seasonIconChar = iconChar;
        this.defaultColor = defaultColor;
        this.seasonColor = seasonColor;
        this.rgbMap = rgbMap;
        this.seasonName = Common.translatedText(key);
    }

    public int getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getFileName() {
        return this.seasonFileName;
    }

    public String getIconChar() {
        return this.seasonIconChar;
    }

    public int getSeasonColor() {
        return this.seasonColor;
    }

    public void setSeasonColor(int rgbColor) {
        Seasons season = this;
        this.seasonColor = rgbColor;
        switch (season.ordinal()) {
            case 0: {
                SeasonHudClient.setSpringColor(rgbColor);
                break;
            }
            case 1: {
                SeasonHudClient.setSummerColor(rgbColor);
                break;
            }
            case 2: {
                SeasonHudClient.setAutumnColor(rgbColor);
                break;
            }
            case 3: {
                SeasonHudClient.setWinterColor(rgbColor);
                break;
            }
            case 4: {
                SeasonHudClient.setDryColor(rgbColor);
                break;
            }
            case 5: {
                SeasonHudClient.setWetColor(rgbColor);
            }
        }
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    public Map<String, Integer> getRgbMap() {
        return this.rgbMap;
    }

    public class_2561 getSeasonName() {
        return this.seasonName;
    }

    static {
        SEASONS_ENUM_LIST = EnumSet.allOf(Seasons.class);
    }
}

