/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.Location;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.client.gui.components.buttons.CycleButton;
import club.iananderson.seasonhud.client.gui.components.sliders.HudOffsetSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.HudScaleSlider;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class SeasonOptionsScreen
extends SeasonHudScreen {
    private static final class_2561 SCREEN_TITLE = Common.translatedText("menu.seasonhud.season.title");
    private Location hudLocation;
    private int xSliderInt;
    private int ySliderInt;
    private double seasonScale;
    private ShowDay showDay;
    private boolean seasonColor;
    private boolean showSubSeason;
    private boolean showTropicalSeason;
    private boolean needCalendar;
    private boolean enableCalendarDetail;
    private boolean drawDefaultHud;
    private int dayLength;
    private int newDayLength;
    private CycleButton<Location> hudLocationButton;
    private HudOffsetSlider xSlider;
    private HudOffsetSlider ySlider;
    private HudScaleSlider hudScaleSlider;
    private class_342 dayLengthBox;

    public SeasonOptionsScreen(class_437 parentScreen) {
        super(parentScreen, SCREEN_TITLE);
    }

    public static SeasonOptionsScreen getInstance(class_437 parentScreen) {
        return new SeasonOptionsScreen(parentScreen);
    }

    public void loadConfig() {
        this.drawDefaultHud = Common.drawDefaultHudMenu();
        this.hudLocation = SeasonHudClient.getHudLocation();
        this.xSliderInt = SeasonHudClient.getHudX();
        this.ySliderInt = SeasonHudClient.getHudY();
        this.seasonScale = SeasonHudClient.getHudScale();
        this.showDay = SeasonHudClient.getShowDay();
        this.seasonColor = SeasonHudClient.getEnableSeasonNameColor();
        this.showSubSeason = SeasonHudClient.getShowSubSeason();
        this.showTropicalSeason = SeasonHudClient.getShowTropicalSeason();
        if (Common.hasCalendarLoaded()) {
            this.needCalendar = SeasonHudServer.getNeedCalendar();
            this.enableCalendarDetail = SeasonHudServer.getCalendarDetailMode();
        }
        if (Common.fabricSeasonsLoaded()) {
            this.dayLength = SeasonHudServer.getDayLength();
        }
    }

    @Override
    public void saveConfig() {
        if (this.drawDefaultHud) {
            SeasonHudClient.setHudLocation(this.hudLocationButton.getValue());
            SeasonHudClient.setHudX(this.xSlider.getValueInt());
            SeasonHudClient.setHudY(this.ySlider.getValueInt());
            SeasonHudClient.setHudScale(this.hudScaleSlider.getValueDouble());
        }
        SeasonHudClient.setShowDay(this.showDay);
        SeasonHudClient.setEnableSeasonNameColor(this.seasonColor);
        if (Common.hasSubSeasons()) {
            SeasonHudClient.setShowSubSeason(this.showSubSeason);
            SeasonHudClient.setShowTropicalSeason(this.showTropicalSeason);
        }
        if (Common.clientSideConfig()) {
            if (Common.hasCalendarLoaded()) {
                SeasonHudServer.setCalendarDetailMode(this.enableCalendarDetail);
                SeasonHudServer.setNeedCalendar(this.needCalendar);
            }
            if (Common.fabricSeasonsLoaded()) {
                SeasonHudServer.setDayLength(Integer.parseInt(this.dayLengthBox.method_1882()));
            }
        }
    }

    @Override
    public void onDone() {
        this.saveConfig();
        super.onDone();
    }

    @Override
    public void method_25419() {
        super.method_25419();
    }

    @Override
    public void method_25394(@NotNull class_4587 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        int x = 3;
        int y = 3;
        this.seasonScale = 1.0;
        class_5250 seasonCombined = CurrentSeason.getInstance(this.field_22787).getSeasonHudConfigText(this.showDay, this.showSubSeason);
        if (this.drawDefaultHud) {
            int DEFAULT_X_OFFSET_SCALED = 2;
            int DEFAULT_Y_OFFSET_SCALED = 2;
            this.seasonScale = this.hudScaleSlider.getValueDouble();
            int componentWidth = (int)((double)this.field_22793.method_27525((class_5348)seasonCombined) * this.seasonScale);
            Objects.requireNonNull(this.field_22793);
            int componentHeight = (int)(9.0 * this.seasonScale);
            boolean customLocation = this.hudLocationButton.getValue() == Location.CUSTOM;
            this.hudScaleSlider.field_22764 = this.drawDefaultHud;
            this.xSlider.field_22763 = customLocation;
            this.xSlider.field_22764 = this.drawDefaultHud;
            this.ySlider.field_22763 = customLocation;
            this.ySlider.field_22764 = this.drawDefaultHud;
            switch (this.hudLocation) {
                case TOP_LEFT: {
                    x = DEFAULT_X_OFFSET_SCALED;
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case TOP_CENTER: {
                    x = (int)(((double)this.field_22789 / 2.0 - (double)componentWidth / 2.0) / this.seasonScale);
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case TOP_RIGHT: {
                    x = (int)((double)(this.field_22789 - componentWidth - DEFAULT_X_OFFSET_SCALED) / this.seasonScale);
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case BOTTOM_LEFT: {
                    x = DEFAULT_X_OFFSET_SCALED;
                    y = (int)((double)(this.field_22790 - componentHeight - DEFAULT_Y_OFFSET_SCALED) / this.seasonScale);
                    break;
                }
                case BOTTOM_RIGHT: {
                    x = (int)((double)(this.field_22789 - componentWidth - DEFAULT_X_OFFSET_SCALED) / this.seasonScale);
                    y = (int)((double)(this.field_22790 - componentHeight - DEFAULT_Y_OFFSET_SCALED) / this.seasonScale);
                    break;
                }
                case CUSTOM: {
                    x = this.xSlider.getValueInt();
                    y = this.ySlider.getValueInt();
                }
            }
        }
        if (Common.fabricSeasonsLoaded() && Common.clientSideConfig()) {
            int row = 4;
            if (Common.fabricSeasonsExtrasLoaded()) {
                ++row;
            }
            if (!this.drawDefaultHud) {
                row -= 2;
            }
            int n = this.leftButtonX + this.BUTTON_WIDTH / 2;
            Objects.requireNonNull(this.field_22793);
            class_332.method_25300((class_4587)graphics, (class_327)this.field_22793, (String)"Day Length", (int)n, (int)(50 + row * (this.BUTTON_HEIGHT + 6) - (9 + 6)), (int)0xFFFFFF);
        }
        graphics.method_22903();
        graphics.method_22904(0.0, 0.0, 50.0);
        graphics.method_22905((float)this.seasonScale, (float)this.seasonScale, 1.0f);
        class_332.method_27535((class_4587)graphics, (class_327)this.field_22793, (class_2561)seasonCombined, (int)x, (int)y, (int)0xFFFFFF);
        graphics.method_22909();
    }

    private int maxWidth(class_5250 seasonText) {
        int textWidth = this.field_22793.method_27525((class_5348)seasonText);
        return (int)(((double)this.field_22789 - (double)textWidth * this.seasonScale) / this.seasonScale);
    }

    private int maxHeight() {
        Objects.requireNonNull(this.field_22793);
        int textHeight = 9;
        return (int)(((double)this.field_22790 - (double)textHeight * this.seasonScale) / this.seasonScale);
    }

    @Override
    public void method_25426() {
        this.loadConfig();
        super.method_25426();
        class_5250 seasonCombined = CurrentSeason.getInstance(this.field_22787).getSeasonHudText();
        this.row = -1;
        if (this.drawDefaultHud) {
            ++this.row;
            this.hudLocationButton = CycleButton.builder(Location::getLocationName).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.hudLocation.tooltip")).withValues((Location[])Location.values()).withInitialValue(this.hudLocation).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.hudLocation.button"), (b, val) -> {
                this.hudLocation = val;
            });
            this.hudScaleSlider = HudScaleSlider.builder((class_2561)Common.translatedText("menu.seasonhud.season.scale.slider")).withValueRange(0.5, 10.0).withInitialValue(this.seasonScale).withDefaultValue(1.0).withStepSize(0.5).withPrecision(1).withBounds(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT).build();
            ++this.row;
            this.xSlider = HudOffsetSlider.builder((class_2561)Common.translatedText("menu.seasonhud.season.xOffset.slider")).withValues(0, this.maxWidth(seasonCombined), this.xSliderInt, 2).withBounds(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH / 2 - 2, this.BUTTON_HEIGHT).build();
            this.ySlider = HudOffsetSlider.builder((class_2561)Common.translatedText("menu.seasonhud.season.yOffset.slider")).withValues(0, this.maxHeight(), this.ySliderInt, 2).withBounds(this.rightButtonX + this.BUTTON_WIDTH / 2 + 2, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH / 2 - 2, this.BUTTON_HEIGHT).build();
            this.widgets.addAll(Arrays.asList(new class_339[]{this.hudLocationButton, this.hudScaleSlider, this.xSlider, this.ySlider}));
        }
        ++this.row;
        CycleButton<ShowDay> showDayButton = CycleButton.builder(ShowDay::getDayDisplayName).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.showDay.tooltip")).withValues(ShowDay.getValues()).withInitialValue(this.showDay).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.showDay.button"), (b, val) -> {
            this.showDay = val;
        });
        CycleButton<Boolean> seasonColorButton = CycleButton.onOffBuilder(this.seasonColor).withTooltip(t -> Common.newTooltip("menu.seasonhud.color.enableSeasonNameColor.tooltip")).create(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.color.enableSeasonNameColor.button"), (b, val) -> {
            this.seasonColor = val;
        });
        this.widgets.addAll(Arrays.asList(showDayButton, seasonColorButton));
        if (Common.hasSubSeasons()) {
            ++this.row;
            CycleButton<Boolean> showSubSeasonButton = CycleButton.onOffBuilder(this.showSubSeason).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.showSubSeason.tooltip")).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.showSubSeason.button"), (b, val) -> {
                this.showSubSeason = val;
            });
            CycleButton<Boolean> showTropicalSeasonButton = CycleButton.onOffBuilder(this.showTropicalSeason).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.showTropicalSeason.tooltip")).create(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.showTropicalSeason.button"), (b, val) -> {
                this.showTropicalSeason = val;
            });
            this.widgets.addAll(Arrays.asList(showSubSeasonButton, showTropicalSeasonButton));
        }
        if (Common.hasCalendarLoaded()) {
            ++this.row;
            CycleButton<Boolean> needCalendarButton = CycleButton.onOffBuilder(this.needCalendar).withTooltip(t -> {
                if (!Common.clientSideConfig()) {
                    return Common.newTooltip("menu.seasonhud.season.serverSide.tooltip");
                }
                return Common.newTooltip("menu.seasonhud.season.needCalendar.tooltip");
            }).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.needCalendar.button"), (b, val) -> {
                this.needCalendar = val;
            });
            needCalendarButton.field_22763 = Common.clientSideConfig();
            CycleButton<Boolean> calendarDetailModeButton = CycleButton.onOffBuilder(this.enableCalendarDetail).withTooltip(t -> {
                if (!Common.clientSideConfig()) {
                    return Common.newTooltip("menu.seasonhud.season.serverSide.tooltip");
                }
                return Common.newTooltip("menu.seasonhud.season.calendarDetail.tooltip");
            }).create(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (class_2561)Common.translatedText("menu.seasonhud.season.calendarDetail.button"), (b, val) -> {
                this.enableCalendarDetail = val;
            });
            if (!Common.clientSideConfig()) {
                needCalendarButton.field_22763 = false;
                calendarDetailModeButton.field_22763 = false;
            }
            this.widgets.addAll(Arrays.asList(needCalendarButton, calendarDetailModeButton));
        }
        if (Common.fabricSeasonsLoaded()) {
            this.row += 2;
            this.dayLengthBox = new class_342(this.field_22793, this.leftButtonX + 1, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH - 2, this.BUTTON_HEIGHT, (class_2561)Common.literalText(String.valueOf(this.dayLength)));
            this.dayLengthBox.method_1880(10);
            this.dayLengthBox.method_1852(String.valueOf(this.dayLength));
            this.dayLengthBox.method_1863(lengthString -> {
                if (this.validate((String)lengthString)) {
                    this.dayLengthBox.method_1868(0xFFFFFF);
                    int currentLength = Integer.parseInt(lengthString);
                    if (currentLength != this.newDayLength) {
                        this.newDayLength = currentLength;
                        this.dayLengthBox.method_1852(lengthString);
                    }
                    SeasonOptionsScreen.doneButton.field_22763 = true;
                } else {
                    this.dayLengthBox.method_1868(0xFF5555);
                    SeasonOptionsScreen.doneButton.field_22763 = false;
                }
            });
            this.dayLengthBox.field_22764 = Common.clientSideConfig();
            this.widgets.add(this.dayLengthBox);
        }
        this.widgets.forEach(x$0 -> this.method_25411((class_339)x$0));
    }

    private boolean inBounds(int length) {
        int minInt = 0;
        return length >= minInt;
    }

    public boolean validate(String length) {
        try {
            int dayLength = Integer.parseInt(length);
            return this.inBounds(dayLength);
        }
        catch (NumberFormatException formatException) {
            return false;
        }
    }
}

