/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.config;

import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class SeasonHudServer {
    public static final ForgeConfigSpec SERVER_SPEC;
    static ForgeConfigSpec.ConfigValue<Boolean> needCalendar;
    static ForgeConfigSpec.ConfigValue<Integer> dayLength;
    static ForgeConfigSpec.ConfigValue<Boolean> calendarDetailMode;

    private SeasonHudServer() {
    }

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Season");
        needCalendar = builder.comment("Require the calendar item to be in the players inventory to show the HUD?\n(true/false)\nDefault is false.").define("need_calendar", false);
        calendarDetailMode = builder.comment("Having the calendar item shows the detailed version of the HUDDefault is false.").define("calendar_detail", false);
        dayLength = builder.comment("Change if you are using a Minecraft day length other than vanilla value and using Fabric Seasons.\nDefault Minecraft day is 24000.").defineInRange("day_length", 24000, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    private static Object getDefault(ForgeConfigSpec.ConfigValue<?> config) {
        HashMap<List, Comparable<Boolean>> configOptions = new HashMap<List, Comparable<Boolean>>();
        configOptions.put(needCalendar.getPath(), Boolean.valueOf(false));
        configOptions.put(calendarDetailMode.getPath(), Boolean.valueOf(false));
        configOptions.put(dayLength.getPath(), Integer.valueOf(24000));
        return configOptions.get(config.getPath());
    }

    private static Object getOrDefault(ForgeConfigSpec.ConfigValue<?> config) {
        if (SERVER_SPEC.isLoaded()) {
            return config.get();
        }
        return SeasonHudServer.getDefault(config);
    }

    public static boolean getNeedCalendar() {
        return (Boolean)SeasonHudServer.getOrDefault(needCalendar);
    }

    public static void setNeedCalendar(boolean enable) {
        needCalendar.set((Object)enable);
    }

    public static boolean getCalendarDetailMode() {
        return (Boolean)SeasonHudServer.getOrDefault(calendarDetailMode);
    }

    public static void setCalendarDetailMode(boolean enable) {
        calendarDetailMode.set((Object)enable);
    }

    public static int getDayLength() {
        return (Integer)SeasonHudServer.getOrDefault(dayLength);
    }

    public static void setDayLength(int length) {
        dayLength.set((Object)length);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SeasonHudServer.setupConfig(builder);
        SERVER_SPEC = builder.build();
    }
}

